/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.aglets.tahiti;

import com.ibm.aglets.tahiti.BorderPanel;
import com.ibm.aglets.tahiti.GridBagPanel;
import com.ibm.aglets.tahiti.MainWindow;
import com.ibm.aglets.tahiti.TahitiDialog;
import com.ibm.awb.misc.Resource;
import java.awt.Button;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Label;
import java.awt.List;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;

final class ServerPrefsDialog
extends TahitiDialog
implements ActionListener,
ItemListener {
    private TextField _pubRoot;
    private List _aliases;
    private TextField _alias_1;
    private TextField _alias_2;
    private Button _alias_add;
    private Button _alias_remove;
    private Button _alias_modify;
    private static final String ALIASES_SEP = " -> ";
    private static ServerPrefsDialog _instance = null;

    private ServerPrefsDialog(MainWindow mainWindow) {
        super(mainWindow, "Server Preferences", true);
        this.makePanel();
        this.addButton("OK", this);
        this.addButton("Cancel", this);
        this.addButton("Restore Defaults", this);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if ("Add".equals(string)) {
            String string2 = this._alias_1.getText();
            String string3 = this._alias_2.getText();
            if (!string2.startsWith("/")) {
                string2 = "/" + string2;
            }
            try {
                String string4 = this.getAliasEntry(string2, string3);
                String[] stringArray = this._aliases.getItems();
                int n = 0;
                while (n < stringArray.length) {
                    if (string4.equals(stringArray[n])) break;
                    ++n;
                }
                if (n >= stringArray.length) {
                    this._aliases.add(string4);
                }
            }
            catch (NullPointerException nullPointerException) {}
        } else if ("Remove".equals(string)) {
            int n = this._aliases.getSelectedIndex();
            if (n >= 0) {
                this._aliases.remove(n);
            }
        } else if ("Modify".equals(string)) {
            int n = this._aliases.getSelectedIndex();
            String string5 = this._alias_1.getText();
            String string6 = this._alias_2.getText();
            if (n >= 0) {
                try {
                    String string7 = this.getAliasEntry(string5, string6);
                    this._aliases.replaceItem(string7, n);
                }
                catch (NullPointerException nullPointerException) {}
            }
        } else if ("OK".equals(string)) {
            this.commitValues();
            this.dispose();
        } else if ("Cancel".equals(string)) {
            this.dispose();
        } else if ("Restore Defaults".equals(string)) {
            this.updateValues();
        }
    }

    private void commitValues() {
        Resource resource = Resource.getResourceFor("aglets");
        String string = this._pubRoot.getText();
        if (!string.endsWith(File.separator)) {
            string = string + File.separator;
        }
        resource.setResource("aglets.public.root", string);
        StringBuffer stringBuffer = new StringBuffer();
        String[] stringArray = this._aliases.getItems();
        if (stringArray != null && stringArray.length > 0) {
            stringBuffer.append(stringArray[0]);
            int n = 1;
            while (n < stringArray.length) {
                stringBuffer.append("," + stringArray[n]);
                ++n;
            }
        }
        resource.setResource("aglets.public.aliases", stringBuffer.toString());
        String string2 = resource.getString("aglets.class.path");
        if (string2 == null) {
            string2 = "";
        }
        if ((string2 = string2.trim()).length() > 0 && string2.charAt(string2.length() - 1) != ',') {
            string2 = string2 + ",";
        }
        string2 = string2 + string;
        resource.setResource("aglets.class.path", string2);
    }

    private String getAliasEntry(String string, String string2) throws NullPointerException {
        if (string.length() == 0 || string2.length() == 0) {
            throw new NullPointerException();
        }
        if (!string.endsWith("/")) {
            string = string + "/";
        }
        if (!string2.endsWith(File.separator)) {
            string2 = string2 + File.separator;
        }
        return string + ALIASES_SEP + string2;
    }

    static ServerPrefsDialog getInstance(MainWindow mainWindow) {
        if (_instance == null) {
            _instance = new ServerPrefsDialog(mainWindow);
        } else {
            _instance.updateValues();
        }
        return _instance;
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getItemSelectable() == this._aliases && itemEvent.getStateChange() == 1) {
            int n;
            int n2 = (Integer)itemEvent.getItem();
            String string = this._aliases.getItem(n2);
            String string2 = string.substring(0, n = string.indexOf(ALIASES_SEP));
            if (string2.startsWith("/")) {
                string2 = string2.substring(1);
            }
            String string3 = string.substring(n + ALIASES_SEP.length());
            this._alias_1.setText(string2);
            this._alias_2.setText(string3);
        }
    }

    protected void makePanel() {
        GridBagPanel gridBagPanel = new GridBagPanel();
        this.add("Center", gridBagPanel);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagPanel.setConstraints(gridBagConstraints);
        BorderPanel borderPanel = new BorderPanel("Root Path");
        gridBagPanel.add((Component)borderPanel, 0);
        this.setupPubRootPanel(borderPanel);
        this.updateValues();
    }

    private void setupPubRootPanel(BorderPanel borderPanel) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = borderPanel.topInsets();
        borderPanel.add((Component)new Label("Public Root:"), gridBagConstraints);
        this._pubRoot = new TextField(40);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        borderPanel.add((Component)this._pubRoot, gridBagConstraints);
        BorderPanel borderPanel2 = new BorderPanel("Aliases");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        borderPanel.add((Component)borderPanel2, gridBagConstraints);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.anchor = 17;
        gridBagConstraints2.fill = 1;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.weighty = 1.0;
        gridBagConstraints2.insets = borderPanel2.topInsets();
        gridBagConstraints2.insets.bottom = borderPanel2.bottomInsets().bottom;
        borderPanel2.setConstraints(gridBagConstraints2);
        GridBagPanel gridBagPanel = new GridBagPanel();
        borderPanel2.add(gridBagPanel);
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.anchor = 17;
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.weighty = 1.0;
        gridBagPanel.setConstraints(gridBagConstraints2);
        this._aliases = new List(5);
        this._aliases.addActionListener(this);
        this._aliases.addItemListener(this);
        gridBagPanel.add((Component)this._aliases, 0, 0.1);
        this._alias_1 = new TextField(20);
        this._alias_2 = new TextField(20);
        Panel panel = new GridBagPanel();
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.fill = 2;
        gridBagConstraints3.weightx = 1.0;
        gridBagConstraints3.weighty = 0.0;
        ((GridBagPanel)panel).setConstraints(gridBagConstraints3);
        ((GridBagPanel)panel).add(new Label("/"));
        ((GridBagPanel)panel).add(this._alias_1);
        ((GridBagPanel)panel).add((Component)new Label("->"), new GridBagConstraints());
        ((GridBagPanel)panel).add(this._alias_2);
        gridBagPanel.add(panel);
        this._alias_add = new Button("Add");
        this._alias_remove = new Button("Remove");
        this._alias_modify = new Button("Modify");
        this._alias_add.addActionListener(this);
        this._alias_remove.addActionListener(this);
        this._alias_modify.addActionListener(this);
        panel = new Panel(new FlowLayout(2));
        panel.add(this._alias_add);
        panel.add(this._alias_remove);
        panel.add(this._alias_modify);
        gridBagPanel.add((Component)panel, 0);
    }

    private void updateValues() {
        Resource resource = Resource.getResourceFor("aglets");
        String string = resource.getString("aglets.public.root", "");
        String[] stringArray = resource.getStringArray("aglets.public.aliases", ",");
        this._pubRoot.setText(string);
        this._aliases.removeAll();
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n] != null && stringArray[n].length() > 0) {
                int n2 = stringArray[n].indexOf(ALIASES_SEP);
                if (n2 < 0) {
                    System.out.println("Illegal resource setting in aglets.properties: " + stringArray[n]);
                } else {
                    this._aliases.add(stringArray[n]);
                }
            }
            ++n;
        }
    }
}

