/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.aglets.tahiti;

import com.ibm.aglets.PersistentEntry;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;

final class SimplePEntry
implements PersistentEntry {
    File file;

    SimplePEntry(File file) {
        this.file = file;
    }

    public InputStream getInputStream() throws FileNotFoundException {
        try {
            final File file = this.file;
            return (InputStream)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws FileNotFoundException {
                    return new FileInputStream(file);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (FileNotFoundException)privilegedActionException.getException();
        }
    }

    public OutputStream getOutputStream() throws IOException {
        try {
            final File file = this.file;
            return (OutputStream)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    if (!file.exists()) {
                        File file2 = file.getCanonicalFile().getParentFile();
                        file2.mkdirs();
                        file.createNewFile();
                    }
                    return new FileOutputStream(file);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (IOException)privilegedActionException.getException();
        }
    }
}

