/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.aglets.tahiti;

import com.ibm.aglet.AgletContext;
import com.ibm.aglet.AgletProxy;
import com.ibm.aglet.system.AgletRuntime;
import com.ibm.aglet.system.ContextEvent;
import com.ibm.aglet.system.ContextListener;
import com.ibm.aglets.tahiti.Item;
import com.ibm.aglets.tahiti.TahitiDaemonUserManager;
import com.ibm.aglets.tahiti.UserManager;
import com.ibm.awb.misc.Debug;
import com.ibm.awb.misc.Resource;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;

public final class TahitiDaemon
implements ContextListener,
Runnable {
    private Hashtable aglets = new Hashtable();
    private String prompt = ">";
    private AgletContext context = null;
    private boolean message = false;
    private boolean debug = false;
    private boolean continue_processing = true;
    private boolean reboot = false;
    private boolean shutdown = false;
    private static int _control_port_num = 5545;
    private static UserManager _userManager = new TahitiDaemonUserManager();
    private static int serial = 0;
    private static String _banner_string = "TahitiDaemon";
    private static String _version_string = "1.0";

    public void agletActivated(ContextEvent contextEvent) {
        if (this.message) {
            System.out.println("Activated " + contextEvent.getAgletProxy());
        }
    }

    public void agletArrived(ContextEvent contextEvent) {
        this.added(contextEvent.getAgletProxy());
    }

    public void agletCloned(ContextEvent contextEvent) {
        this.added(contextEvent.getAgletProxy());
    }

    public void agletCreated(ContextEvent contextEvent) {
        this.added(contextEvent.getAgletProxy());
    }

    public void agletDeactivated(ContextEvent contextEvent) {
        if (this.message) {
            System.out.println("Deactivated " + contextEvent.getAgletProxy());
        }
    }

    public void agletDispatched(ContextEvent contextEvent) {
    }

    public void agletDisposed(ContextEvent contextEvent) {
        this.removed(contextEvent.getAgletProxy());
    }

    public void agletResumed(ContextEvent contextEvent) {
        if (this.message) {
            System.out.println("Resumed " + contextEvent.getAgletProxy());
        }
    }

    public void agletReverted(ContextEvent contextEvent) {
        this.removed(contextEvent.getAgletProxy());
    }

    public void agletStateChanged(ContextEvent contextEvent) {
        Hashtable hashtable = this.aglets;
        synchronized (hashtable) {
            Enumeration enumeration = this.aglets.keys();
            while (enumeration.hasMoreElements()) {
                Object k = enumeration.nextElement();
                Item item = (Item)this.aglets.get(k);
                if (!item.equals(contextEvent.getAgletProxy())) continue;
                item.setText((String)contextEvent.arg);
                if (!this.message) continue;
                System.out.println(k.toString() + " : " + contextEvent.arg);
            }
        }
    }

    public void agletSuspended(ContextEvent contextEvent) {
        if (this.message) {
            System.out.println("Suspended " + contextEvent.getAgletProxy());
        }
    }

    public void contextShutdown(ContextEvent contextEvent) {
    }

    public void contextStarted(ContextEvent contextEvent) {
        this.context = contextEvent.getAgletContext();
        Resource resource = Resource.getResourceFor("aglets");
        if (!resource.getBoolean("aglets.registered", false)) {
            // empty if block
        }
        new Thread(this).start();
    }

    public void run() {
        boolean bl = false;
        BufferedReader bufferedReader = null;
        PrintWriter printWriter = null;
        Socket socket = null;
        String string = System.getProperties().getProperty("maf.controlport");
        try {
            if (Integer.parseInt(string) > 0) {
                _control_port_num = Integer.parseInt(string);
            } else {
                System.out.println("Controlport: " + string + " is out of range, defaulting to: " + _control_port_num);
            }
        }
        catch (NumberFormatException numberFormatException) {
            numberFormatException.printStackTrace();
            System.exit(1);
        }
        Thread.currentThread().setPriority(1);
        ServerSocket serverSocket = null;
        try {
            serverSocket = new ServerSocket(_control_port_num);
        }
        catch (IOException iOException) {
            System.err.println("Could not listen on port: " + _control_port_num);
            System.exit(1);
        }
        while (this.continue_processing) {
            try {
                socket = serverSocket.accept();
                bl = true;
            }
            catch (IOException iOException) {
                System.err.println("Accept failed.");
                System.exit(1);
            }
            try {
                printWriter = new PrintWriter(socket.getOutputStream(), true);
                printWriter.println(_banner_string);
                printWriter.println(_version_string);
                printWriter.println("Connected to:" + serverSocket.toString());
            }
            catch (IOException iOException) {
                System.err.println("getOutputStream failed.");
                System.exit(1);
            }
            try {
                bufferedReader = new BufferedReader(new InputStreamReader(socket.getInputStream()));
            }
            catch (IOException iOException) {
                System.err.println("getInputStream failed.");
                System.exit(1);
            }
            String string2 = null;
            while (this.continue_processing && bl) {
                try {
                    String string3 = bufferedReader.readLine();
                    string2 = this.command(string3);
                    printWriter.println(string2);
                    printWriter.println("done.");
                }
                catch (Throwable throwable) {
                    if (this.debug) {
                        throwable.printStackTrace();
                        System.err.println(throwable.getMessage());
                        System.err.println("Socket closed");
                        bl = false;
                    }
                    printWriter.println("Exception: [" + throwable.toString() + "] With the message: [" + throwable.getMessage() + "] has occurred, continuing.");
                }
            }
        }
        try {
            AgletRuntime.getAgletRuntime().shutdown();
            printWriter.close();
            bufferedReader.close();
            socket.close();
            serverSocket.close();
        }
        catch (IOException iOException) {
            System.err.println("close failed.");
        }
        if (this.reboot) {
            System.exit(0);
        } else {
            System.exit(1);
        }
    }

    public void showDocument(ContextEvent contextEvent) {
        if (this.message) {
            System.out.println("hyper link required :" + contextEvent.arg);
        }
    }

    public void showMessage(ContextEvent contextEvent) {
        if (this.message) {
            System.out.println((String)contextEvent.arg);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    String command(String string) throws Exception {
        Item item = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string, " \t");
        if (!stringTokenizer.hasMoreTokens()) return "unknown command: " + string;
        String string2 = stringTokenizer.nextToken();
        if ("shutdown".equalsIgnoreCase(string2)) {
            this.shutdown = true;
            this.continue_processing = false;
            return "shutting down";
        }
        if ("reboot".equalsIgnoreCase(string2)) {
            this.reboot = true;
            this.continue_processing = false;
            return "rebooting";
        }
        if ("list".equalsIgnoreCase(string2)) {
            return this.list();
        }
        if ("debug".equalsIgnoreCase(string2)) {
            if (stringTokenizer.hasMoreTokens()) {
                if ("on".equalsIgnoreCase(stringTokenizer.nextToken())) {
                    Debug.debug(true);
                    this.debug = true;
                } else {
                    Debug.debug(false);
                    this.debug = false;
                }
            }
            Debug.list(System.err);
            if (!this.debug) return "debug off";
            return "debug on";
        }
        if ("msg".equalsIgnoreCase(string2)) {
            if (stringTokenizer.hasMoreTokens()) {
                this.message = "on".equalsIgnoreCase(stringTokenizer.nextToken());
            }
            if (!this.message) return "message off";
            return "message on";
        }
        if ("help".equalsIgnoreCase(string2)) {
            return "help";
        }
        if ("create".equalsIgnoreCase(string2)) {
            URL uRL = null;
            String string3 = "";
            try {
                if (stringTokenizer.countTokens() == 2) {
                    uRL = new URL(stringTokenizer.nextToken());
                    string3 = stringTokenizer.nextToken();
                } else {
                    if (stringTokenizer.countTokens() != 1) return "Usage: create [URL] name";
                    string3 = stringTokenizer.nextToken();
                }
                AgletProxy agletProxy = null;
                if (this.debug) {
                    System.err.println("Entering context.createAglet");
                }
                agletProxy = this.context.createAglet(uRL, string3, null);
                if (this.debug) {
                    System.err.println("Leaving context.createAglet");
                }
                if (agletProxy == null) return "Creation of Aglet " + string3 + " Failed.";
                return "Creation of Aglet " + string3 + " Succeeded.";
            }
            catch (Throwable throwable) {
                if (!this.debug) return "Creation of Aglet [" + string3 + "] Failed. Exception was: [" + throwable.toString() + "] Message was: [" + throwable.getMessage() + "]";
                throwable.printStackTrace();
                System.err.println(throwable.getMessage());
                return "Creation of Aglet [" + string3 + "] Failed. Exception was: [" + throwable.toString() + "] Message was: [" + throwable.getMessage() + "]";
            }
        }
        item = (Item)this.aglets.get(string2);
        if (item == null) return "unknown command (or aglet not found): " + string2;
        if (!stringTokenizer.hasMoreTokens()) return item.toString();
        String string4 = stringTokenizer.nextToken();
        if ("property".equalsIgnoreCase(string4)) {
            return "Properties for: " + string2 + "\n" + item.toString();
        }
        item.command(string4, stringTokenizer);
        if (item.isValid()) return "unknown command: " + string;
        this.removed(item);
        return "Removed : " + string2;
    }

    String list() throws Exception {
        Enumeration enumeration = this.aglets.keys();
        String string = "Aglet List empty";
        if (enumeration.hasMoreElements()) {
            string = "Aglet List:\n";
        }
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            Item item = (Item)this.aglets.get(string2);
            string = string + string2 + " [" + item.proxy.getAgletClassName() + "] ";
        }
        return string;
    }

    private synchronized void added(AgletProxy agletProxy) {
        this.aglets.put("aglet" + serial++, new Item(agletProxy));
    }

    private synchronized void removed(AgletProxy agletProxy) {
        Enumeration enumeration = this.aglets.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            if (!this.aglets.get(k).equals(agletProxy)) continue;
            this.aglets.remove(k);
        }
    }

    private synchronized void removed(Item item) {
        this.removed(item.proxy);
    }

    public static final UserManager getUserManager() {
        return _userManager;
    }
}

