/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.aglets.tahiti;

import com.ibm.aglets.tahiti.ActionAndKeyListener;
import com.ibm.aglets.tahiti.MainWindow;
import com.ibm.aglets.tahiti.TahitiDialog;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Point;
import java.awt.event.ActionListener;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ResourceBundle;

public class TahitiDialog
extends Dialog {
    public static final String lineSeparator = "\n";
    private static ResourceBundle bundle = null;
    private Panel buttonPanel = new Panel();
    private boolean shown = false;
    private Button _closeButton = null;

    protected TahitiDialog(Frame frame) {
        this(frame, "", false);
    }

    protected TahitiDialog(Frame frame, String string, boolean bl) {
        super(frame, string, bl);
        this.setLayout(new BorderLayout());
        this.setTitle(string);
        this.buttonPanel.setLayout(new FlowLayout(2));
        this.add("South", this.buttonPanel);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                if (TahitiDialog.this.windowClosing(windowEvent)) {
                    TahitiDialog.this.dispose();
                } else {
                    ((Component)TahitiDialog.this).setVisible(false);
                }
            }
        });
    }

    public Button addButton(String string) {
        Button button = new Button(string);
        this.buttonPanel.add(button);
        return button;
    }

    protected Button addButton(String string, ActionListener actionListener) {
        Button button = this.addButton(string);
        button.setActionCommand(string);
        button.addActionListener(actionListener);
        return button;
    }

    protected Button addButton(String string, ActionListener actionListener, KeyListener keyListener) {
        Button button = this.addButton(string);
        button.setActionCommand(string);
        button.addActionListener(actionListener);
        button.addKeyListener(keyListener);
        return button;
    }

    protected void addCloseButton(String string) {
        if (string == null) {
            string = bundle.getString("dialog.close");
        }
        class AlertCloseListener
        extends ActionAndKeyListener {
            Dialog target;
            private final /* synthetic */ TahitiDialog this$0;

            AlertCloseListener(TahitiDialog tahitiDialog, Dialog dialog) {
                this.this$0 = tahitiDialog;
                this.target = dialog;
            }

            protected void doAction() {
                this.target.dispose();
                this.this$0.closeButtonPressed();
            }
        }
        AlertCloseListener alertCloseListener = new AlertCloseListener(this, this);
        this._closeButton = this.addButton(string, alertCloseListener, alertCloseListener);
    }

    public static TahitiDialog alert(Frame frame, String string) {
        TahitiDialog tahitiDialog = null;
        try {
            final Frame frame2 = frame;
            final String string2 = string;
            final ResourceBundle resourceBundle = bundle;
            tahitiDialog = (TahitiDialog)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    TahitiDialog tahitiDialog = new TahitiDialog(frame2, resourceBundle.getString("title.alert"), true);
                    tahitiDialog.add("Center", new MessagePanel(string2, 0, false));
                    tahitiDialog.addCloseButton(null);
                    return tahitiDialog;
                }
            });
        }
        catch (SecurityException securityException) {
            securityException.printStackTrace();
        }
        return tahitiDialog;
    }

    public void beep() {
        this.getToolkit().beep();
    }

    protected void closeButtonPressed() {
    }

    public MainWindow getMainWindow() {
        return (MainWindow)this.getParent();
    }

    public static void main(String[] stringArray) {
        TahitiDialog.alert(new Frame(), stringArray[0]).popupAtCenterOfScreen();
    }

    public static TahitiDialog message(Frame frame, String string, String string2) {
        TahitiDialog tahitiDialog = null;
        try {
            final Frame frame2 = frame;
            final String string3 = string;
            final String string4 = string2;
            final ResourceBundle resourceBundle = bundle;
            tahitiDialog = (TahitiDialog)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    TahitiDialog tahitiDialog = new TahitiDialog(frame2, resourceBundle.getString("title.message"), true);
                    tahitiDialog.add("North", new Label(string3));
                    tahitiDialog.add("Center", new MessagePanel(string4, 0, false));
                    tahitiDialog.addCloseButton(null);
                    return tahitiDialog;
                }
            });
        }
        catch (SecurityException securityException) {
            securityException.printStackTrace();
        }
        return tahitiDialog;
    }

    public void popup() {
        if (!this.shown) {
            this.pack();
            this.shown = true;
        }
        this.show();
    }

    public void popupAtCenterOfParent() {
        if (!this.shown) {
            this.pack();
            this.shown = true;
        }
        Dimension dimension = this.getToolkit().getScreenSize();
        Frame frame = (Frame)this.getParent();
        Point point = frame.getLocationOnScreen();
        Dimension dimension2 = frame.getSize();
        Dimension dimension3 = this.getSize();
        int n = (dimension2.width - dimension3.width) / 2 + point.x;
        int n2 = (dimension2.height - dimension3.height) / 2 + point.y;
        if (n < 0) {
            n = 0;
        }
        if (n > dimension.width - dimension3.width) {
            n = dimension.width - dimension3.width;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        if (n2 > dimension.height - dimension3.height) {
            n2 = dimension.height - dimension3.height;
        }
        ((Component)this).setLocation(n, n2);
        this.show();
    }

    public void popupAtCenterOfScreen() {
        if (!this.shown) {
            this.pack();
            this.shown = true;
        }
        Dimension dimension = this.getToolkit().getScreenSize();
        ((Component)this).setLocation((dimension.width - this.getSize().width) / 2, (dimension.height - this.getSize().height) / 2);
        this.show();
    }

    public static String[] split(String string) {
        int n;
        String[] stringArray = new String[50];
        int n2 = lineSeparator.length();
        int n3 = 0;
        while ((n = string.indexOf(lineSeparator)) >= 0 && n3 < 49) {
            stringArray[n3] = string.substring(0, n);
            string = string.substring(n + n2);
            ++n3;
        }
        stringArray[n3++] = string;
        String[] stringArray2 = new String[n3];
        System.arraycopy(stringArray, 0, stringArray2, 0, n3);
        return stringArray2;
    }

    protected boolean windowClosing(WindowEvent windowEvent) {
        return true;
    }

    static {
        try {
            bundle = (ResourceBundle)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return ResourceBundle.getBundle("tahiti");
                }
            });
        }
        catch (SecurityException securityException) {
            securityException.printStackTrace();
        }
    }

    protected static class MessagePanel
    extends Panel {
        private GridBagConstraints cns = new GridBagConstraints();
        private GridBagLayout grid = new GridBagLayout();
        private boolean raised;
        private int alignment = 0;

        public MessagePanel(String string, int n, boolean bl) {
            this(TahitiDialog.split(string), n, bl);
        }

        public MessagePanel(String[] stringArray, int n, boolean bl) {
            this.alignment = n;
            this.raised = bl;
            this.cns.gridwidth = 0;
            this.cns.fill = 1;
            this.cns.weightx = 1.0;
            this.cns.weighty = 1.0;
            this.cns.insets = new Insets(3, 3, 3, 3);
            this.setLayout(this.grid);
            int n2 = 0;
            while (n2 < stringArray.length) {
                Label label = new Label(stringArray[n2], n);
                this.grid.setConstraints(label, this.cns);
                this.add(label);
                ++n2;
            }
        }

        public void paint(Graphics graphics) {
            super.paint(graphics);
            graphics.setColor(this.getBackground());
            Dimension dimension = this.getSize();
            graphics.fillRect(0, 0, dimension.width, dimension.height);
            graphics.draw3DRect(1, 1, dimension.width - 2, dimension.height - 2, this.raised);
        }
    }
}

