/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.aglets.tahiti;

import com.ibm.aglet.AgletInfo;
import com.ibm.aglet.AgletProxy;
import com.ibm.aglet.InvalidAgletException;
import com.ibm.awb.misc.Resource;
import java.util.Date;

public final class TahitiItem {
    static final int KEY_LASTUPDATE = 0;
    static final int KEY_TIMESTAMP = 1;
    static final int KEY_CLASSNAME = 2;
    static int _keyOrder = 0;
    static boolean _isAscentOrder = true;
    static boolean _isPrecise = true;
    static boolean _needUpdate = false;
    static boolean _fInit = false;
    AgletProxy _proxy;
    Date _date;
    String _timestamp;
    String _timestampSimple;
    String _classname;
    String _classnameSimple;
    boolean _isValid;

    public TahitiItem() {
        this._isValid = false;
        _keyOrder = 0;
        _needUpdate = true;
    }

    public TahitiItem(AgletProxy agletProxy) {
        block6: {
            this._isValid = false;
            try {
                block5: {
                    try {
                        this._isValid = agletProxy.isValid();
                        if (!this._isValid) break block5;
                        this._proxy = agletProxy;
                        AgletInfo agletInfo = agletProxy.getAgletInfo();
                        this._date = new Date(agletInfo.getCreationTime());
                        this._classname = agletInfo.getAgletClassName();
                    }
                    catch (InvalidAgletException invalidAgletException) {
                        Object var5_5 = null;
                        break block6;
                    }
                    catch (RuntimeException runtimeException) {
                        runtimeException.printStackTrace();
                        Object var5_6 = null;
                    }
                }
                Object var5_4 = null;
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                throw throwable;
            }
        }
    }

    boolean checkProxy(AgletProxy agletProxy) {
        return this._proxy == agletProxy;
    }

    int compareTo(TahitiItem tahitiItem) {
        int n = 0;
        switch (_keyOrder) {
            case 0: {
                n = -1;
                break;
            }
            case 1: {
                if (this._date.after(tahitiItem._date)) {
                    n = 1;
                    break;
                }
                if (this._date.before(tahitiItem._date)) {
                    n = -1;
                    break;
                }
                n = this._classname.compareTo(tahitiItem._classname);
                break;
            }
            case 2: {
                n = this._classname.compareTo(tahitiItem._classname);
                if (n != 0) break;
                if (this._date.after(tahitiItem._date)) {
                    n = 1;
                    break;
                }
                if (this._date.before(tahitiItem._date)) {
                    n = -1;
                    break;
                }
                n = 0;
                break;
            }
        }
        if (!_isAscentOrder) {
            n = -n;
        }
        return n;
    }

    AgletProxy getAgletProxy() {
        return this._proxy;
    }

    String getClassName() {
        if (_isPrecise) {
            return this._classname;
        }
        int n = 0;
        n = this._classname.length();
        if (n > 20) {
            this._classnameSimple = this._classname.endsWith("Aglet") ? this._classname.substring(0, n - 5) + ".." : new String(this._classname);
            n = this._classnameSimple.length();
            this._classnameSimple = n > 20 ? ".." + this._classnameSimple.substring(n - 18, n) : (this._classnameSimple + "   ").substring(0, 20);
        } else {
            this._classnameSimple = (this._classname + "                    ").substring(0, 20);
        }
        return this._classnameSimple;
    }

    static boolean getPrecision() {
        return _isAscentOrder;
    }

    String getText() {
        String string;
        switch (_keyOrder) {
            case 0: {
                string = this.getClassName() + " : " + this.getTimeStamp();
                break;
            }
            case 1: {
                string = this.getTimeStamp() + " : " + this.getClassName();
                break;
            }
            case 2: {
                string = this.getClassName() + " : " + this.getTimeStamp();
                break;
            }
            default: {
                string = this.getTimeStamp() + " : " + this.getClassName();
            }
        }
        return string;
    }

    String getTimeStamp() {
        this._timestamp = this._date.toString();
        if (_isPrecise) {
            return this._timestamp;
        }
        this._timestampSimple = this._timestamp.substring(11, 19);
        return this._timestampSimple;
    }

    static void init() {
        if (_fInit) {
            return;
        }
        _fInit = true;
        Resource resource = Resource.getResourceFor("tahiti");
        String string = resource.getString("tahiti.itemkey", "event order");
        String string2 = resource.getString("tahiti.itemorder", "ascent");
        String string3 = resource.getString("tahiti.itemprecision", "complete");
        if (string.equals("event order")) {
            TahitiItem.setKeyItem(0);
        } else if (string.equals("creation time")) {
            TahitiItem.setKeyItem(1);
        } else if (string.equals("class name")) {
            TahitiItem.setKeyItem(2);
        }
        if (string2.equals("ascent")) {
            TahitiItem.setAscentOrder();
        } else if (string2.equals("descent")) {
            TahitiItem.setDescentOrder();
        }
        if (string3.equals("complete")) {
            TahitiItem.setPrecision(true);
        } else if (string3.equals("compact")) {
            TahitiItem.setPrecision(false);
        }
    }

    static boolean isAscentOrder() {
        return _isAscentOrder;
    }

    static boolean isNeedUpdate() {
        boolean bl = _needUpdate;
        _needUpdate = false;
        return bl;
    }

    static void setAscentOrder() {
        if (_isAscentOrder) {
            return;
        }
        _isAscentOrder = true;
        _needUpdate = true;
    }

    static void setDescentOrder() {
        if (!_isAscentOrder) {
            return;
        }
        _isAscentOrder = false;
        _needUpdate = true;
    }

    static void setKeyItem(int n) {
        if (_keyOrder == n) {
            return;
        }
        _keyOrder = n;
        _needUpdate = true;
    }

    static void setPrecision(boolean bl) {
        if (_isPrecise == bl) {
            return;
        }
        _isPrecise = bl;
        _needUpdate = true;
    }
}

