/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.atp;

import com.ibm.atp.ContentBuffer;
import com.ibm.awb.misc.Resource;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public final class ContentOutputStream
extends ByteArrayOutputStream
implements ContentBuffer {
    public static final String CRLF = "\r\n";
    protected OutputStream _out = null;
    private boolean content_started = false;
    private boolean content_sent = false;
    private static int BUFFSIZE = 2048;
    int wrote = 0;
    byte[] buffer;

    public ContentOutputStream(OutputStream outputStream) {
        this(outputStream, false);
    }

    public ContentOutputStream(OutputStream outputStream, boolean bl) {
        super(4096);
        this._out = outputStream;
        this.buffer = new byte[BUFFSIZE];
        this.wrote = 0;
        this.content_started = bl;
    }

    public synchronized void close() throws IOException {
        this.content_sent = true;
        this.flush();
        this._out.close();
    }

    public void flush() throws IOException {
        if (this.content_sent) {
            this._out.write(this.buf, 0, this.count);
            this._out.flush();
            this.reset();
        }
    }

    public synchronized void sendContent() throws IOException {
        byte[] byArray;
        if (this.content_sent) {
            throw new IOException("Content has been already sent");
        }
        this.content_sent = true;
        String string = CRLF;
        if (this.count != 0) {
            string = "Content-Length:" + String.valueOf(this.count) + CRLF + CRLF;
        }
        if (this.wrote + (byArray = string.getBytes()).length < BUFFSIZE) {
            System.arraycopy(byArray, 0, this.buffer, this.wrote, byArray.length);
            this.wrote += byArray.length;
        } else {
            this._out.write(this.buffer, 0, this.wrote);
            this.wrote = 0;
            this._out.write(byArray, 0, byArray.length);
        }
        if (this.wrote + this.count < BUFFSIZE) {
            System.arraycopy(this.buf, 0, this.buffer, this.wrote, this.count);
            this.wrote += this.count;
            this._out.write(this.buffer, 0, this.wrote);
        } else {
            this._out.write(this.buffer, 0, this.wrote);
            this._out.write(this.buf, 0, this.count);
        }
        this.wrote = 0;
        this._out.flush();
        this.reset();
        if (this._out instanceof ContentBuffer) {
            ((ContentBuffer)((Object)this._out)).sendContent();
        }
    }

    public synchronized void startContent() throws IOException {
        if (this.content_started) {
            throw new IOException("Content has been already started");
        }
        this.content_started = true;
        if (this.count < BUFFSIZE) {
            System.arraycopy(this.buf, 0, this.buffer, 0, this.count);
            this.wrote = this.count;
        } else {
            this._out.write(this.buf, 0, this.count);
            this.wrote = 0;
        }
        this.reset();
    }

    static {
        Resource resource = Resource.getResourceFor("atp");
        BUFFSIZE = resource.getInteger("atp.buffersize", 2048);
    }
}

