/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.atp.auth;

import com.ibm.atp.auth.AuthenticationException;
import com.ibm.atp.auth.ByteSequence;
import com.ibm.atp.auth.Challenge;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public abstract class Auth {
    private final String DEFAULTDIGESTALGORITHM = "SHA-1";
    private String _digestAlgorithm = "SHA-1";
    private MessageDigest _digest = null;
    public static final int NO_TURNS = 0;
    public static final int FIRST_TURN = 1;
    public static final int SECOND_TURN = 2;
    private static final String FIRST_TURN_PAD = "F";
    private static final String SECOND_TURN_PAD = "S";
    private static final String TURN_DELIMITER = ":";
    private String _idFirst = null;
    private String _idSecond = null;

    protected Auth() {
        this.setDigestAlgorithm("SHA-1");
    }

    protected Auth(String string) {
        this.setDigestAlgorithm(string);
    }

    protected void addBytes(byte[] byArray) {
        this._digest.update(byArray);
    }

    public abstract byte[] calculateResponse(int var1, Challenge var2) throws AuthenticationException;

    public String getDigestAlgorithm() {
        return this._digestAlgorithm;
    }

    protected byte[] getDigestValue() {
        return this._digest.digest();
    }

    public String getFirstTurnIdentifier() {
        return this._idFirst;
    }

    public String getSecondTurnIdentifier() {
        return this._idSecond;
    }

    protected String getTurnPad(int n) {
        String string = null;
        switch (n) {
            case 1: {
                string = "F:" + this._idSecond + TURN_DELIMITER + this._idFirst;
                break;
            }
            case 2: {
                string = "S:" + this._idFirst + TURN_DELIMITER + this._idSecond;
                break;
            }
            default: {
                string = null;
            }
        }
        return string;
    }

    protected abstract byte[] hash(int var1, Challenge var2) throws AuthenticationException;

    protected void resetDigest() {
        this._digest.reset();
    }

    protected void setDigestAlgorithm(String string) {
        this._digestAlgorithm = string;
        try {
            this._digest = MessageDigest.getInstance(this._digestAlgorithm);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            System.out.println("Exception: Authenticate: " + noSuchAlgorithmException);
            this._digestAlgorithm = null;
            this._digest = null;
        }
    }

    public void setFirstTurnIdentifier(String string) {
        this._idFirst = string;
    }

    public void setSecondTurnIdentifier(String string) {
        this._idSecond = string;
    }

    public abstract boolean verify(int var1, Challenge var2, byte[] var3) throws AuthenticationException;

    public abstract boolean verify(int var1, Challenge var2, ByteSequence var3) throws AuthenticationException;
}

