/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.atp.auth;

import com.ibm.atp.auth.Auth;
import com.ibm.atp.auth.AuthenticationException;
import com.ibm.atp.auth.ByteSequence;
import com.ibm.atp.auth.Challenge;
import com.ibm.atp.auth.SharedSecret;

public class AuthByDigest
extends Auth {
    private SharedSecret _secret = null;

    protected AuthByDigest() {
    }

    public AuthByDigest(SharedSecret sharedSecret) {
        this();
        this.setSecret(sharedSecret);
    }

    protected AuthByDigest(String string) {
        super(string);
    }

    public AuthByDigest(String string, SharedSecret sharedSecret) {
        this(string);
        this.setSecret(sharedSecret);
    }

    public final byte[] calculateResponse(int n, Challenge challenge) throws AuthenticationException {
        return this.hash(n, challenge);
    }

    public SharedSecret getSecret() {
        return this._secret;
    }

    protected final byte[] hash(int n, Challenge challenge) throws AuthenticationException {
        this.resetDigest();
        if (challenge == null) {
            throw new AuthenticationException("Challenge is null.");
        }
        this.addBytes(challenge.challenge());
        String string = this.getTurnPad(n);
        if (string == null || string.equals("")) {
            throw new AuthenticationException("TurnPad is null.");
        }
        this.addBytes(string.getBytes());
        SharedSecret sharedSecret = this.getSecret();
        if (sharedSecret == null) {
            throw new AuthenticationException("Shared secret is null.");
        }
        this.addBytes(sharedSecret.secret());
        return this.getDigestValue();
    }

    protected void setSecret(SharedSecret sharedSecret) {
        this._secret = sharedSecret;
    }

    public boolean verify(int n, Challenge challenge, byte[] byArray) throws AuthenticationException {
        ByteSequence byteSequence = new ByteSequence(this.calculateResponse(n, challenge));
        return byteSequence.equals(byArray);
    }

    public boolean verify(int n, Challenge challenge, ByteSequence byteSequence) throws AuthenticationException {
        ByteSequence byteSequence2 = new ByteSequence(this.calculateResponse(n, challenge));
        return byteSequence2.equals(byteSequence);
    }
}

