/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.atp.auth;

import com.ibm.atp.auth.Auth;
import com.ibm.atp.auth.AuthenticationException;
import com.ibm.atp.auth.ByteSequence;
import com.ibm.atp.auth.Challenge;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;

public class AuthBySignature
extends Auth {
    private final String DEFAULTDIGITALSIGNATUREALGORITHM = "DSA";
    private String _signatureAlgorithm = "DSA";
    private Signature _signature = null;
    private PrivateKey _privateKey = null;
    private PublicKey _publicKey = null;

    protected AuthBySignature() {
    }

    protected AuthBySignature(String string) {
        super(string);
        this.setSignatureAlgorithm("DSA");
    }

    protected AuthBySignature(String string, String string2) {
        super(string);
        this.setSignatureAlgorithm(string2);
    }

    protected AuthBySignature(String string, String string2, PrivateKey privateKey, PublicKey publicKey) {
        this(string, string2);
        this.setPrivateKey(privateKey);
        this.setPublicKey(publicKey);
    }

    protected AuthBySignature(String string, PrivateKey privateKey, PublicKey publicKey) {
        this(string);
        this.setPrivateKey(privateKey);
        this.setPublicKey(publicKey);
    }

    protected AuthBySignature(PrivateKey privateKey, PublicKey publicKey) {
        this();
        this.setPrivateKey(privateKey);
        this.setPublicKey(publicKey);
    }

    public final byte[] calculateResponse(int n, Challenge challenge) throws AuthenticationException {
        return this.sign(n, challenge);
    }

    public PrivateKey getPrivateKey() {
        return this._privateKey;
    }

    public PublicKey getPublicKey() {
        return this._publicKey;
    }

    public String getSignatureAlgorithm() {
        return this._signatureAlgorithm;
    }

    protected final byte[] hash(int n, Challenge challenge) throws AuthenticationException {
        this.resetDigest();
        if (challenge == null) {
            throw new AuthenticationException("Challenge is null.");
        }
        this.addBytes(challenge.challenge());
        String string = this.getTurnPad(n);
        if (string == null || string.equals("")) {
            throw new AuthenticationException("TurnPad is null.");
        }
        this.addBytes(string.getBytes());
        return this.getDigestValue();
    }

    protected void setPrivateKey(PrivateKey privateKey) {
        this._privateKey = privateKey;
    }

    protected void setPublicKey(PublicKey publicKey) {
        this._publicKey = publicKey;
    }

    protected void setSignatureAlgorithm(String string) {
        this._signatureAlgorithm = string;
        try {
            this._signature = Signature.getInstance(string);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            System.err.println("Exception: Authenticate: " + noSuchAlgorithmException);
            this._signatureAlgorithm = null;
            this._signature = null;
        }
    }

    protected final byte[] sign(int n, Challenge challenge) throws AuthenticationException {
        byte[] byArray = null;
        try {
            this._signature.initSign(this._privateKey);
            this._signature.update(this.hash(n, challenge));
            byArray = this._signature.sign();
        }
        catch (InvalidKeyException invalidKeyException) {
            System.err.println("Exception: Authenticate: " + invalidKeyException);
            throw new AuthenticationException("private key is invalid.");
        }
        catch (SignatureException signatureException) {
            System.err.println("Exception: Authenticate: " + signatureException);
            throw new AuthenticationException("signature cannot be calculated.");
        }
        return byArray;
    }

    public final boolean verify(int n, Challenge challenge, byte[] byArray) throws AuthenticationException {
        boolean bl = true;
        try {
            this._signature.initVerify(this._publicKey);
            this._signature.update(this.hash(n, challenge));
            bl = this._signature.verify(byArray);
        }
        catch (InvalidKeyException invalidKeyException) {
            System.err.println("Exception: Authenticate: " + invalidKeyException);
            throw new AuthenticationException("public key is invalid.");
        }
        catch (SignatureException signatureException) {
            System.err.println("Exception: Authenticate: " + signatureException);
            throw new AuthenticationException("signature verification is failed.");
        }
        return bl;
    }

    public final boolean verify(int n, Challenge challenge, ByteSequence byteSequence) throws AuthenticationException {
        if (byteSequence == null) {
            return false;
        }
        return this.verify(n, challenge, byteSequence.sequence());
    }
}

