/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.atp.auth;

import com.ibm.aglet.system.AgletRuntime;
import com.ibm.atp.auth.Challenge;
import com.ibm.atp.auth.Response;
import com.ibm.awb.misc.Hexadecimal;
import com.ibm.awb.misc.Resource;
import com.ibm.awb.misc.URIEncoder;
import java.io.DataInput;
import java.io.IOException;
import java.io.OutputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;

public class AuthPacket {
    protected static final String CRLF = "\r\n";
    protected static final String END_OF_PACKET = ".";
    protected static final String AUTHENTICATION_PROTOCOL_VERSION = "AUTH/0.1";
    protected static final String FIELD_SEPARATOR = ":";
    protected static final String SERVERID_FIELDNAME = "Server-ID";
    protected static final String DOMAIN_SEPARATOR = ",";
    protected static final String DOMAINS_FIELDNAME = "Domains";
    protected static final String DOMAIN_FIELDNAME = "Domain";
    protected static final String AUTH_MANNER_FIELDNAME = "AuthManner";
    protected static final String AUTH_MANNER_DIGEST = "DIGEST";
    protected static final String AUTH_MANNER_SIGNATURE = "SIGNATURE";
    protected static final String CHALLENGE_FIELDNAME = "Challenge";
    protected static final String RESPONSE_FIELDNAME = "Response";
    private static String SERVERID = null;
    private String _serverid = null;
    private static boolean verbose = false;
    protected static final String STEP_START = "AUTH_START";
    protected static final String STEP_FIRST_TURN = "AUTH_FIRST_TURN";
    protected static final String STEP_SECOND_TURN = "AUTH_SECOND_TURN";
    protected static final String STEP_END = "AUTH_END";
    private int _step = 0;
    private int _status = 0;
    private Vector _domains = null;
    private String _domain = null;
    private int _manner = 0;
    private Challenge _challenge = null;
    private Response _response = null;

    public AuthPacket(int n, int n2, String string, int n3, Challenge challenge, Response response) {
        this.setServerID(SERVERID);
        this.setStep(n);
        this.setStatus(n2);
        this.setSecurityDomain(string);
        this.setAuthManner(n3);
        this.setChallenge(challenge);
        this.setResponse(response);
    }

    public AuthPacket(int n, int n2, Enumeration enumeration, int n3, Challenge challenge, Response response) {
        this.setServerID(SERVERID);
        this.setStep(n);
        this.setStatus(n2);
        this.setSecurityDomains(enumeration);
        this.setAuthManner(n3);
        this.setChallenge(challenge);
        this.setResponse(response);
    }

    public AuthPacket(DataInput dataInput) {
        try {
            this.readFrom(dataInput);
        }
        catch (IOException iOException) {
            System.err.println("IOException : " + iOException);
            this.clear();
        }
    }

    private final void clear() {
        this._step = 0;
        this._status = 0;
        this._domains = null;
        this._domain = null;
        this._manner = 0;
        this._challenge = null;
        this._response = null;
    }

    private static String decode(String string) {
        if (string == null) {
            return null;
        }
        String string2 = null;
        try {
            final String string3 = string;
            string2 = (String)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return URIEncoder.decode(string3);
                }
            });
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return string2;
    }

    private static String encode(String string) {
        if (string == null) {
            return null;
        }
        String string2 = null;
        try {
            final String string3 = string;
            string2 = (String)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return URIEncoder.encode(string3);
                }
            });
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return string2;
    }

    public final int getAuthManner() {
        return this._manner;
    }

    protected final String getAuthMannerField() {
        String string = AuthPacket.toAuthMannerString(this._manner);
        if (string != null) {
            string = "AuthManner: " + string;
        }
        return string;
    }

    public final Challenge getChallenge() {
        return this._challenge;
    }

    protected final String getChallengeField() {
        String string = null;
        if (this._challenge != null) {
            string = "Challenge: " + this._challenge.toString();
        }
        return string;
    }

    public final Response getResponse() {
        return this._response;
    }

    protected final String getResponseField() {
        String string = null;
        if (this._response != null) {
            string = "Response: " + this._response.toString();
        }
        return string;
    }

    public final String getSecurityDomain() {
        return this._domain;
    }

    protected final String getSecurityDomainField() {
        String string = null;
        if (this._domain != null) {
            string = "Domain: " + this._domain;
        }
        return string;
    }

    public final String getSecurityDomainList() {
        Enumeration enumeration = this.getSecurityDomains();
        if (enumeration == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (!bl) {
                stringBuffer.append(DOMAIN_SEPARATOR);
            }
            stringBuffer.append(AuthPacket.encode(string));
            bl = false;
        }
        return stringBuffer.toString();
    }

    public final Enumeration getSecurityDomains() {
        if (this._domains == null) {
            return null;
        }
        return this._domains.elements();
    }

    protected final String getSecurityDomainsField() {
        String string = null;
        String string2 = this.getSecurityDomainList();
        if (string2 != null) {
            string = "Domains: " + string2;
        }
        return string;
    }

    public final String getServerID() {
        return this._serverid;
    }

    protected final String getServerIDField() {
        String string = null;
        if (this._serverid != null) {
            string = "Server-ID: " + this._serverid;
        }
        return string;
    }

    public final int getStatus() {
        return this._status;
    }

    protected final String getStatusString() {
        return Integer.toString(this._status);
    }

    public final int getStep() {
        return this._step;
    }

    protected final String getStepString() {
        String string = null;
        switch (this._step) {
            case 1: {
                string = STEP_START;
                break;
            }
            case 2: {
                string = STEP_FIRST_TURN;
                break;
            }
            case 3: {
                string = STEP_SECOND_TURN;
                break;
            }
            case 4: {
                string = STEP_END;
                break;
            }
            default: {
                string = "";
            }
        }
        return string;
    }

    public static boolean isTopLine(String string) {
        Integer n;
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        if (stringTokenizer.countTokens() != 3) {
            return false;
        }
        String string2 = stringTokenizer.nextToken();
        if (!(string2.equalsIgnoreCase(STEP_START) || string2.equalsIgnoreCase(STEP_FIRST_TURN) || string2.equalsIgnoreCase(STEP_SECOND_TURN) || string2.equalsIgnoreCase(STEP_END))) {
            return false;
        }
        String string3 = stringTokenizer.nextToken().trim();
        if (!string3.equals((n = new Integer(string3)).toString())) {
            return false;
        }
        String string4 = stringTokenizer.nextToken();
        return string4.equalsIgnoreCase(AUTHENTICATION_PROTOCOL_VERSION);
    }

    static final boolean isVerbose() {
        return verbose;
    }

    public synchronized void parseBody(DataInput dataInput) throws IOException {
        while (true) {
            String string;
            if ((string = dataInput.readLine().trim()).equalsIgnoreCase(END_OF_PACKET)) break;
            this.parseLine(string);
        }
        AuthPacket.verboseOut("end of authentication packet.");
    }

    private synchronized void parseLine(String string) throws IOException {
        String string2 = string.substring(0, string.indexOf(FIELD_SEPARATOR)).trim();
        String string3 = string.substring(string.indexOf(FIELD_SEPARATOR) + 1).trim();
        AuthPacket.verboseOut("Parse Packet Body : field name=" + string2);
        AuthPacket.verboseOut("Parse Packet Body : field value=" + string3);
        if (string2.equalsIgnoreCase(SERVERID_FIELDNAME)) {
            this.setServerID(string3);
        } else if (string2.equalsIgnoreCase(DOMAINS_FIELDNAME)) {
            this.setSecurityDomains(string3);
        } else if (string2.equalsIgnoreCase(DOMAIN_FIELDNAME)) {
            this.setSecurityDomain(string3);
        } else if (string2.equalsIgnoreCase(AUTH_MANNER_FIELDNAME)) {
            this.setAuthManner(string3);
        } else if (string2.equalsIgnoreCase(CHALLENGE_FIELDNAME)) {
            this.setChallenge(string3);
        } else if (string2.equalsIgnoreCase(RESPONSE_FIELDNAME)) {
            this.setResponse(string3);
        } else {
            throw new IOException("Invalid authentication field name : " + string2);
        }
    }

    public synchronized void parseTopLine(String string) throws IOException {
        AuthPacket.verboseOut("top line=" + string);
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        if (stringTokenizer.countTokens() != 3) {
            throw new IOException("Invalid top line : " + string);
        }
        String string2 = stringTokenizer.nextToken();
        AuthPacket.verboseOut("step=" + string2);
        this.setStep(string2);
        String string3 = stringTokenizer.nextToken();
        AuthPacket.verboseOut("status=" + string3);
        this.setStatus(string3);
        String string4 = stringTokenizer.nextToken();
        AuthPacket.verboseOut("version=" + string4);
        if (!string4.equalsIgnoreCase(AUTHENTICATION_PROTOCOL_VERSION)) {
            throw new IOException("Invalid authentication version : " + string4);
        }
    }

    public synchronized void readFrom(DataInput dataInput) throws IOException {
        String string = dataInput.readLine().trim();
        this.readFrom(string, dataInput);
    }

    public synchronized void readFrom(String string, DataInput dataInput) throws IOException {
        this.parseTopLine(string);
        this.parseBody(dataInput);
    }

    private final void setAuthManner(int n) throws IllegalArgumentException {
        switch (n) {
            case 0: 
            case 1: 
            case 2: {
                this._manner = n;
                break;
            }
            default: {
                this._manner = 0;
                throw new IllegalArgumentException("Illegal manner : " + n);
            }
        }
    }

    private final void setAuthManner(String string) throws IllegalArgumentException {
        try {
            this.setAuthManner(AuthPacket.toAuthManner(string));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IllegalArgumentException("Illegal authentication manner : " + string);
        }
    }

    private final void setChallenge(Challenge challenge) {
        this._challenge = challenge;
    }

    private final void setChallenge(String string) {
        if (string == null || string.equals("")) {
            this._challenge = null;
        } else {
            this.setChallenge(new Challenge(string.trim()));
        }
    }

    private final void setResponse(Response response) {
        this._response = response;
    }

    private final void setResponse(String string) {
        if (string == null || string.equals("")) {
            this._response = null;
        } else {
            this.setResponse(new Response(string.trim()));
        }
    }

    private final void setSecurityDomain(String string) {
        this._domain = string;
    }

    private final void setSecurityDomains(String string) {
        this.setSecurityDomains(new StringTokenizer(string, DOMAIN_SEPARATOR));
    }

    private final void setSecurityDomains(Enumeration enumeration) {
        if (enumeration == null) {
            return;
        }
        this._domains = new Vector();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            this._domains.addElement(AuthPacket.decode(string.trim()));
        }
    }

    private final void setServerID(String string) {
        this._serverid = string;
    }

    private final void setStatus(int n) {
        this._status = n;
    }

    private final void setStatus(String string) {
        this.setStatus(Integer.parseInt(string.trim()));
    }

    private final void setStep(int n) throws IllegalArgumentException {
        switch (n) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                this._step = n;
                break;
            }
            default: {
                this._step = 0;
                throw new IllegalArgumentException("Illegal step : " + n);
            }
        }
    }

    private final void setStep(String string) throws IllegalArgumentException {
        String string2 = string.trim();
        int n = 0;
        n = string2.equalsIgnoreCase(STEP_START) ? 1 : (string2.equalsIgnoreCase(STEP_FIRST_TURN) ? 2 : (string2.equalsIgnoreCase(STEP_SECOND_TURN) ? 3 : (string2.equalsIgnoreCase(STEP_END) ? 4 : 0)));
        this.setStep(n);
    }

    public static int toAuthManner(String string) {
        return AuthPacket.toAuthManner(string, 0);
    }

    public static int toAuthManner(String string, int n) {
        int n2 = n;
        if (string == null) {
            return n;
        }
        String string2 = string.trim();
        if (string2.equalsIgnoreCase(AUTH_MANNER_DIGEST)) {
            n2 = 1;
        } else if (string2.equalsIgnoreCase(AUTH_MANNER_SIGNATURE)) {
            n2 = 2;
        }
        return n2;
    }

    public static String toAuthMannerString(int n) {
        String string = null;
        switch (n) {
            case 1: {
                string = AUTH_MANNER_DIGEST;
                break;
            }
            case 2: {
                string = AUTH_MANNER_SIGNATURE;
                break;
            }
            default: {
                string = null;
            }
        }
        return string;
    }

    static final void verboseOut(String string) {
        if (verbose) {
            System.out.println(string);
        }
    }

    public synchronized void writeTo(OutputStream outputStream) throws IOException {
        String string = this.getStepString() + " " + this.getStatusString() + " " + AUTHENTICATION_PROTOCOL_VERSION + CRLF;
        String string2 = this.getServerIDField();
        String string3 = this.getSecurityDomainsField();
        String string4 = this.getSecurityDomainField();
        String string5 = this.getAuthMannerField();
        String string6 = this.getChallengeField();
        String string7 = this.getResponseField();
        String string8 = string;
        if (string2 != null) {
            string8 = string8 + string2 + CRLF;
        }
        if (string3 != null) {
            string8 = string8 + string3 + CRLF;
        }
        if (string4 != null) {
            string8 = string8 + string4 + CRLF;
        }
        if (string5 != null) {
            string8 = string8 + string5 + CRLF;
        }
        if (string6 != null) {
            string8 = string8 + string6 + CRLF;
        }
        if (string7 != null) {
            string8 = string8 + string7 + CRLF;
        }
        string8 = string8 + END_OF_PACKET + CRLF;
        AuthPacket.verboseOut("packet=" + string8);
        outputStream.write(string8.getBytes());
    }

    static {
        Resource resource = Resource.getResourceFor("system");
        if (resource != null) {
            verbose = resource.getBoolean("verbose", false);
        }
        if (SERVERID == null) {
            StringBuffer stringBuffer = new StringBuffer();
            String string = null;
            String string2 = null;
            String string3 = null;
            AgletRuntime agletRuntime = AgletRuntime.getAgletRuntime();
            if (agletRuntime != null) {
                string = agletRuntime.getServerAddress();
                string2 = agletRuntime.getOwnerName();
            }
            Calendar calendar = Calendar.getInstance();
            Date date = calendar.getTime();
            long l = date.getTime();
            string3 = Hexadecimal.valueOf(l);
            stringBuffer.append(string);
            stringBuffer.append(FIELD_SEPARATOR);
            stringBuffer.append(string2);
            stringBuffer.append(FIELD_SEPARATOR);
            stringBuffer.append(string3);
            SERVERID = stringBuffer.toString();
        }
    }
}

