/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.atp.auth;

import com.ibm.atp.auth.Auth;
import com.ibm.atp.auth.AuthByDigest;
import com.ibm.atp.auth.AuthPacket;
import com.ibm.atp.auth.AuthenticationException;
import com.ibm.atp.auth.AuthenticationManager;
import com.ibm.atp.auth.AuthenticationProtocolException;
import com.ibm.atp.auth.Challenge;
import com.ibm.atp.auth.Response;
import com.ibm.atp.auth.ServerIdentifier;
import com.ibm.atp.auth.SharedSecret;
import com.ibm.atp.auth.SharedSecrets;
import java.io.DataInput;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;

public class Authentication {
    private boolean _authenticatedMyself = false;
    private boolean _authenticatedOpponent = false;
    private int _turn = 0;
    private Socket _socket = null;
    private InetAddress _localAddr = null;
    private InetAddress _remoteAddr = null;
    private ServerIdentifier _serverIdentifier = null;
    private DataInput _dataInput = null;
    private OutputStream _outputStream = null;
    private static SharedSecrets _secrets = null;
    private static final int DEFAULT_AUTHENTICATION_MANNER = 1;
    private int _manner = 1;
    static final int STEP_NOT_AUTHENTICATED = 0;
    static final int STEP_START = 1;
    static final int STEP_FIRST_TURN = 2;
    static final int STEP_SECOND_TURN = 3;
    static final int STEP_END = 4;
    private int _step = 0;
    static final int STATUS_NORMAL = 0;
    static final int STATUS_AUTHENTICATION_FAILED = 1;
    static final int STATUS_ILLEGAL_STEP = 2;
    static final int STATUS_UNKNOWN_DOMAIN = 3;
    static final int STATUS_UNKNOWN_MANNER = 4;
    static final int STATUS_INCONSISTENT_MANNER = 5;
    static final int STATUS_ERROR = 9;
    private int _status = 0;
    private SharedSecret _selectedSecret = null;
    private String _selectedDomainname = null;

    public Authentication(int n, DataInput dataInput, Socket socket) {
        this(n, dataInput, socket, 1);
    }

    public Authentication(int n, DataInput dataInput, Socket socket, int n2) {
        this.setTurn(n);
        this.setDataInput(dataInput);
        this.setSocket(socket);
        this.setAuthManner(n2);
    }

    public final synchronized boolean authenticate() throws AuthenticationProtocolException, IOException {
        if (this._step != 0) {
            this._status = 9;
            throw new AuthenticationProtocolException("Illegal initial step.");
        }
        Authentication.verboseOut("Authentication start.");
        if (this._turn == 1) {
            this.authenticateFirstTurn();
        } else if (this._turn == 2) {
            this.authenticateSecondTurn();
        } else {
            this._status = 9;
            throw new AuthenticationProtocolException("Illegal turn : " + this._turn);
        }
        Authentication.verboseOut("Authentication end.");
        return this._status == 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final synchronized void authenticateFirstTurn() throws IOException {
        if (this._turn != 1) {
            System.err.println("Not 1st turn.");
            this._status = 9;
            return;
        }
        Authentication.verboseOut("Authentication : 1st turn.");
        int n = 0;
        AuthByDigest authByDigest = null;
        Challenge challenge = null;
        Response response = null;
        AuthPacket authPacket = null;
        Authentication.verboseOut("Authentication : 1st turn : step=START");
        this._step = 1;
        SharedSecrets sharedSecrets = SharedSecrets.getSharedSecrets();
        authPacket = new AuthPacket(this._step, this._status, sharedSecrets.getDomainNames(), 0, null, null);
        Authentication.verboseOut("Authentication : 1st turn : step=START : sending packet ... ");
        authPacket.writeTo(this._outputStream);
        Authentication.verboseOut("packet sent.");
        this._status = 0;
        Authentication.verboseOut("Authentication : 1st turn : step=FIRST_TURN");
        Authentication.verboseOut("Authentication : 1st turn : step=FIRST_TURN : receiving packet ... ");
        authPacket = new AuthPacket(this._dataInput);
        Authentication.verboseOut("packet received.");
        this._status = authPacket.getStatus();
        Authentication.verboseOut("Authentication : status=" + this._status);
        if (this._status != 0) {
            return;
        }
        if (authPacket.getStep() != 2) {
            Authentication.verboseOut("Authentication : step=" + authPacket.getStep());
            this._status = 2;
            return;
        }
        this._selectedSecret = sharedSecrets.getSharedSecret(authPacket.getSecurityDomain());
        if (this._selectedSecret == null) {
            Authentication.verboseOut("Authentication : unknown domain=" + authPacket.getSecurityDomain());
            this._status = 3;
            return;
        }
        this._selectedDomainname = this._selectedSecret.getDomainName();
        Authentication.verboseOut("Authentication : selected domain=" + this._selectedDomainname);
        Authentication.verboseOut("Authentication : 1st turn : step=SECOND_TURN");
        this._step = 3;
        n = authPacket.getAuthManner();
        Authentication.verboseOut("Authentication : 1st turn : step=SECOND_TURN : manner=" + n);
        this.setAuthManner(n);
        challenge = authPacket.getChallenge();
        if (challenge != null) {
            Authentication.verboseOut("Authentication : 1st turn : step=SECOND_TURN : response of challenge is requested.");
            if (n == 1) {
                authByDigest = new AuthByDigest(this._selectedSecret);
            } else if (n != 2) {
                this._status = 4;
                return;
            }
            if (authByDigest != null) {
                authByDigest.setFirstTurnIdentifier(this._localAddr.getHostAddress());
                authByDigest.setSecondTurnIdentifier(this._remoteAddr.getHostAddress());
                try {
                    response = new Response(((Auth)authByDigest).calculateResponse(1, challenge));
                }
                catch (AuthenticationException authenticationException) {
                    System.err.println(authenticationException);
                    response = null;
                    this._status = 9;
                    return;
                }
            }
        } else {
            Authentication.verboseOut("Authentication : 1st turn : step=SECOND_TURN : response of challenge is NOT requested.");
            response = null;
        }
        this._authenticatedOpponent = false;
        challenge = new Challenge();
        authPacket = new AuthPacket(this._step, this._status, this._selectedDomainname, n, challenge, response);
        Authentication.verboseOut("Authentication : 1st turn : step=SECOND_TURN : sending packet ... ");
        authPacket.writeTo(this._outputStream);
        Authentication.verboseOut("packet sent.");
        this._status = 0;
        Authentication.verboseOut("Authentication : 1st turn : step=END");
        Authentication.verboseOut("Authentication : 1st turn : step=END : receiving packet ... ");
        authPacket = new AuthPacket(this._dataInput);
        Authentication.verboseOut("packet received.");
        this._status = authPacket.getStatus();
        Authentication.verboseOut("Authentication : status=" + this._status);
        if (this._status == 1) {
            this._authenticatedMyself = false;
            return;
        }
        this._authenticatedMyself = true;
        if (authPacket.getStep() != 4) {
            Authentication.verboseOut("Authentication : step=" + authPacket.getStep());
            this._status = 2;
            return;
        }
        if (!this._selectedDomainname.equals(authPacket.getSecurityDomain())) {
            Authentication.verboseOut("Authentication : unexpected domain=" + authPacket.getSecurityDomain());
            this._status = 3;
            return;
        }
        if (challenge == null) {
            Authentication.verboseOut("Authentication : 1st turn : step=END : response of challenge is NOT requested.");
            this._authenticatedOpponent = true;
            this._status = 0;
            return;
        }
        Authentication.verboseOut("Authentication : 1st turn : step=END : response of challenge is requested.");
        n = authPacket.getAuthManner();
        if (n != this._manner) {
            this._status = 5;
            return;
        }
        response = authPacket.getResponse();
        if (n != 1 && n != 2) {
            this._status = 4;
            return;
        }
        try {
            if (authByDigest != null && response != null && ((Auth)authByDigest).verify(2, challenge, response)) {
                Authentication.verboseOut("Authentication : 1st turn : step=END : verified.");
                AuthenticationManager.register(this._serverIdentifier, this._selectedDomainname);
                Authentication.verboseOut("Authentication : 1st turn : step=END : authenticated.");
                this._authenticatedOpponent = true;
                this._status = 0;
                return;
            }
            Authentication.verboseOut("Authentication : 1st turn : step=END : NOT verified.");
            this._authenticatedOpponent = false;
            this._status = 1;
            return;
        }
        catch (AuthenticationException authenticationException) {
            System.err.println(authenticationException);
            this._authenticatedOpponent = false;
            this._status = 1;
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final synchronized void authenticateSecondTurn() throws IOException {
        if (this._turn != 2) {
            System.err.println("Not 2nd turn.");
            this._status = 9;
            return;
        }
        Authentication.verboseOut("Authentication : 2nd turn.");
        int n = 0;
        AuthByDigest authByDigest = null;
        Challenge challenge = null;
        Response response = null;
        AuthPacket authPacket = null;
        Authentication.verboseOut("Authentication : 2nd turn : step=START");
        Authentication.verboseOut("Authentication : 2nd turn : step=START : receiving packet ... ");
        authPacket = new AuthPacket(this._dataInput);
        Authentication.verboseOut("packet received.");
        this._status = authPacket.getStatus();
        Authentication.verboseOut("Authentication : status=" + this._status);
        if (this._status != 0) {
            return;
        }
        if (authPacket.getStep() != 1) {
            Authentication.verboseOut("Authentication : step=" + authPacket.getStep());
            this._status = 2;
            return;
        }
        SharedSecrets sharedSecrets = SharedSecrets.getSharedSecrets();
        this._selectedSecret = sharedSecrets.selectSharedSecret(authPacket.getSecurityDomains());
        if (this._selectedSecret == null) {
            Authentication.verboseOut("Authentication : unknown domain=" + authPacket.getSecurityDomain());
            this._status = 3;
            return;
        }
        this._selectedDomainname = this._selectedSecret.getDomainName();
        Authentication.verboseOut("Authentication : selected domain=" + this._selectedDomainname);
        if (this._manner == 1) {
            authByDigest = new AuthByDigest(this._selectedSecret);
        } else if (this._manner != 2) {
            this._status = 4;
            return;
        }
        if (authByDigest != null) {
            authByDigest.setFirstTurnIdentifier(this._remoteAddr.getHostAddress());
            authByDigest.setSecondTurnIdentifier(this._localAddr.getHostAddress());
        }
        Authentication.verboseOut("Authentication : 2nd turn : step=FIRST_TURN");
        this._step = 2;
        n = this._manner;
        this._authenticatedOpponent = false;
        challenge = new Challenge();
        if (n != 1 && n != 2) {
            this._status = 4;
            return;
        }
        authPacket = new AuthPacket(this._step, this._status, this._selectedDomainname, n, challenge, null);
        Authentication.verboseOut("Authentication : 2nd turn : step=FIRST_TURN : sending packet ... ");
        authPacket.writeTo(this._outputStream);
        Authentication.verboseOut("packet sent.");
        this._status = 0;
        Authentication.verboseOut("Authentication : 2nd turn : step=SECOND_TURN");
        Authentication.verboseOut("Authentication : 2nd turn : step=SECOND_TURN : receiving packet ... ");
        authPacket = new AuthPacket(this._dataInput);
        Authentication.verboseOut("packet received.");
        this._status = authPacket.getStatus();
        Authentication.verboseOut("Authentication : status=" + this._status);
        if (this._status == 1) {
            this._authenticatedMyself = false;
            return;
        }
        this._authenticatedMyself = true;
        if (authPacket.getStep() != 3) {
            Authentication.verboseOut("Authentication : step=" + authPacket.getStep());
            this._status = 2;
            return;
        }
        if (!this._selectedDomainname.equals(authPacket.getSecurityDomain())) {
            Authentication.verboseOut("Authentication : unexpected domain=" + authPacket.getSecurityDomain());
            this._status = 3;
            return;
        }
        if (challenge != null) {
            n = authPacket.getAuthManner();
            if (n != this._manner) {
                this._status = 5;
                return;
            }
            response = authPacket.getResponse();
            if (n != 1 && n != 2) {
                this._status = 4;
                return;
            }
            try {
                if (authByDigest == null || response == null || !((Auth)authByDigest).verify(1, challenge, response)) {
                    Authentication.verboseOut("Authentication : 2nd turn : step=SECOND_TURN : NOT verified.");
                    this._authenticatedOpponent = false;
                    this._status = 1;
                    return;
                }
                Authentication.verboseOut("Authentication : 2nd turn : step=SECOND_TURN : verified.");
                AuthenticationManager.register(this._serverIdentifier, this._selectedDomainname);
                this._authenticatedOpponent = true;
                this._status = 0;
            }
            catch (AuthenticationException authenticationException) {
                System.err.println(authenticationException);
                this._authenticatedOpponent = false;
                this._status = 1;
                return;
            }
        } else {
            this._authenticatedOpponent = true;
            this._status = 0;
        }
        Authentication.verboseOut("Authentication : 2nd turn : step=END");
        this._step = 4;
        if (this._status == 1) {
            n = this._manner;
            response = null;
        } else {
            n = authPacket.getAuthManner();
            if (n != this._manner) {
                this._status = 5;
                return;
            }
            challenge = authPacket.getChallenge();
            if (challenge != null) {
                Authentication.verboseOut("Authentication : 2nd turn : step=END : response of challenge is requested.");
                if (n != 1 && n != 2) {
                    this._status = 4;
                    return;
                }
                try {
                    response = new Response(((Auth)authByDigest).calculateResponse(2, challenge));
                }
                catch (AuthenticationException authenticationException) {
                    System.err.println(authenticationException);
                    response = null;
                    this._status = 9;
                    return;
                }
            } else {
                Authentication.verboseOut("Authentication : 2nd turn : step=END : response of challenge is NOT requested.");
                response = null;
                this._status = 0;
            }
        }
        authPacket = new AuthPacket(this._step, this._status, this._selectedDomainname, n, null, response);
        Authentication.verboseOut("Authentication : 2nd turn : step=END : sending packet ... ");
        authPacket.writeTo(this._outputStream);
        Authentication.verboseOut("packet sent.");
        this._status = 0;
    }

    public final int getAuthManner() {
        return this._manner;
    }

    public final DataInput getDataInput() {
        return this._dataInput;
    }

    public final InetAddress getLocalAddress() {
        return this._localAddr;
    }

    public final OutputStream getOutputStream() {
        return this._outputStream;
    }

    public final InetAddress getRemoteAddress() {
        return this._remoteAddr;
    }

    public final String getSelectedDomainName() {
        return this._selectedDomainname;
    }

    public final SharedSecret getSelectedSecret() {
        return this._selectedSecret;
    }

    public final Socket getSocket() {
        return this._socket;
    }

    public final int getTurn() {
        return this._turn;
    }

    public boolean isAuthenticatedMyself() {
        return this._authenticatedMyself;
    }

    public boolean isAuthenticatedOpponent() {
        return this._authenticatedOpponent;
    }

    private final void setAuthManner(int n) throws IllegalArgumentException {
        if (n != 1 && n != 2) {
            this._manner = 0;
            throw new IllegalArgumentException("Illegal manner : " + n);
        }
        this._manner = n;
    }

    private final void setDataInput(DataInput dataInput) {
        this._dataInput = dataInput;
    }

    private final void setSocket(Socket socket) {
        this._socket = socket;
        this._localAddr = this._socket.getLocalAddress();
        this._remoteAddr = this._socket.getInetAddress();
        this._serverIdentifier = new ServerIdentifier(this._socket);
        try {
            this._outputStream = this._socket.getOutputStream();
        }
        catch (IOException iOException) {
            this._outputStream = null;
        }
    }

    private final void setStatus(int n) throws IllegalArgumentException {
        switch (n) {
            case 0: 
            case 1: 
            case 9: {
                this._status = n;
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal status : " + n);
            }
        }
    }

    private final void setTurn(int n) throws IllegalArgumentException {
        if (n != 1 && n != 2) {
            this._turn = 0;
            throw new IllegalArgumentException("Illegal turn : " + n);
        }
        this._turn = n;
    }

    private static final void verboseOut(String string) {
        AuthPacket.verboseOut(string);
    }
}

