/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.atp.auth;

import com.ibm.aglets.security.Randoms;
import com.ibm.awb.misc.Hexadecimal;
import java.io.Serializable;

public class ByteSequence
implements Cloneable,
Serializable {
    static final long serialVersionUID = -742497536523647344L;
    private static final char DELIMITER = ' ';
    private static final String DELIMITERS = String.valueOf(' ');
    private byte[] _seq = null;

    public ByteSequence(byte[] byArray) {
        if (byArray != null) {
            this._seq = new byte[byArray.length];
            this.copy(byArray);
        }
    }

    public ByteSequence(int n) {
        this._seq = new byte[n];
        Randoms.getRandom(n, this._seq);
    }

    public ByteSequence(int n, String string) {
        this(n, string, DELIMITERS);
    }

    public ByteSequence(int n, String string, String string2) {
        byte[] byArray = null;
        try {
            byArray = Hexadecimal.parseSeq(string, string2);
        }
        catch (NumberFormatException numberFormatException) {
            System.err.println(numberFormatException.toString());
        }
        int n2 = n == 0 ? byArray.length : n;
        this._seq = new byte[n2];
        int n3 = 0;
        while (n3 < n2) {
            this._seq[n3] = byArray[n3];
            ++n3;
        }
    }

    public ByteSequence(ByteSequence byteSequence) {
        if (byteSequence != null) {
            byte[] byArray = byteSequence.sequence();
            if (byteSequence != null) {
                this._seq = new byte[byArray.length];
                this.copy(byteSequence);
            }
        }
    }

    public ByteSequence(String string) {
        byte[] byArray;
        if (string != null && (byArray = string.getBytes()) != null) {
            this._seq = new byte[byArray.length];
            this.copy(byArray);
        }
    }

    public synchronized void append(byte[] byArray) {
        if (byArray == null) {
            return;
        }
        byte[] byArray2 = this.sequence();
        int n = 0;
        if (byArray2 != null) {
            n = byArray2.length;
        }
        byte[] byArray3 = new byte[n + byArray.length];
        int n2 = 0;
        while (n2 < n) {
            byArray3[n2] = byArray2[n2];
            ++n2;
        }
        n2 = 0;
        while (n2 < byArray.length) {
            byArray3[n2 + n] = byArray[n2];
            ++n2;
        }
        this._seq = byArray3;
    }

    public synchronized void append(byte by) {
        byte[] byArray = this.sequence();
        int n = 0;
        if (byArray != null) {
            n = byArray.length;
        }
        this._seq = new byte[n + 1];
        int n2 = 0;
        while (n2 < n) {
            this._seq[n2] = byArray[n2];
            ++n2;
        }
        this._seq[n] = by;
    }

    public synchronized void append(ByteSequence byteSequence) {
        if (byteSequence != null) {
            this.append(byteSequence.sequence());
        }
    }

    public synchronized void append(String string) {
        if (string != null) {
            this.append(string.getBytes());
        }
    }

    protected Object clone() {
        ByteSequence byteSequence = new ByteSequence(this);
        return byteSequence;
    }

    public synchronized void copy(byte[] byArray) {
        if (this._seq == null) {
            return;
        }
        int n = 0;
        while (n < this._seq.length) {
            this._seq[n] = n < byArray.length ? byArray[n] : (byte)0;
            ++n;
        }
    }

    public synchronized void copy(ByteSequence byteSequence) {
        if (byteSequence != null) {
            this.copy(byteSequence.sequence());
        }
    }

    public synchronized void copy(String string) {
        if (string != null) {
            this.copy(string.getBytes());
        }
    }

    public boolean equals(byte[] byArray) {
        if (byArray == null && this._seq == null) {
            return true;
        }
        if (byArray == null || this._seq == null) {
            return false;
        }
        if (byArray.length != this._seq.length) {
            return false;
        }
        int n = 0;
        while (n < this._seq.length) {
            if (this._seq[n] != byArray[n]) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public boolean equals(ByteSequence byteSequence) {
        if (byteSequence == null) {
            return false;
        }
        return this.equals(byteSequence.sequence());
    }

    public boolean equals(Object object) {
        if (object instanceof ByteSequence) {
            return this.equals((ByteSequence)object);
        }
        return false;
    }

    public int length() {
        if (this._seq == null) {
            return 0;
        }
        return this._seq.length;
    }

    public byte[] sequence() {
        return this._seq;
    }

    public String toString() {
        return Hexadecimal.valueOf(this._seq, ' ');
    }
}

