/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.atp.auth;

import com.ibm.aglets.AgletRuntime;
import com.ibm.atp.auth.ByteSequence;
import com.ibm.awb.misc.Hexadecimal;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.security.AccessController;
import java.security.InvalidKeyException;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PrivilegedAction;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.util.Enumeration;
import java.util.Vector;

public final class SharedSecret
extends ByteSequence {
    static final long serialVersionUID = -7990001265976183031L;
    private static final String MESSAGE_DIGEST_ALGORITHM = "SHA";
    private static MessageDigest _mdigest = null;
    private static final String SIGNATURE_ALGORITHM = "DSA";
    public static final int LENGTH = 32;
    private static final String FIELD_SECRET = "Secret";
    private static final String FIELD_DOMAIN_NAME = "Domain";
    private static final String FIELD_CREATOR = "Creator";
    private static final String FIELD_SIGNATURE = "Signature";
    private static final char CHAR_COLON = ':';
    private static final String FIELD_NAME_TERM = String.valueOf(':') + " ";
    private Signature _sign = null;
    private transient String _domainName = null;
    private transient String _signature = null;
    private transient Certificate _creatorCert = null;
    private transient byte[] _domainNameSeq = null;
    private transient byte[] _signatureSeq = null;
    private static final String SAMPLE_SECRET = "f76e9f4a26739aaab601db9fc19bc1f85458f8ef3505ba91e649380f54bd6e13";
    private static final String SAMPLE_CREATION_DATE = "1998.08.13 15:52:31.699 GMT+09:00";
    private static final String SAMPLE_DOMAIN_NAME = "Aglets Sample Domain";
    private static final String SAMPLE_OWNER_NAME = "asdkprovider";
    private static final String SAMPLE_SIGNATURE = "302c02146866abdafbb949aa05a3ab1e3ce0331ea20f7ffb021440927ff702f4e3c9b552a3bb02e8ded8f955a1cd";
    private static final String PROPERTY_CRLF = "line.separator";
    private static final String DEFAULT_CRLF = "\r\n";
    private static String _strNewLine = null;
    private transient byte[] _creatorCertSeq = null;

    private SharedSecret(String string, Certificate certificate) {
        super(32);
        this.init();
        this.setDomainName(string);
        this.setCreator(certificate);
    }

    private SharedSecret(String string, Certificate certificate, String string2, String string3) throws KeyStoreException {
        super(0, string2, null);
        this.init();
        this.setDomainName(string);
        this.setCreator(certificate);
        this.setSignature(string3);
    }

    static final SharedSecret convertLinesToSharedSecret(Enumeration enumeration) {
        if (enumeration == null) {
            return null;
        }
        String string = null;
        String string2 = null;
        String string3 = null;
        Certificate certificate = null;
        String string4 = null;
        while (enumeration.hasMoreElements()) {
            string4 = (String)enumeration.nextElement();
            if (string4 == null) break;
            int n = string4.indexOf(FIELD_NAME_TERM);
            if (n < 0) continue;
            String string5 = string4.substring(0, n);
            String string6 = string4.substring(n + FIELD_NAME_TERM.length() - 1).trim();
            if (FIELD_DOMAIN_NAME.equals(string5)) {
                string = string6;
                continue;
            }
            if (FIELD_SECRET.equals(string5)) {
                string2 = string6;
                continue;
            }
            if (FIELD_SIGNATURE.equals(string5)) {
                string3 = string6;
                continue;
            }
            if (!FIELD_CREATOR.equals(string5)) continue;
            String string7 = string6;
            byte[] byArray = Hexadecimal.parseSeq(string7);
            certificate = AgletRuntime.getCertificate(byArray);
        }
        if (string == null || string.equals("")) {
            System.err.println("Domain name of shared secret is null.");
            return null;
        }
        if (string2 == null || string2.equals("")) {
            System.err.println("Byte sequence of shared secret is null.");
            return null;
        }
        if (string3 == null || string3.equals("")) {
            System.err.println("Byte sequence of shared secret is null.");
            return null;
        }
        if (certificate == null) {
            System.err.println("Creator of shared secret is null.");
            return null;
        }
        try {
            SharedSecret sharedSecret = new SharedSecret(string, certificate, string2, string3);
            if (sharedSecret.verify()) {
                return sharedSecret;
            }
        }
        catch (KeyStoreException keyStoreException) {
            keyStoreException.printStackTrace();
            return null;
        }
        System.err.println("Signature of shared secret is incorrect.");
        return null;
    }

    public static final synchronized SharedSecret createNewSharedSecret(String string, String string2, String string3) {
        PrivateKey privateKey;
        Certificate certificate = AgletRuntime.getCertificate(string2);
        if (certificate == null) {
            System.err.println("SharedSecret.createNewSharedSecret: Creator's certificate was not found");
            return null;
        }
        char[] cArray = null;
        if (string3 != null) {
            cArray = string3.toCharArray();
        }
        if ((privateKey = AgletRuntime.getPrivateKey(certificate, cArray)) == null) {
            System.err.println("SharedSecret.createNewSharedSecert: Failed to get creator's private key");
            return null;
        }
        SharedSecret sharedSecret = new SharedSecret(string, certificate);
        sharedSecret.sign(privateKey);
        return sharedSecret;
    }

    public Certificate getCreatorCert() {
        return this._creatorCert;
    }

    public String getCreatorEncodedString() {
        return Hexadecimal.valueOf(this._creatorCertSeq);
    }

    public String getDomainName() {
        return this._domainName;
    }

    private String getSecret() {
        return Hexadecimal.valueOf(this.sequence());
    }

    public byte[] getSignature() {
        return this._signatureSeq;
    }

    public String getSignatureString() {
        return this._signature;
    }

    private final void init() {
        try {
            this._sign = Signature.getInstance(SIGNATURE_ALGORITHM);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            System.err.println(noSuchAlgorithmException.toString());
        }
    }

    public static synchronized SharedSecret load(String string) throws FileNotFoundException, IOException {
        FileReader fileReader = new FileReader(string);
        BufferedReader bufferedReader = new BufferedReader(fileReader);
        Vector<String> vector = new Vector<String>();
        String string2 = null;
        while ((string2 = bufferedReader.readLine()) != null) {
            vector.addElement(string2);
        }
        bufferedReader.close();
        return SharedSecret.convertLinesToSharedSecret(vector.elements());
    }

    public void save(String string) throws IOException {
        Enumeration enumeration = this.toLines();
        if (enumeration == null) {
            System.err.println("No secret.");
            return;
        }
        FileWriter fileWriter = new FileWriter(string);
        BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            bufferedWriter.write(string2);
            bufferedWriter.newLine();
        }
        bufferedWriter.flush();
        bufferedWriter.close();
    }

    public static synchronized void save(String string, SharedSecret sharedSecret) throws IOException {
        if (sharedSecret == null) {
            throw new IOException("Secret is null.");
        }
        sharedSecret.save(string);
    }

    public final byte[] secret() {
        try {
            ByteSequence byteSequence = new ByteSequence(this.sequence());
            byteSequence.append(this._domainNameSeq);
            byteSequence.append(this._creatorCert.getEncoded());
            return byteSequence.sequence();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private void setCreator(Certificate certificate) {
        try {
            this._creatorCert = certificate;
            this._creatorCertSeq = certificate.getEncoded();
        }
        catch (CertificateEncodingException certificateEncodingException) {
            System.out.println("Cannot get encoded byte sequence of the creator's certificate: " + certificate.toString());
            this._creatorCert = null;
            this._creatorCertSeq = null;
        }
    }

    private void setDomainName(String string) {
        this._domainName = string;
        ByteSequence byteSequence = new ByteSequence(string);
        this._domainNameSeq = byteSequence.sequence();
    }

    private void setSignature(byte[] byArray) {
        this._signature = Hexadecimal.valueOf(byArray);
        this._signatureSeq = byArray;
    }

    private void setSignature(String string) {
        byte[] byArray = null;
        try {
            byArray = Hexadecimal.parseSeq(string);
        }
        catch (NumberFormatException numberFormatException) {
            return;
        }
        this._signature = string;
        this._signatureSeq = byArray;
    }

    private final void sign(PrivateKey privateKey) {
        if (privateKey == null) {
            System.err.println("Sharedsecret.sign(): null private key");
            return;
        }
        try {
            _mdigest.reset();
            _mdigest.update(this.secret());
            this._sign.initSign(privateKey);
            this._sign.update(_mdigest.digest());
            this.setSignature(this._sign.sign());
        }
        catch (InvalidKeyException invalidKeyException) {
            System.err.println(invalidKeyException.toString());
            return;
        }
        catch (SignatureException signatureException) {
            System.err.println(signatureException.toString());
            return;
        }
    }

    public Enumeration toLines() {
        Vector<String> vector = null;
        String string = this.getSecret();
        String string2 = this.getDomainName();
        String string3 = this.getCreatorEncodedString();
        String string4 = this.getSignatureString();
        if (string != null && !string.equals("")) {
            if (vector == null) {
                vector = new Vector<String>();
            }
            vector.addElement(FIELD_SECRET + FIELD_NAME_TERM + string);
        }
        if (string2 != null && !string2.equals("")) {
            if (vector == null) {
                vector = new Vector();
            }
            vector.addElement(FIELD_DOMAIN_NAME + FIELD_NAME_TERM + string2);
        }
        if (string3 != null && !string3.equals("")) {
            if (vector == null) {
                vector = new Vector();
            }
            vector.addElement(FIELD_CREATOR + FIELD_NAME_TERM + string3);
        }
        if (string4 != null && !string4.equals("")) {
            if (vector == null) {
                vector = new Vector();
            }
            vector.addElement(FIELD_SIGNATURE + FIELD_NAME_TERM + string4);
        }
        if (vector == null) {
            return null;
        }
        return vector.elements();
    }

    public String toString() {
        Enumeration enumeration = this.toLines();
        if (enumeration == null) {
            return null;
        }
        String string = null;
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            string = string == null ? string2 : string + _strNewLine + string2;
        }
        return string;
    }

    private final boolean verify() {
        if (this._signatureSeq == null) {
            return false;
        }
        try {
            _mdigest.reset();
            _mdigest.update(this.secret());
            this._sign.initVerify(this._creatorCert.getPublicKey());
            this._sign.update(_mdigest.digest());
            return this._sign.verify(this.getSignature());
        }
        catch (InvalidKeyException invalidKeyException) {
            System.err.println(invalidKeyException.toString());
            return false;
        }
        catch (SignatureException signatureException) {
            System.err.println(signatureException.toString());
            return false;
        }
    }

    static {
        try {
            _mdigest = MessageDigest.getInstance(MESSAGE_DIGEST_ALGORITHM);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            noSuchAlgorithmException.printStackTrace();
        }
        try {
            _strNewLine = (String)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return System.getProperty(SharedSecret.PROPERTY_CRLF, SharedSecret.DEFAULT_CRLF);
                }
            });
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

