/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.awb.launcher;

import com.ibm.aglet.AgletContext;
import com.ibm.aglet.system.AgletRuntime;
import com.ibm.aglet.system.ContextListener;
import com.ibm.aglets.MAFAgentSystem_AgletsImpl;
import com.ibm.aglets.tahiti.CommandLine;
import com.ibm.aglets.tahiti.Tahiti;
import com.ibm.aglets.tahiti.TahitiDaemon;
import com.ibm.aglets.tahiti.UserManager;
import com.ibm.awb.misc.FileUtils;
import com.ibm.awb.misc.LogStream;
import com.ibm.awb.misc.Resource;
import com.ibm.awb.misc.TeeOutputStream;
import com.ibm.maf.MAFAgentSystem;
import java.awt.Frame;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.cert.Certificate;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import org.aglets.log.LogCategory;
import org.aglets.log.LogInitializer;

public class Main {
    private static final String VIEWER_TAHITI = "com.ibm.aglets.tahiti.Tahiti";
    private static final String VIEWER_COMMANDLINE = "com.ibm.aglets.tahiti.CommandLine";
    private static final String VIEWER_TAHITI_DAEMON = "com.ibm.aglets.tahiti.TahitiDaemon";
    private static final String DEFAULT_VIEWER = "com.ibm.aglets.tahiti.Tahiti";
    private static final String DELIM = ", \t\n";
    private static String[] _startup_aglets = null;
    private static String _viewer_class_name = "com.ibm.aglets.tahiti.Tahiti";
    private static boolean _reactivation = true;
    private static int _port_num = -1;
    private static int _control_port_num = -1;
    private static boolean _verbose = false;
    private static boolean _nogui = false;
    private static boolean _daemon = false;
    private static boolean _nosound = false;
    private static String FS;
    private static String PS;
    static /* synthetic */ Class class$com$ibm$aglet$system$ContextListener;

    public static void main(String[] stringArray) throws IOException {
        Properties properties = System.getProperties();
        FS = properties.getProperty("file.separator");
        PS = properties.getProperty("path.separator");
        Main.setDefaultProperties();
        Main.parseArgs(stringArray);
        Main.resolveProperties();
        if (_verbose) {
            ((Hashtable)properties).put("verbose", "true");
        } else {
            ((Hashtable)properties).put("verbose", "false");
        }
        if (_port_num > 0) {
            ((Hashtable)properties).put("maf.port", Integer.toString(_port_num));
        }
        if (_control_port_num > 0) {
            ((Hashtable)properties).put("maf.controlport", Integer.toString(_control_port_num));
        }
        try {
            Main.bootstrap();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected static void startupAglets(AgletContext agletContext) {
        Object object;
        Object object2;
        Object[] objectArray = null;
        boolean bl = false;
        String string = System.getProperties().getProperty("aglets.startup", null);
        if (string != null) {
            object2 = new StringTokenizer(string, DELIM);
            object = new Vector<String>();
            while (((StringTokenizer)object2).hasMoreTokens()) {
                ((Vector)object).addElement(((StringTokenizer)object2).nextToken());
            }
            objectArray = new String[((Vector)object).size()];
            ((Vector)object).copyInto(objectArray);
            bl = true;
        }
        if (objectArray == null) {
            object2 = Resource.getResourceFor("tahiti");
            bl = ((Resource)object2).getBoolean("tahiti.startup", false);
            objectArray = ((Resource)object2).getStringArray("tahiti.startupAglets", DELIM);
        }
        if (bl && objectArray != null) {
            int n = 0;
            while (n < objectArray.length) {
                object = null;
                URL uRL = null;
                String string2 = objectArray[n];
                try {
                    int n2 = string2.lastIndexOf(35);
                    if (n2 > 0) {
                        object = string2.substring(n2 + 1);
                        string2 = string2.substring(0, n2);
                    }
                    if ((n2 = string2.lastIndexOf(47)) > 0) {
                        uRL = new URL(string2.substring(0, n2));
                        string2 = string2.substring(n2 + 1);
                    }
                }
                catch (MalformedURLException malformedURLException) {
                    malformedURLException.printStackTrace();
                }
                try {
                    agletContext.createAglet(uRL, string2, object);
                }
                catch (Exception exception) {
                    System.err.println("Failed to create the \"Startup\" Aglet:" + exception.getMessage());
                    System.err.println("[" + uRL + "] [" + string2 + "]");
                    exception.printStackTrace();
                }
                ++n;
            }
        }
    }

    private static void setDefaultProperties() {
        Properties properties = System.getProperties();
        ((Hashtable)properties).remove("java.policy");
        ((Hashtable)properties).remove("aglets.class.path");
        ((Hashtable)properties).remove("aglets.public.root");
        ((Hashtable)properties).put("verbose", "false");
        ((Hashtable)properties).put("maf.protocol", "atp");
        ((Hashtable)properties).put("maf.port", "4434");
        ((Hashtable)properties).put("maf.controlport", "5545");
        ((Hashtable)properties).remove("maf.finder.host");
        ((Hashtable)properties).put("maf.finder.port", "4435");
        ((Hashtable)properties).put("maf.finder.name", "MAFFinder");
        ((Hashtable)properties).put("aglets.secure", "true");
        ((Hashtable)properties).put("aglets.viewer", "com.ibm.aglets.tahiti.Tahiti");
        ((Hashtable)properties).put("aglets.cleanstart", "false");
        ((Hashtable)properties).remove("aglets.startup");
        ((Hashtable)properties).put("aglets.owner.name", properties.getProperty("user.name"));
        ((Hashtable)properties).remove("aglets.logfile");
        ((Hashtable)properties).put("atp.resolve", "false");
        ((Hashtable)properties).put("atp.offline", "false");
        ((Hashtable)properties).put("atp.authentication", "false");
        ((Hashtable)properties).put("atp.secureseed", "true");
    }

    private static ContextListener getViewer() {
        return Main.getViewer(_viewer_class_name);
    }

    private static ContextListener getViewer(String string) {
        if (string != null && string.length() > 0) {
            Class<?> clazz = null;
            try {
                clazz = Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                System.err.println("[Viewer " + string + " not found.]");
                return null;
            }
            if (!(class$com$ibm$aglet$system$ContextListener == null ? (class$com$ibm$aglet$system$ContextListener = Main.class$("com.ibm.aglet.system.ContextListener")) : class$com$ibm$aglet$system$ContextListener).isAssignableFrom(clazz)) {
                System.err.println("[Viewer " + string + " is not subclass of ContextListener interface.");
                return null;
            }
            try {
                return (ContextListener)clazz.newInstance();
            }
            catch (IllegalAccessException illegalAccessException) {
                return null;
            }
            catch (InstantiationException instantiationException) {
                return null;
            }
        }
        return null;
    }

    private static void bootstrap() throws Exception {
        Object object;
        String string = System.getProperty("aglets.logger.class", "org.aglets.log.quiet.QuietInitializer");
        Class.forName(string);
        LogCategory logCategory = LogInitializer.getCategory("com.ibm.awb.launcher.Main");
        logCategory.info("Logging system initialized!");
        if (!_nogui && !_daemon) {
            _viewer_class_name = "com.ibm.aglets.tahiti.Tahiti";
            if (_verbose) {
                System.err.print("[Loading AWT classes ... ");
            }
            Main.loadAWTClasses();
            if (_verbose) {
                System.err.println("done.]");
            }
            if (!_nosound) {
                if (_verbose) {
                    System.err.print("[Loading Audio classes ... ");
                }
                Main.loadAudioClasses();
                if (_verbose) {
                    System.err.println("done.]");
                }
            }
        }
        if (_nogui) {
            _viewer_class_name = VIEWER_COMMANDLINE;
        }
        if (_daemon) {
            _viewer_class_name = VIEWER_TAHITI_DAEMON;
        }
        AgletRuntime agletRuntime = AgletRuntime.init(null);
        String string2 = System.getProperty("aglets.owner.name");
        boolean bl = false;
        if (string2 != null) {
            object = System.getProperty("aglets.owner.password");
            boolean bl2 = bl = agletRuntime.authenticateOwner(string2, (String)object) != null;
            if (bl) {
                if (_verbose) {
                    System.err.println("[Succeed in owner authentication: \"" + string2 + "\"]");
                }
            } else if (_verbose) {
                System.err.println("[Failed to authenticate the owner: \"" + string2 + "\"]");
            }
        }
        if (!bl && Main.login(agletRuntime) == null) {
            return;
        }
        object = new MAFAgentSystem_AgletsImpl(agletRuntime);
        String string3 = System.getProperties().getProperty("maf.protocol");
        MAFAgentSystem.initMAFAgentSystem((MAFAgentSystem)object, string3);
        Tahiti.init();
        Tahiti.installFactories();
        AgletContext agletContext = agletRuntime.createAgletContext("");
        ContextListener contextListener = Main.getViewer();
        if (contextListener != null) {
            agletContext.addContextListener(contextListener);
        }
        Tahiti.installSecurity();
        MAFAgentSystem.startMAFAgentSystem((MAFAgentSystem)object, string3);
        agletContext.start(_reactivation);
        Main.startupAglets(agletContext);
        if (_verbose) {
            System.err.println("Aglets server started");
        }
    }

    private static void loadAudioClasses() {
        try {
            Class.forName("sun.audio.AudioPlayer");
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    private static void loadAWTClasses() {
        try {
            Frame frame = new Frame();
            frame.addNotify();
            frame.dispose();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    private static Certificate login(AgletRuntime agletRuntime) {
        UserManager userManager = null;
        if ("com.ibm.aglets.tahiti.Tahiti".equals(_viewer_class_name)) {
            userManager = Tahiti.getUserManager();
        } else if (VIEWER_COMMANDLINE.equals(_viewer_class_name)) {
            userManager = CommandLine.getUserManager();
        } else if (VIEWER_TAHITI_DAEMON.equals(_viewer_class_name)) {
            userManager = TahitiDaemon.getUserManager();
        }
        String string = agletRuntime.getOwnerName();
        if (string == null) {
            string = UserManager.getDefaultUsername();
        }
        if (string == null) {
            System.err.println("No username.");
            return null;
        }
        Certificate certificate = agletRuntime.authenticateOwner(string, "");
        if (certificate == null && userManager != null) {
            certificate = userManager.login();
            string = userManager.getUsername();
        }
        if (certificate == null) {
            System.err.println("Authentication of user '" + string + "' is failed.");
        }
        return certificate;
    }

    private static void parseArgs(String[] stringArray) {
        if (stringArray.length <= 0) {
            return;
        }
        int n = 0;
        while (n < stringArray.length) {
            if (!stringArray[n].equalsIgnoreCase("-help")) {
                if (stringArray[n].equalsIgnoreCase("-verbose")) {
                    _verbose = true;
                } else if (stringArray[n].equalsIgnoreCase("-nogui")) {
                    _nogui = true;
                } else if (stringArray[n].equalsIgnoreCase("-daemon")) {
                    _daemon = true;
                } else if (stringArray[n].equalsIgnoreCase("-nosound")) {
                    _nosound = true;
                } else if (stringArray[n].equalsIgnoreCase("-cleanstart")) {
                    _reactivation = false;
                } else if (stringArray[n].equalsIgnoreCase("-f")) {
                    if (n + 1 >= stringArray.length) {
                        Main.usage();
                    }
                    ++n;
                    try {
                        Main.readProperties(stringArray[n]);
                    }
                    catch (IOException iOException) {
                        System.err.println("Server property file was not found: " + stringArray[n]);
                        Main.usage();
                    }
                } else if (stringArray[n].equalsIgnoreCase("-port")) {
                    if (n + 1 >= stringArray.length) {
                        Main.usage();
                    }
                    ++n;
                    try {
                        _port_num = Integer.parseInt(stringArray[n]);
                    }
                    catch (NumberFormatException numberFormatException) {
                        numberFormatException.printStackTrace();
                    }
                } else if (stringArray[n].equalsIgnoreCase("-controlport")) {
                    if (n + 1 >= stringArray.length) {
                        Main.usage();
                    }
                    ++n;
                    try {
                        _control_port_num = Integer.parseInt(stringArray[n]);
                    }
                    catch (NumberFormatException numberFormatException) {
                        numberFormatException.printStackTrace();
                    }
                }
            }
            ++n;
        }
    }

    private static String pathConcat(String string, String string2) {
        string2 = string2.replace('/', FS.charAt(0));
        if (!string.endsWith(FS)) {
            string = string + FS;
        }
        if (string2.startsWith(FS)) {
            string2 = string2.substring(0, string2.length() - 1);
        }
        return string + string2;
    }

    private static void readProperties(String string) throws IOException {
        if (_verbose) {
            System.err.println("[Reading property file: " + string + "]");
        }
        FileInputStream fileInputStream = new FileInputStream(string);
        Properties properties = System.getProperties();
        Properties properties2 = new Properties();
        properties2.load(fileInputStream);
        Enumeration<?> enumeration = properties2.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            String string3 = (String)((Hashtable)properties2).get(string2);
            if (!"aglets.viewer".equals(string2) && (string3 == null || string3.length() <= 0)) continue;
            if (string3 == null) {
                ((Hashtable)properties).remove(string2);
                continue;
            }
            ((Hashtable)properties).put(string2, string3);
        }
    }

    private static void resolveProperties() {
        String string;
        String string2;
        Properties properties = System.getProperties();
        String string3 = properties.getProperty("install.root");
        if (string3 == null && ((string3 = properties.getProperty("aglets.home", null)) == null || string3.length() == 0)) {
            System.err.println("Please specify aglets.home property");
            System.exit(1);
        }
        if ((string2 = properties.getProperty("user.home", null)) == null || string2.length() == 0) {
            string2 = FileUtils.getUserHome();
        }
        if (string2 == null || string2.length() == 0) {
            System.err.println("Please specify user.home property");
            System.exit(1);
        }
        if ((string = properties.getProperty("java.policy", null)) == null) {
            ((Hashtable)properties).put("java.policy", Main.pathConcat(string2, ".aglets/security/aglets.policy"));
        }
        if ((string = properties.getProperty("aglets.class.path", null)) == null) {
            ((Hashtable)properties).put("aglets.class.path", Main.pathConcat(string3, "public"));
        }
        if ((string = properties.getProperty("aglets.public.root", null)) == null) {
            ((Hashtable)properties).put("aglets.public.root", Main.pathConcat(string3, "public"));
        }
        _viewer_class_name = properties.getProperty("aglets.viewer", null);
        string = properties.getProperty("aglets.logfile", null);
        if (string != null) {
            try {
                LogStream logStream = new LogStream("LOG", new FileOutputStream(string));
                TeeOutputStream teeOutputStream = new TeeOutputStream(System.out, logStream);
                PrintStream printStream = new PrintStream(teeOutputStream);
                System.setOut(printStream);
                System.setErr(printStream);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if ("true".equalsIgnoreCase(string = properties.getProperty("aglets.cleanstart", "false"))) {
            _reactivation = false;
        }
    }

    private static void usage() {
        System.err.println("\nAglet Server(com.ibm.awb.launcher.Main) usage:");
        System.err.println("options:");
        System.err.println("    -f <file.props>  server property file");
        System.err.println("    -port <num>      port number (default 4434)");
        System.err.println("    -controlport <num>      port number (default 4444)");
        System.err.println("    -verbose         verbose output");
        System.err.println("    -nogui           omit AWT initialization");
        System.err.println("    -daemon          run as a daemon");
        System.err.println("    -nosound         omit Sound initialization");
        System.err.println("    -cleanstart      kill deactivated aglets");
        System.err.println("    -help            print this message");
        System.err.println("note: '-f' option can be specified more than once,");
        System.err.println("        properties in the following file will override");
        System.exit(1);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

