/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.awb.misc;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Enumeration;
import java.util.Hashtable;

public class Archive
implements Serializable {
    Hashtable cache = new Hashtable();
    protected static MessageDigest digestGen;

    public synchronized Entry[] entries() {
        Entry[] entryArray = new Entry[this.cache.size()];
        Enumeration enumeration = this.cache.elements();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            entryArray[n++] = (Entry)enumeration.nextElement();
        }
        return entryArray;
    }

    public synchronized Entry getEntry(String string) {
        return (Entry)this.cache.get(string);
    }

    public byte[] getResourceAsByteArray(String string) {
        return this.getResourceInCache(string);
    }

    public InputStream getResourceAsStream(String string) {
        byte[] byArray = this.getResourceInCache(string);
        if (byArray != null) {
            return new ByteArrayInputStream(byArray);
        }
        return null;
    }

    protected byte[] getResourceInCache(String string) {
        Entry entry = this.getEntry(string);
        if (entry != null) {
            return entry.data;
        }
        return null;
    }

    public synchronized void putResource(String string, byte[] byArray) {
        this.cache.put(string, new Entry(string, 0L, byArray));
    }

    public synchronized void putResource(String string, long l, byte[] byArray) {
        this.cache.put(string, new Entry(string, l, byArray));
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
    }

    public synchronized void removeResource(String string) {
        this.cache.remove(string);
    }

    public String toString() {
        Enumeration enumeration = this.cache.elements();
        StringBuffer stringBuffer = new StringBuffer();
        int n = 1;
        while (enumeration.hasMoreElements()) {
            Entry entry = (Entry)enumeration.nextElement();
            stringBuffer.append("[" + n + "] " + entry.name + ", " + entry.digest() + '\n');
            ++n;
        }
        return stringBuffer.toString();
    }

    static {
        try {
            digestGen = MessageDigest.getInstance("SHA");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            noSuchAlgorithmException.printStackTrace();
        }
    }

    public static final class Entry
    implements Serializable {
        String name;
        byte[] data = null;
        long digest = 0L;

        Entry(String string, long l, byte[] byArray) {
            this.name = string;
            this.digest = l;
            this.data = byArray;
        }

        public String name() {
            return this.name;
        }

        public long digest() {
            if (this.digest == 0L) {
                this.digest = Entry._hashcode(digestGen.digest(this.data));
            }
            return this.digest;
        }

        public byte[] data() {
            return this.data;
        }

        static final long _hashcode(byte[] byArray) {
            long l = 0L;
            int n = 0;
            while (n < byArray.length) {
                l += l * 37L + (long)byArray[n];
                ++n;
            }
            return l;
        }
    }
}

