/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.awb.misc;

import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Hashtable;

public final class Debug {
    private static Hashtable h = new Hashtable();
    public static boolean debug = false;

    public static void check() {
        Exception exception;
        if (debug && (exception = (Exception)h.get(Thread.currentThread())) != null) {
            exception.fillInStackTrace();
        }
    }

    public static void check(Object object) {
        if (debug) {
            System.out.println(object);
            Exception exception = (Exception)h.get(Thread.currentThread());
            if (exception != null) {
                exception.fillInStackTrace();
            }
        }
    }

    public static void debug(boolean bl) {
        debug = bl;
    }

    public static void end() {
        if (debug) {
            h.remove(Thread.currentThread());
        }
    }

    public static void list(PrintStream printStream) {
        if (!debug) {
            printStream.println("Debug off");
        }
        Enumeration enumeration = h.keys();
        while (enumeration.hasMoreElements()) {
            Thread thread = (Thread)enumeration.nextElement();
            Exception exception = (Exception)h.get(thread);
            printStream.println("Thread = " + thread);
            printStream.println("Latest StackTrace = ");
            exception.printStackTrace(printStream);
        }
    }

    public static void start() {
        if (debug) {
            h.put(Thread.currentThread(), new Exception());
        }
    }
}

