/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.awb.misc;

import java.util.Enumeration;
import java.util.Hashtable;
import sun.io.CharToByteConverter;

public class Encoding {
    private static Hashtable encodingTable = new Hashtable();
    private String _encoding = null;
    private String _charset = null;

    public Encoding(String string) {
        this._encoding = string;
        this._charset = Encoding.javaEncodingToHTMLCharset(this._encoding);
    }

    public static Encoding getDefault() {
        return new Encoding(CharToByteConverter.getDefault().getCharacterEncoding());
    }

    public String getHTMLCharset() {
        return this._charset;
    }

    public String getJavaEncoding() {
        return this._encoding;
    }

    public static String htmlCharsetToJavaEncoding(String string) {
        Enumeration enumeration = encodingTable.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            String string3 = (String)encodingTable.get(string2);
            if (string3 == null || !string3.equals(string)) continue;
            return string2;
        }
        return null;
    }

    public static String javaEncodingToHTMLCharset(String string) {
        return (String)encodingTable.get(string);
    }

    static {
        encodingTable.put("ISO8859_1", "iso-8859-1");
        encodingTable.put("ISO8859_2", "iso-8859-2");
        encodingTable.put("ISO8859_3", "iso-8859-3");
        encodingTable.put("ISO8859_4", "iso-8859-4");
        encodingTable.put("ISO8859_5", "iso-8859-5");
        encodingTable.put("ISO8859_6", "iso-8859-6");
        encodingTable.put("ISO8859_7", "iso-8859-7");
        encodingTable.put("ISO8859_8", "iso-8859-8");
        encodingTable.put("ISO8859_9", "iso-8859-9");
        encodingTable.put("ISO2022JP", "iso-2022-jp");
        encodingTable.put("ISO2022CN", "iso-2022-cn");
        encodingTable.put("ISO2022KR", "iso-2022-kr");
        encodingTable.put("EUC_JP", "euc-jp");
        encodingTable.put("EUC_KR", "euc-kr");
        encodingTable.put("EUC_CN", "euc-cn");
        encodingTable.put("EUC_TW", "euc-tw");
        encodingTable.put("SJIS", "Shift_JIS");
    }
}

