/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.awb.misc;

import com.ibm.awb.misc.StringList;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.StringTokenizer;

public class FileUtils {
    private static String USER_DIR = null;
    private static String USER_HOME = null;
    private static final String PATH_SEPARATORS;

    static String absolute(File file) {
        if (file.isAbsolute()) {
            return file.getPath();
        }
        return USER_DIR + File.separator + file.getPath();
    }

    public static boolean checkFile(String string, String[] stringArray) {
        String string2 = FileUtils.absolute(new File(string));
        string2 = FileUtils.compact(string2.replace(File.separatorChar, '/') + "/");
        if (stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                if (FileUtils.localizedCheck(string2, stringArray[n])) {
                    return true;
                }
                ++n;
            }
        }
        return false;
    }

    public static String compact(String string) {
        String string2 = "";
        int n = string.indexOf(":");
        if (n < 0) {
            n = string.indexOf("|");
        }
        if (n > 0) {
            string2 = string.substring(0, n + 1);
            string = string.substring(n + 1);
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        StringBuffer stringBuffer2 = new StringBuffer();
        FileUtils.trim(string, stringBuffer2);
        string = string.charAt(0) != '/' && stringBuffer2.charAt(0) == '/' ? stringBuffer2.toString().substring(1) : stringBuffer2.toString();
        return string2 + string;
    }

    private static boolean ensureDir(String string) {
        String string2;
        File file = new File(string);
        if (!file.exists() && ((string2 = file.getParent()) == null || FileUtils.ensureDir(string2))) {
            return FileUtils.makeDir(string);
        }
        return true;
    }

    public static boolean ensureDirectory(String string) {
        File file = new File(string);
        return FileUtils.ensureDir(file.getParent());
    }

    public static boolean ensureFile(String string) {
        File file = new File(string);
        if (file.exists()) {
            if (!file.isFile() || file.isDirectory()) {
                System.out.println('[' + string + " is not a normal file]");
                return false;
            }
            if (!file.canRead()) {
                System.out.println('[' + string + " is not readable]");
                return false;
            }
            if (!file.canWrite()) {
                System.out.println('[' + string + " is not writable. Any modification will not be saved.]");
            }
        } else {
            System.out.println('[' + string + " is not found. Creating new file.]");
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(string);
                ((OutputStream)fileOutputStream).close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                return false;
            }
        }
        return true;
    }

    public static final String getCacheDirectory() {
        return FileUtils.getWorkDirectory() + File.separator + "cache";
    }

    public static final String getLogDirectory() {
        return FileUtils.getWorkDirectory() + File.separator + "logs";
    }

    private static final String getPropertyDirectoryForUser(String string) {
        return FileUtils.getWorkDirectoryForUser(string);
    }

    public static final String getPropertyFilenameForUser(String string, String string2) {
        return FileUtils.getPropertyDirectoryForUser(string) + File.separator + string2 + ".properties";
    }

    public static final String getSecurityDirectory() {
        return FileUtils.getWorkDirectory() + File.separator + "security";
    }

    public static final String getSpoolDirectory() {
        return FileUtils.getWorkDirectory() + File.separator + "spool";
    }

    public static final String getUserDirectory() {
        return USER_DIR;
    }

    public static final String getUserHome() {
        return USER_HOME;
    }

    public static final String getWorkDirectory() {
        String string = USER_HOME + File.separator + ".aglets";
        String string2 = System.getProperty("aglets.work", string);
        return string2;
    }

    public static final String getWorkDirectoryForUser(String string) {
        return FileUtils.getWorkDirectoryForUsers() + File.separator + string;
    }

    private static final String getWorkDirectoryForUsers() {
        return FileUtils.getWorkDirectory() + File.separator + "users";
    }

    public static String[] localize(String[] stringArray) {
        if (stringArray == null) {
            return new String[0];
        }
        String[] stringArray2 = new String[stringArray.length];
        int n = 0;
        while (n < stringArray.length) {
            String string = FileUtils.absolute(new File(stringArray[n]));
            string = FileUtils.compact(string.replace(File.separatorChar, '/'));
            stringArray2[n] = FileUtils.localize(string);
            ++n;
        }
        return stringArray2;
    }

    public static String localize(String string) {
        if (File.separatorChar == '\\') {
            String string2 = string;
            if ("/".equals(string2)) {
                String string3 = USER_DIR;
                String string4 = string3.substring(0, string3.indexOf(58) + 1);
                string2 = string4 + "/";
            }
            return string2.toUpperCase();
        }
        return string;
    }

    public static boolean localizedCheck(String string, String string2) {
        switch (File.separatorChar) {
            case '\\': {
                return string.toUpperCase().startsWith(string2) || string.charAt(0) == '/' && string.length() > 2 && string.charAt(2) == ':' && string.toUpperCase().startsWith('/' + string2);
            }
            case '/': {
                return string.startsWith(string2);
            }
            case ':': {
                return string.startsWith(string2);
            }
        }
        return false;
    }

    private static boolean makeDir(String string) {
        return new File(string).mkdir();
    }

    public static final Enumeration strToPathList(String string) {
        return FileUtils.strToPathList(string, PATH_SEPARATORS);
    }

    public static final Enumeration strToPathList(String string, String string2) {
        if (string == null) {
            return null;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        StringList stringList = new StringList();
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            if (string3 == null || string3.equals("")) continue;
            stringList.addString(string3);
        }
        return stringList;
    }

    public static void trim(String string, StringBuffer stringBuffer) {
        int n = string.indexOf("/..");
        if (n < 0) {
            stringBuffer.append(string);
            return;
        }
        int n2 = string.indexOf("/");
        int n3 = 0;
        int n4 = 0;
        while (n > n2) {
            n4 = n2;
            n2 = string.indexOf("/", n2 + 1);
        }
        stringBuffer.append(string.substring(n3, n4));
        FileUtils.trim(string.substring(n + 3), stringBuffer);
    }

    static {
        USER_DIR = System.getProperty("user.dir");
        USER_HOME = System.getProperty("user.home");
        if (USER_HOME == null || USER_HOME.equals("")) {
            USER_HOME = "/";
        }
        try {
            File file = new File(USER_HOME);
            USER_HOME = file.getCanonicalPath();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        PATH_SEPARATORS = " " + File.pathSeparator;
    }
}

