/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.awb.misc;

import java.util.StringTokenizer;

public class Hexadecimal {
    private String _hex = null;
    private int _num = 0;

    public Hexadecimal(byte by) {
        this._hex = Hexadecimal.valueOf(by);
        this._num = by;
    }

    public Hexadecimal(int n) {
        this._hex = Hexadecimal.valueOf(n);
        this._num = n;
    }

    public Hexadecimal(short s) {
        this._hex = Hexadecimal.valueOf(s);
        this._num = s;
    }

    public byte byteValue() throws NumberFormatException {
        if (this._num > 255 || this._num < 0) {
            throw new NumberFormatException("Out of range for byte.");
        }
        return (byte)this._num;
    }

    public String hexadecimalValue() {
        return this._hex;
    }

    public int intValue() throws NumberFormatException {
        if ((long)this._num > 0xFFFFFFFFL || this._num < 0) {
            throw new NumberFormatException("Out of range for integer.");
        }
        return this._num;
    }

    public static void main(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < stringArray.length) {
            stringBuffer.append(stringArray[n]);
            ++n;
        }
        try {
            byte[] byArray = Hexadecimal.parseSeq(stringBuffer.toString());
            int n2 = 0;
            while (n2 < byArray.length) {
                System.out.print(byArray[n2] + " ");
                ++n2;
            }
            System.out.println("");
        }
        catch (NumberFormatException numberFormatException) {
            System.err.println(numberFormatException.toString());
        }
    }

    public static int octetValue(char c, char c2) throws NumberFormatException {
        int n = Character.digit(c, 16);
        if (n < 0) {
            throw new NumberFormatException(c + " is not a hexadecimal character.");
        }
        int n2 = Character.digit(c2, 16);
        if (n2 < 0) {
            throw new NumberFormatException(c2 + " is not a hexadecimal character.");
        }
        return (n << 4) + n2;
    }

    public static byte parseByte(String string) throws NumberFormatException {
        if (string == null) {
            throw new IllegalArgumentException("Null string in hexadecimal notation.");
        }
        if (string.equals("")) {
            return 0;
        }
        Integer n = Integer.decode("0x" + string);
        int n2 = n;
        if (n2 > 255 || n2 < 0) {
            throw new NumberFormatException("Out of range for byte.");
        }
        return n.byteValue();
    }

    public static int parseInt(String string) throws NumberFormatException {
        if (string == null) {
            throw new IllegalArgumentException("Null string in hexadecimal notation.");
        }
        if (string.equals("")) {
            return 0;
        }
        Integer n = Integer.decode("0x" + string);
        long l = n.longValue();
        if (l > 0xFFFFFFFFL || l < 0L) {
            throw new NumberFormatException("Out of range for integer.");
        }
        return n;
    }

    public static byte[] parseSeq(String string) throws NumberFormatException {
        if (string == null || string.equals("")) {
            return null;
        }
        int n = string.length();
        if (n % 2 != 0) {
            throw new NumberFormatException("Illegal length of string in hexadecimal notation.");
        }
        int n2 = n / 2;
        byte[] byArray = new byte[n2];
        int n3 = 0;
        while (n3 < n2) {
            String string2 = string.substring(n3 * 2, n3 * 2 + 2);
            byArray[n3] = Hexadecimal.parseByte(string2);
            ++n3;
        }
        return byArray;
    }

    public static byte[] parseSeq(String string, String string2) throws NumberFormatException {
        if (string == null || string.equals("")) {
            return null;
        }
        if (string2 == null || string2.equals("")) {
            return Hexadecimal.parseSeq(string);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        int n = stringTokenizer.countTokens();
        byte[] byArray = new byte[n];
        int n2 = 0;
        while (stringTokenizer.hasMoreTokens() && n2 < n) {
            byArray[n2] = Hexadecimal.parseByte(stringTokenizer.nextToken());
            ++n2;
        }
        return byArray;
    }

    public static short parseShort(String string) throws NumberFormatException {
        if (string == null) {
            throw new IllegalArgumentException("Null string in hexadecimal notation.");
        }
        if (string.equals("")) {
            return 0;
        }
        Integer n = Integer.decode("0x" + string);
        int n2 = n;
        if (n2 > 65535 || n2 < 0) {
            throw new NumberFormatException("Out of range for short integer.");
        }
        return n.shortValue();
    }

    public short shortValue() throws NumberFormatException {
        if (this._num > 65535 || this._num < 0) {
            throw new NumberFormatException("Out of range for short integer.");
        }
        return (short)this._num;
    }

    public static String valueOf(byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < byArray.length) {
            stringBuffer.append(Hexadecimal.valueOf(byArray[n], true));
            ++n;
        }
        return stringBuffer.toString();
    }

    public static String valueOf(byte[] byArray, char c) {
        if (byArray == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < byArray.length) {
            if (n > 0) {
                stringBuffer.append(c);
            }
            stringBuffer.append(Hexadecimal.valueOf(byArray[n], true));
            ++n;
        }
        return stringBuffer.toString();
    }

    public static String valueOf(byte by) {
        return Hexadecimal.valueOf(by, true);
    }

    public static String valueOf(byte by, boolean bl) {
        String string = Integer.toHexString(by);
        if (bl) {
            string = "00" + string;
            int n = string.length();
            string = string.substring(n - 2, n);
        }
        return string;
    }

    public static String valueOf(int n) {
        return Hexadecimal.valueOf(n, true);
    }

    public static String valueOf(int n, boolean bl) {
        String string = Integer.toHexString(n);
        if (bl) {
            string = "00000000" + string;
            int n2 = string.length();
            string = string.substring(n2 - 8, n2);
        }
        return string;
    }

    public static String valueOf(long l) {
        return Hexadecimal.valueOf(l, true);
    }

    public static String valueOf(long l, boolean bl) {
        String string = Long.toHexString(l);
        if (bl) {
            string = "0000000000000000" + string;
            int n = string.length();
            string = string.substring(n - 16, n);
        }
        return string;
    }

    public static String valueOf(short s) {
        return Hexadecimal.valueOf(s, true);
    }

    public static String valueOf(short s, boolean bl) {
        String string = Integer.toHexString(s);
        if (bl) {
            string = "0000" + string;
            int n = string.length();
            string = string.substring(n - 4, n);
        }
        return string;
    }
}

