/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.awb.misc;

import com.ibm.awb.misc.Archive;
import com.ibm.awb.misc.Manifest;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class JarArchive
extends Archive {
    private static boolean verbose = false;
    Manifest manifest = null;
    byte[] contents = null;
    boolean allowPut = false;

    public JarArchive(InputStream inputStream) throws IOException {
        int n;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[512];
        while ((n = inputStream.read(byArray, 0, 512)) >= 0) {
            byteArrayOutputStream.write(byArray, 0, n);
        }
        this.contents = byteArrayOutputStream.toByteArray();
        this.update();
    }

    public JarArchive(String string) throws IOException {
        this(new FileInputStream(string));
    }

    private static void debug(String string) {
        if (verbose) {
            System.out.println(string);
        }
    }

    public Archive getArchiveFor(String string) {
        return null;
    }

    public Manifest getManifest() {
        return this.manifest;
    }

    public synchronized byte[] getResourceAsByteArray(String string) {
        byte[] byArray = this.getResourceInCache(string);
        if (byArray == null) {
            byArray = this.putResourceFromJarArchive(string);
        }
        return byArray;
    }

    public synchronized InputStream getResourceAsStream(String string) {
        byte[] byArray = this.getResourceInCache(string);
        if (byArray == null) {
            byArray = this.putResourceFromJarArchive(string);
        }
        if (byArray != null) {
            return new ByteArrayInputStream(byArray);
        }
        return null;
    }

    public boolean isAglet(String string) {
        return this.manifest != null && this.manifest.isAglet(string);
    }

    synchronized void putResoruce(String string, byte[] byArray) {
        if (this.allowPut) {
            super.putResource(string, byArray);
        }
    }

    private byte[] putResourceFromJarArchive(String string) {
        return null;
    }

    private void readFully(InputStream inputStream, byte[] byArray) throws IOException {
        int n = 0;
        while (n < byArray.length) {
            n += inputStream.read(byArray, n, byArray.length - n);
        }
    }

    public void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
    }

    private void update() throws IOException {
        this.allowPut = true;
        ZipInputStream zipInputStream = new ZipInputStream(new ByteArrayInputStream(this.contents));
        ZipEntry zipEntry = null;
        ByteArrayOutputStream byteArrayOutputStream = null;
        byte[] byArray = null;
        int n = 0;
        while ((zipEntry = zipInputStream.getNextEntry()) != null) {
            byte[] byArray2;
            String string = zipEntry.getName();
            JarArchive.debug("[" + n++ + "] " + string);
            if (sun.tools.jar.Manifest.isManifestName((String)string)) {
                this.manifest = new Manifest(zipInputStream);
                continue;
            }
            if (string.toUpperCase().startsWith("MANIFEST/") && string.toUpperCase().endsWith(".SF")) continue;
            long l = zipEntry.getSize();
            if (l < 0L) {
                int n2;
                if (byteArrayOutputStream == null) {
                    byArray = new byte[512];
                    byteArrayOutputStream = new ByteArrayOutputStream();
                }
                byteArrayOutputStream.reset();
                while ((n2 = zipInputStream.read(byArray, 0, 512)) > 0) {
                    byteArrayOutputStream.write(byArray, 0, n2);
                }
                byArray2 = byteArrayOutputStream.toByteArray();
            } else {
                byArray2 = new byte[(int)l];
                this.readFully(zipInputStream, byArray2);
            }
            this.putResource(zipEntry.getName(), byArray2);
        }
        this.allowPut = false;
    }
}

