/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.awb.misc;

public class PortPattern {
    private static final int DEFAULT_PORT_NO = -1;
    private static final String DEFAULT_PORT = String.valueOf(-1);
    private static final String GREATER_THAN_OR_EQUAL = ">=";
    private static final String LESS_THAN_OR_EQUAL = "<=";
    private static final String GREATER_THAN = ">";
    private static final String LESS_THAN = "<";
    private static final String BETWEEN_PORTS = "-";
    private static final String ANYPORT = "*";
    private static final int TYPE_NOTYPE = 0;
    private static final int TYPE_DEFAULT_PORT = 1;
    private static final int TYPE_A_PORT = 2;
    private static final int TYPE_ANYPORT = 3;
    private static final int TYPE_GREATER_THAN_OR_EQUAL = 4;
    private static final int TYPE_GREATER_THAN = 5;
    private static final int TYPE_LESS_THAN_OR_EQUAL = 6;
    private static final int TYPE_LESS_THAN = 7;
    private static final int TYPE_BETWEEN = 8;
    private static final int NO_PORT = -1;
    private String _pattern = null;
    private int _type = 0;
    private int _portFrom = -1;
    private int _portTo = -1;

    public PortPattern() {
        this(null);
    }

    public PortPattern(int n) {
        this._pattern = String.valueOf(n);
        if (n == -1) {
            this._type = 1;
        } else {
            this._type = 2;
            this._portFrom = n;
            if (!PortPattern.isValid(this._portFrom)) {
                this._type = 0;
                this._portFrom = -1;
                throw PortPattern.getException(this._pattern + ". Port number should be positive.");
            }
        }
    }

    public PortPattern(String string) {
        if (string == null) {
            this._type = 1;
            return;
        }
        this._pattern = string.trim();
        int n = this._pattern.indexOf(BETWEEN_PORTS);
        String string2 = null;
        String string3 = null;
        if (n > 0) {
            string2 = this._pattern.substring(0, n);
            string3 = this._pattern.substring(n + 1);
        }
        this._type = this._pattern.equals(DEFAULT_PORT) ? 1 : (this._pattern.equals(ANYPORT) ? 3 : (this._pattern.startsWith(GREATER_THAN_OR_EQUAL) ? 4 : (this._pattern.startsWith(LESS_THAN_OR_EQUAL) ? 6 : (this._pattern.startsWith(GREATER_THAN) ? 5 : (this._pattern.startsWith(LESS_THAN) ? 7 : (n > 0 ? 8 : 2))))));
        String string4 = null;
        switch (this._type) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                try {
                    this._portFrom = Integer.parseInt(this._pattern);
                    this._portTo = -1;
                }
                catch (NumberFormatException numberFormatException) {
                    this._type = 0;
                    this._portFrom = -1;
                    throw PortPattern.getException(this._pattern);
                }
                if (PortPattern.isValid(this._portFrom)) break;
                this._type = 0;
                this._portFrom = -1;
                throw PortPattern.getException(this._pattern + ". Port number should be positive.");
            }
            case 3: {
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                switch (this._type) {
                    case 4: 
                    case 6: {
                        string4 = this._pattern.substring(2).trim();
                        break;
                    }
                    case 5: 
                    case 7: {
                        string4 = this._pattern.substring(1).trim();
                    }
                }
                try {
                    this._portFrom = Integer.parseInt(string4);
                    this._portTo = -1;
                }
                catch (NumberFormatException numberFormatException) {
                    this._type = 0;
                    this._portFrom = -1;
                    this._portTo = -1;
                }
                if (PortPattern.isValid(this._portFrom)) break;
                this._type = 0;
                this._portFrom = -1;
                throw PortPattern.getException(string4 + ". Port number should be positive.");
            }
            case 8: {
                if (string2 == null || string2.equals("") || string3 == null || string3.equals("")) {
                    throw PortPattern.getException(this._pattern);
                }
                try {
                    this._portFrom = Integer.parseInt(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    this._type = 0;
                    this._portFrom = -1;
                    throw PortPattern.getException(string2);
                }
                try {
                    this._portTo = Integer.parseInt(string3);
                }
                catch (NumberFormatException numberFormatException) {
                    this._type = 0;
                    this._portTo = -1;
                    throw PortPattern.getException(string3);
                }
                if (!PortPattern.isValid(this._portFrom)) {
                    this._type = 0;
                    this._portFrom = -1;
                    throw PortPattern.getException(string2 + ". Port number should be positive.");
                }
                if (PortPattern.isValid(this._portTo)) break;
                this._type = 0;
                this._portTo = -1;
                throw PortPattern.getException(string3 + ". Port number should be positive.");
            }
        }
    }

    public boolean equals(PortPattern portPattern) {
        if (portPattern == null) {
            return false;
        }
        if (portPattern._type != this._type) {
            return false;
        }
        boolean bl = false;
        switch (this._type) {
            case 0: {
                bl = false;
                break;
            }
            case 1: {
                bl = true;
                break;
            }
            case 2: {
                bl = portPattern._portFrom == this._portFrom;
                break;
            }
            case 3: {
                bl = true;
                break;
            }
            case 4: {
                bl = portPattern._portFrom == this._portFrom;
                break;
            }
            case 5: {
                bl = portPattern._portFrom == this._portFrom;
                break;
            }
            case 6: {
                bl = portPattern._portFrom == this._portFrom;
                break;
            }
            case 7: {
                bl = portPattern._portFrom == this._portFrom;
                break;
            }
            case 8: {
                bl = portPattern._portFrom == this._portFrom && portPattern._portTo == this._portTo;
            }
        }
        return bl;
    }

    public boolean equals(Object object) {
        if (object instanceof PortPattern) {
            PortPattern portPattern = (PortPattern)object;
            return this.equals(portPattern);
        }
        return false;
    }

    private static IllegalArgumentException getException(String string) {
        return new IllegalArgumentException("Illegal port number : " + string);
    }

    public int getFromPort() {
        return this._portFrom;
    }

    public int getToPort() {
        return this._portTo;
    }

    public boolean isMatch(int n) {
        boolean bl = false;
        switch (this._type) {
            case 0: {
                bl = false;
                break;
            }
            case 1: {
                bl = n == -1;
                break;
            }
            case 2: {
                bl = this._portFrom == n;
                break;
            }
            case 3: {
                bl = true;
                break;
            }
            case 4: {
                bl = n >= this._portFrom;
                break;
            }
            case 5: {
                bl = n > this._portFrom;
                break;
            }
            case 6: {
                bl = n <= this._portFrom;
                break;
            }
            case 7: {
                bl = n < this._portFrom;
                break;
            }
            case 8: {
                bl = this._portFrom <= n && n <= this._portTo;
            }
        }
        return bl;
    }

    public boolean isSinglePort() {
        return this._type == 1 || this._type == 2;
    }

    private static boolean isValid(int n) {
        return n >= 0;
    }

    public static void main(String[] stringArray) {
        PortPattern portPattern = null;
        portPattern = stringArray.length == 0 ? new PortPattern() : new PortPattern(stringArray[0]);
        if (portPattern != null) {
            System.out.print(portPattern.toString());
        }
    }

    public String toString() {
        String string = null;
        switch (this._type) {
            case 0: {
                break;
            }
            case 1: {
                string = DEFAULT_PORT;
                break;
            }
            case 2: {
                string = String.valueOf(this._portFrom);
                break;
            }
            case 3: {
                string = ANYPORT;
                break;
            }
            case 4: {
                string = GREATER_THAN_OR_EQUAL + String.valueOf(this._portFrom);
                break;
            }
            case 5: {
                string = GREATER_THAN + String.valueOf(this._portFrom);
                break;
            }
            case 6: {
                string = LESS_THAN_OR_EQUAL + String.valueOf(this._portFrom);
                break;
            }
            case 7: {
                string = LESS_THAN_OR_EQUAL + String.valueOf(this._portFrom);
                break;
            }
            case 8: {
                string = String.valueOf(this._portFrom) + BETWEEN_PORTS + String.valueOf(this._portTo);
            }
        }
        return string;
    }
}

