/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.awb.misc;

import com.ibm.awb.misc.FileUtils;
import java.awt.Color;
import java.awt.Font;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

public class Resource {
    private static Hashtable resourceTable = new Hashtable();
    private static Properties options = null;
    private static final String PROTOCOL_FILE = "file";
    private Properties option = null;
    private Properties defaults = null;
    private Properties persistent = null;
    private URL _saveURL = null;

    private Resource() {
        try {
            this.defaults = System.getProperties();
            this.persistent = new Properties(this.defaults);
            System.setProperties(this.persistent);
        }
        catch (SecurityException securityException) {
            this.defaults = new Properties();
            this.persistent = new Properties(this.defaults);
        }
        this.option = new Properties(this.persistent);
    }

    private Resource(URL uRL, Properties properties) {
        if (properties == null) {
            properties = new Properties();
        }
        this.defaults = properties;
        this.persistent = new Properties(properties);
        this.option = new Properties(this.persistent);
        if (uRL == null) {
            return;
        }
        if (!this.load(uRL)) {
            System.out.println("[Could not load resource from " + uRL + "]");
        }
    }

    public void appendResource(String string, String string2) {
        if (string2 == null) {
            return;
        }
        String string3 = this.getString(string, "");
        ((Hashtable)this.persistent).put(string, string3 + ' ' + string2);
    }

    public static synchronized Resource createResource(String string, String string2, Properties properties) throws MalformedURLException {
        URL uRL = string2 == null ? null : new URL(PROTOCOL_FILE, "", string2);
        return Resource.createResource(string, uRL, properties);
    }

    private static synchronized Resource createResource(String string, URL uRL, Properties properties) {
        if (resourceTable.contains(string)) {
            throw new SecurityException("cannot re-create existing resource");
        }
        Resource resource = new Resource(uRL, properties);
        resourceTable.put(string, resource);
        return resource;
    }

    public static synchronized Resource createResource(String string, Properties properties) {
        return Resource.createResource(string, (URL)null, properties);
    }

    public boolean getBoolean(String string, boolean bl) {
        String string2 = this.option.getProperty(string);
        return string2 == null ? bl : string2.equalsIgnoreCase("true");
    }

    public Color getColor(String string, Color color) {
        String string2 = this.option.getProperty(string);
        if (string2 == null) {
            return color;
        }
        try {
            return new Color(Integer.parseInt(string2));
        }
        catch (NumberFormatException numberFormatException) {
            return color;
        }
    }

    public Font getFont(String string, Font font) {
        String string2 = this.option.getProperty(string);
        if (string2 == null) {
            return font;
        }
        String string3 = "Dialog";
        int n = 12;
        int n2 = 0;
        int n3 = string2.indexOf(45);
        if (n3 >= 0) {
            string3 = string2.substring(0, n3);
            if ((n3 = (string2 = string2.substring(n3 + 1)).indexOf(45)) >= 0) {
                if (string2.startsWith("plain-")) {
                    n2 = 0;
                } else if (string2.startsWith("bold-")) {
                    n2 = 1;
                } else if (string2.startsWith("italic-")) {
                    n2 = 2;
                } else if (string2.startsWith("bolditalic-")) {
                    n2 = 3;
                }
                string2 = string2.substring(n3 + 1);
            }
            try {
                n = Integer.valueOf(string2);
            }
            catch (NumberFormatException numberFormatException) {
                return font;
            }
        }
        return new Font(string3, n2, n);
    }

    public int getInteger(String string, int n) {
        String string2 = this.option.getProperty(string);
        return string2 == null ? n : Integer.parseInt(string2);
    }

    public String[] getPersistentResourcesStartsWith(String string) {
        Object object;
        Enumeration enumeration = ((Hashtable)this.persistent).keys();
        Vector<Object[]> vector = new Vector<Object[]>();
        while (enumeration.hasMoreElements()) {
            object = (String)enumeration.nextElement();
            if (!object.startsWith(string)) continue;
            vector.addElement((Object[])object);
        }
        object = new String[vector.size()];
        vector.copyInto((Object[])object);
        return object;
    }

    public static Resource getResourceFor(String string) {
        return (Resource)resourceTable.get(string);
    }

    public String getString(String string) {
        return this.option.getProperty(string);
    }

    public String getString(String string, String string2) {
        return this.option.getProperty(string, string2);
    }

    public String[] getStringArray(String string, String string2) {
        String string3 = this.getString(string, null);
        if (string3 == null) {
            return new String[0];
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string3, string2, false);
        String[] stringArray = new String[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            stringArray[n++] = stringTokenizer.nextToken();
        }
        return stringArray;
    }

    private static void getSystemProperties() {
        if (options == null) {
            try {
                options = System.getProperties();
            }
            catch (SecurityException securityException) {
                options = new Properties();
            }
        }
    }

    public URL getURL(String string, URL uRL) {
        String string2 = this.option.getProperty(string);
        try {
            return string2 == null ? uRL : new URL(string2);
        }
        catch (MalformedURLException malformedURLException) {
            System.err.println("[fail to convert '" + string2 + "' to URL]");
            return uRL;
        }
    }

    public void importOptionProperties(String string) {
        Resource.getSystemProperties();
        Enumeration<?> enumeration = options.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (!string2.startsWith(string)) continue;
            this.setOptionResource(string2, options.getProperty(string2));
            ((Hashtable)options).remove(string2);
        }
    }

    public void list(PrintStream printStream) {
        this.option.list(printStream);
    }

    public boolean load(URL uRL) {
        if (PROTOCOL_FILE.equalsIgnoreCase(uRL.getProtocol())) {
            if (!FileUtils.ensureDirectory(uRL.getFile())) {
                System.out.println("[Could not create directory " + uRL + "]");
                return false;
            }
            if (!FileUtils.ensureFile(uRL.getFile())) {
                System.out.println("[Could not create file " + uRL + "]");
                return false;
            }
        }
        this._saveURL = uRL;
        try {
            InputStream inputStream = uRL.openStream();
            this.persistent.load(inputStream);
            inputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
        return true;
    }

    public void mergeResource(String string, String string2) {
        if (string2 == null) {
            return;
        }
        String string3 = this.getString(string, "");
        if (string3.indexOf(string2) >= 0) {
            return;
        }
        this.appendResource(string, string2);
    }

    public void removeOptionResource(String string) {
        ((Hashtable)this.option).remove(string);
    }

    public void removePersistentResourcesStartsWith(String string) {
        Enumeration<Object> enumeration = ((Hashtable)this.persistent).keys();
        Vector<String> vector = new Vector<String>();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (!string2.startsWith(string)) continue;
            vector.addElement(string2);
        }
        enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            ((Hashtable)this.persistent).remove(enumeration.nextElement());
        }
    }

    public void removeResource(String string) {
        ((Hashtable)this.persistent).remove(string);
    }

    public boolean save(String string) {
        return this.save(this._saveURL, string);
    }

    public boolean save(URL uRL, String string) {
        if (uRL == null || !PROTOCOL_FILE.equalsIgnoreCase(uRL.getProtocol())) {
            return false;
        }
        try {
            System.out.println("[saving properties into " + uRL + " ]");
            File file = new File(uRL.getFile());
            if (!file.exists() || file.isFile() && file.canWrite()) {
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                this.persistent.store(fileOutputStream, string);
                fileOutputStream.close();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return false;
        }
        return true;
    }

    public void setDefaultResource(String string, String string2) {
        if (((Hashtable)this.defaults).get(string) != null) {
            Exception exception = new Exception("Cannot override default properties:" + string + " = " + string2 + " , current value = " + ((Hashtable)this.defaults).get(string));
            exception.printStackTrace();
            return;
        }
        ((Hashtable)this.defaults).put(string, string2);
    }

    public void setDefaultResources(String[][] stringArray) {
        int n = 0;
        while (n < stringArray.length) {
            this.setDefaultResource(stringArray[n][0], stringArray[n][1]);
            ++n;
        }
    }

    public void setOptionResource(String string, String string2) {
        ((Hashtable)this.option).put(string, string2);
    }

    public void setResource(String string, String string2) {
        ((Hashtable)this.persistent).put(string, string2);
    }

    public static String toString(Color color) {
        return String.valueOf(color.getRGB());
    }

    public static String toString(Font font) {
        String string = null;
        string = font.isBold() ? (font.isItalic() ? "bolditalic" : "bold") : (font.isItalic() ? "italic" : "plain");
        return font.getName() + '-' + string + '-' + font.getSize();
    }

    static {
        resourceTable.put("system", new Resource());
    }
}

