/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.awb.misc;

import com.ibm.awb.misc.Encoding;
import com.ibm.awb.misc.Hexadecimal;
import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import java.util.BitSet;

public class URIEncoder {
    private static final char CHAR_PERCENT = '%';
    private static final char CHAR_SPACE = ' ';
    private static final char CHAR_PLUS = '+';
    private static final char CHAR_MINUS = '-';
    private static final char CHAR_UNDERSCORE = '_';
    private static final char CHAR_DOT = '.';
    private static final char CHAR_ASTERISK = '*';
    private static final char CHAR_A_LOWERCASE = 'a';
    private static final char CHAR_A_UPPERCASE = 'A';
    private static final char CHAR_Z_LOWERCASE = 'z';
    private static final char CHAR_Z_UPPERCASE = 'Z';
    private static final char CHAR_NUMBER_0 = '0';
    private static final char CHAR_NUMBER_9 = '9';
    private static final int NUM_CHAR = 256;
    private static BitSet dontNeedEncoding = new BitSet(256);

    private URIEncoder() {
    }

    public static String decode(String string) {
        if (string == null) {
            return null;
        }
        String string2 = Encoding.getDefault().getJavaEncoding();
        if (string2 == null) {
            return null;
        }
        String string3 = null;
        try {
            string3 = URIEncoder.decode(string, string2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            System.err.println(unsupportedEncodingException.toString());
            return null;
        }
        return string3;
    }

    public static String decode(String string, String string2) throws UnsupportedEncodingException {
        if (string == null) {
            return null;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            ++n2;
            if (c == '+') {
                byteArrayOutputStream.write(32);
                continue;
            }
            if (c == '%' && n2 < n) {
                char c2 = string.charAt(n2);
                if (++n2 >= n) {
                    byteArrayOutputStream.write((byte)c);
                    byteArrayOutputStream.write((byte)c2);
                    continue;
                }
                if (c2 == '%') {
                    byteArrayOutputStream.write((byte)c2);
                    continue;
                }
                char c3 = string.charAt(n2);
                ++n2;
                try {
                    byteArrayOutputStream.write((byte)Hexadecimal.octetValue(c2, c3));
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IllegalArgumentException(numberFormatException.toString());
                }
            }
            byteArrayOutputStream.write((byte)c);
        }
        if (string2 == null || string2.equals("")) {
            return byteArrayOutputStream.toString();
        }
        return byteArrayOutputStream.toString(string2);
    }

    public static String encode(byte[] byArray) {
        if (byArray == null || byArray.length == 0) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < byArray.length) {
            int n2 = byArray[n];
            int n3 = n2;
            if (0 <= n3 && n3 < 256 && dontNeedEncoding.get(n3)) {
                if (n3 == 32) {
                    n3 = 43;
                }
                stringBuffer.append((char)n3);
            } else {
                stringBuffer.append('%');
                stringBuffer.append(Hexadecimal.valueOf((byte)n2).toUpperCase());
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public static String encode(String string) {
        if (string == null) {
            return null;
        }
        String string2 = Encoding.getDefault().getJavaEncoding();
        if (string2 == null) {
            return null;
        }
        String string3 = null;
        try {
            string3 = URIEncoder.encode(string, string2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            System.err.println(unsupportedEncodingException.toString());
            return null;
        }
        return string3;
    }

    public static String encode(String string, String string2) throws UnsupportedEncodingException {
        if (string == null) {
            return null;
        }
        return URIEncoder.encode(string.getBytes(string2));
    }

    public static void main(String[] stringArray) throws Exception {
        int n = 0;
        while (n < stringArray.length) {
            String string = stringArray[n];
            System.out.println("encode(" + string + ")=" + URIEncoder.encode(string));
            System.out.println("decode(" + string + ")=" + URIEncoder.decode(string));
            ++n;
        }
    }

    static {
        int n = 97;
        while (n <= 122) {
            dontNeedEncoding.set(n);
            ++n;
        }
        n = 65;
        while (n <= 90) {
            dontNeedEncoding.set(n);
            ++n;
        }
        n = 48;
        while (n <= 57) {
            dontNeedEncoding.set(n);
            ++n;
        }
        dontNeedEncoding.set(32);
        dontNeedEncoding.set(45);
        dontNeedEncoding.set(95);
        dontNeedEncoding.set(46);
        dontNeedEncoding.set(42);
    }
}

