/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.awb.misc;

import com.ibm.awb.misc.MalformedURIPatternException;
import com.ibm.awb.misc.PortPattern;
import java.io.File;
import java.io.IOException;
import java.net.URL;

public class URIPattern {
    private static final char CHAR_COLON = ':';
    private static final char PROTOCOL_TERMINATOR = ':';
    private static final char CHAR_SLASH = '/';
    private static final String STRING_SLASH = String.valueOf('/');
    private static final char DIRECTORY_DELIMITER = '/';
    private static final String HOSTNAME_LEADER = STRING_SLASH + STRING_SLASH;
    private static final char PORT_LEADER = ':';
    private static final String FILE_LEADER = STRING_SLASH;
    private static final char CHAR_ASTERISK = '*';
    private static final char CHAR_HYPHEN = '-';
    private static final char CHAR_DOT = '.';
    private static final String STRING_ASTERISK = String.valueOf('*');
    private static final String STRING_HYPHEN = String.valueOf('-');
    private static final String STRING_DOT = String.valueOf('.');
    private static final String WILDCARD_HOST = STRING_ASTERISK;
    private static final String WILDCARD_PORT = STRING_ASTERISK;
    private static final String WILDCARD_PROTOCOL = STRING_ASTERISK;
    private static final int USE_DEFAULT_PORT = -1;
    private static final String WILDCARD_ANYDIR = STRING_HYPHEN;
    private static final String WILDCARD_SUBDIR = STRING_ASTERISK;
    private static final String DOMAIN_DELIMITER = STRING_DOT;
    private static final String GREATER_THAN_OR_EQUAL = ">=";
    private static final String LESS_THAN_OR_EQUAL = "<=";
    private static final String GREATER_THAN = ">";
    private static final String LESS_THAN = "<";
    private static final String BETWEEN_PORTS = "-";
    private static final String PROTOCOL_FILE = "file";
    private String _pattern = null;
    private String _protocol = null;
    private String _host = null;
    private String _port = null;
    private PortPattern _ppat = null;
    private String _file = null;

    public URIPattern(String string) throws MalformedURIPatternException {
        this._pattern = this.expandPropertyRef(string);
        int n = string.indexOf(58);
        if (n == -1) {
            throw new MalformedURIPatternException("Protocol does not specified : \"" + string + "\".");
        }
        this._protocol = string.substring(0, n);
        String string2 = string.substring(n + 1);
        if (PROTOCOL_FILE.equalsIgnoreCase(this._protocol)) {
            this._host = "";
            this._port = null;
            this._file = string2;
        } else if (string2.startsWith(HOSTNAME_LEADER)) {
            String string3 = string2.substring(2);
            String string4 = null;
            int n2 = string3.indexOf(FILE_LEADER);
            if (n2 == -1) {
                string4 = string3;
                this._file = "";
            } else {
                string4 = string3.substring(0, n2);
                this._file = string3.substring(n2);
            }
            int n3 = string4.indexOf(58);
            if (n3 == -1) {
                this._host = string4;
                this._port = null;
            } else {
                this._host = string4.substring(0, n3);
                this._port = string4.substring(n3 + 1);
            }
        } else if (string2.startsWith(FILE_LEADER)) {
            this._host = "";
            this._port = null;
            this._file = string2;
        } else {
            throw new MalformedURIPatternException("Hostname does not specified : \"" + string + "\".");
        }
        if (this._file == null || this._file.equals("")) {
            this._file = FILE_LEADER;
        }
        try {
            this._ppat = new PortPattern(this._port);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new MalformedURIPatternException(illegalArgumentException.toString());
        }
    }

    public URIPattern(URL uRL) throws MalformedURIPatternException {
        this._pattern = uRL.toString();
        this._protocol = uRL.getProtocol();
        this._host = uRL.getHost();
        int n = uRL.getPort();
        this._port = String.valueOf(n);
        try {
            this._ppat = new PortPattern(n);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new MalformedURIPatternException(illegalArgumentException.toString());
        }
        this._file = uRL.getFile();
    }

    public static final String canonicalFilename(String string) {
        Object object;
        if (string == null) {
            return null;
        }
        int n = string.length();
        if (n < 1) {
            return null;
        }
        String string2 = string;
        boolean bl = false;
        String string3 = string.substring(n - 1);
        if (n > 1 && (((String)(object = string.substring(n - 2, n - 1))).equals(STRING_SLASH) || ((String)object).equals(File.separator)) && (string3.equals(WILDCARD_ANYDIR) || string3.equals(WILDCARD_SUBDIR))) {
            bl = true;
            string2 = string.substring(0, n - 1);
        }
        if ((object = new File(string2)) == null) {
            return null;
        }
        String string4 = ((File)object).getPath();
        try {
            string4 = ((File)object).getCanonicalPath();
        }
        catch (IOException iOException) {
            return null;
        }
        if (bl) {
            if (!string4.endsWith(File.separator)) {
                string4 = string4 + File.separator;
            }
            string4 = string4 + string3;
        }
        return string4;
    }

    public boolean equals(URIPattern uRIPattern) {
        return this.equals(uRIPattern._protocol, uRIPattern._host, uRIPattern._ppat, uRIPattern._file);
    }

    public boolean equals(Object object) {
        if (object instanceof URIPattern) {
            URIPattern uRIPattern = (URIPattern)object;
            return this.equals(uRIPattern);
        }
        return false;
    }

    public boolean equals(String string, String string2, PortPattern portPattern, String string3) {
        if (string == null || this._protocol == null) {
            return false;
        }
        if (!string.equals(this._protocol)) {
            return false;
        }
        if (string.equals(PROTOCOL_FILE)) {
            if (string3 == null || this._file == null) {
                return false;
            }
            return string3.equals(this._file);
        }
        if (string2 == null || this._host == null) {
            return false;
        }
        if (!string2.equals(this._host)) {
            return false;
        }
        if (portPattern != null && !portPattern.equals(this._ppat)) {
            return false;
        }
        return string3 == null || string3.equals(this._file);
    }

    private String expandPropertyRef(String string) {
        int n = string.indexOf("${");
        if (n < 0) {
            return string;
        }
        int n2 = string.indexOf("}");
        String string2 = string.substring(n + 2, n2);
        String string3 = System.getProperty(string2);
        return this.expandPropertyRef(string.substring(0, n) + string3 + string.substring(n2 + 1));
    }

    public String getFile() {
        return this._file;
    }

    public String getHost() {
        return this._host;
    }

    public String getPattern() {
        return this._pattern;
    }

    public String getPort() {
        return this._port;
    }

    public PortPattern getPortPattern() {
        return this._ppat;
    }

    public String getProtocol() {
        return this._protocol;
    }

    public boolean isMatch(URL uRL) {
        if (uRL == null) {
            return false;
        }
        String string = uRL.getProtocol();
        if (!URIPattern.isMatchProtocol(this._protocol, string)) {
            return false;
        }
        String string2 = uRL.getFile();
        if (string.equalsIgnoreCase(PROTOCOL_FILE)) {
            String string3 = URIPattern.canonicalFilename(this._file);
            String string4 = URIPattern.canonicalFilename(string2);
            if (string3 == null || string4 == null) {
                return false;
            }
            return URIPattern.isMatchFile(string3, string4);
        }
        String string5 = uRL.getHost();
        if (this._host == null || string5 == null) {
            return false;
        }
        if (!URIPattern.isMatchHost(this._host, string5)) {
            return false;
        }
        int n = uRL.getPort();
        if (!URIPattern.isMatchPort(this._ppat, n)) {
            return false;
        }
        return URIPattern.isMatchFile(this._file, string2, STRING_SLASH);
    }

    static final boolean isMatchFile(String string, String string2) {
        return URIPattern.isMatchFile(string, string2, File.separator);
    }

    static final boolean isMatchFile(String string, String string2, String string3) {
        if (string == null || string2 == null || string3 == null) {
            return false;
        }
        if (string.equals(string3)) {
            return true;
        }
        String string4 = string3 + WILDCARD_ANYDIR;
        if (string.equals(string4)) {
            return true;
        }
        String string5 = string3 + WILDCARD_SUBDIR;
        if (string.endsWith(string4)) {
            String string6 = string.substring(0, string.length() - 1);
            String string7 = string2;
            int n = string2.lastIndexOf(string3);
            if (n >= 0) {
                string7 = string2.substring(0, n + 1);
            }
            return string7.startsWith(string6);
        }
        if (string.endsWith(string5)) {
            String string8 = string.substring(0, string.length() - 1);
            String string9 = string2;
            int n = string2.lastIndexOf(string3);
            if (n >= 0) {
                string9 = string2.substring(0, n + 1);
            }
            return string9.equals(string8);
        }
        return string2.equals(string);
    }

    private static final boolean isMatchHost(String string, String string2) {
        if (string.equals(WILDCARD_HOST)) {
            return true;
        }
        String string3 = WILDCARD_HOST + DOMAIN_DELIMITER;
        if (string.startsWith(string3)) {
            String string4 = string.substring(2);
            return string2.endsWith(string4);
        }
        return string2.equalsIgnoreCase(string);
    }

    static final boolean isMatchPort(PortPattern portPattern, int n) {
        if (portPattern == null) {
            return false;
        }
        return portPattern.isMatch(n);
    }

    private static final boolean isMatchProtocol(String string, String string2) {
        if (string.equals(WILDCARD_PROTOCOL)) {
            return true;
        }
        return string.equalsIgnoreCase(string2);
    }

    public static void main(String[] stringArray) {
        URIPattern uRIPattern = null;
        int n = 0;
        while (n < stringArray.length) {
            try {
                uRIPattern = new URIPattern(stringArray[n]);
            }
            catch (MalformedURIPatternException malformedURIPatternException) {
                malformedURIPatternException.printStackTrace();
            }
            System.out.println(uRIPattern.toString());
            ++n;
        }
    }

    public String toString() {
        String string = HOSTNAME_LEADER + this._host;
        if (this._port != null) {
            string = string + ':' + this._port;
        }
        return this._protocol + ':' + string + this._file;
    }
}

