/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.awb.weakref;

import com.ibm.awb.weakref.Ref;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Hashtable;

public class VirtualRef
implements Serializable {
    private Ref _ref;
    static Hashtable cache = new Hashtable();

    public VirtualRef(Ref ref) {
        this._ref = ref;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof VirtualRef) {
            return this.getRef().equals(object);
        }
        return this._ref == object;
    }

    protected final synchronized void finalize() {
        if (this._ref != null) {
            this._ref.unreferenced();
            this._ref = null;
        }
    }

    public final Ref getCurrentRef() {
        return this._ref;
    }

    public final Ref getRef() {
        return this._ref.getRef(this);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        String string = (String)objectInputStream.readObject();
        Ref ref = (Ref)cache.get(string);
        if (ref == null) {
            try {
                ref = (Ref)Class.forName(string).newInstance();
                cache.put(string, ref);
            }
            catch (Error error) {
                System.out.println("Error:" + string);
                throw error;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return;
            }
        }
        ref.setRef(this, objectInputStream);
    }

    public final synchronized void setRef(Ref ref) {
        if (this._ref == ref) {
            System.out.println("Don't set the same reference!");
            Thread.dumpStack();
        }
        if (this._ref != null) {
            this._ref.unreferenced();
        }
        this._ref = ref;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (this._ref == null) {
            this._ref = new NullRef();
        }
        objectOutputStream.writeObject(this._ref.getRefClassName());
        this._ref.writeInfo(objectOutputStream);
    }

    public class NullRef
    implements Ref {
        static /* synthetic */ Class class$com$ibm$awb$weakref$VirtualRef$NullRef;

        public void referenced() {
        }

        public void unreferenced() {
        }

        public String getRefClassName() {
            return (class$com$ibm$awb$weakref$VirtualRef$NullRef == null ? (class$com$ibm$awb$weakref$VirtualRef$NullRef = NullRef.class$("com.ibm.awb.weakref.VirtualRef$NullRef")) : class$com$ibm$awb$weakref$VirtualRef$NullRef).getName();
        }

        public Ref getRef(VirtualRef virtualRef) {
            return null;
        }

        public void writeInfo(ObjectOutputStream objectOutputStream) {
        }

        public void setRef(VirtualRef virtualRef, ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }
}

