/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.awb.weakref;

import com.ibm.awb.weakref.Ref;
import com.ibm.awb.weakref.VirtualRef;
import com.ibm.awb.weakref.WeakRefTable;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public abstract class WeakRef
implements Ref {
    long _ref_count = 0L;
    protected WeakRefTable _table = null;

    protected WeakRef(WeakRefTable weakRefTable) {
        this._table = weakRefTable;
    }

    protected abstract Ref findRef();

    protected abstract Ref findRef(ObjectInputStream var1) throws IOException, ClassNotFoundException;

    public final Ref getRef(VirtualRef virtualRef) {
        Ref ref = this.findRef();
        if (ref != null) {
            virtualRef.setRef(ref);
            return ref;
        }
        return this;
    }

    protected abstract Object getRefID();

    public final synchronized void referenced() {
        ++this._ref_count;
    }

    public final void setRef(VirtualRef virtualRef, ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        Ref ref = this.findRef(objectInputStream);
        if (ref != null) {
            virtualRef.setRef(ref);
        }
    }

    public String toString() {
        return "WeakRef[count=" + this._ref_count + "]";
    }

    public final void unreferenced() {
        this._table.unreference(this);
    }

    protected boolean updateRef(VirtualRef virtualRef) {
        return virtualRef.getRef() == this;
    }

    public abstract void writeInfo(ObjectOutputStream var1) throws IOException;

    public abstract String getRefClassName();
}

