/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.awb.weakref;

import com.ibm.awb.weakref.WeakRef;
import java.util.Enumeration;
import java.util.Hashtable;

public class WeakRefTable {
    private static boolean _debug = true;
    private Hashtable _ref_table = new Hashtable();

    public void add(WeakRef weakRef) {
        this._ref_table.put(weakRef.getRefID(), weakRef);
    }

    protected void debug(WeakRef weakRef, String string) {
        System.out.println(string);
        System.out.println(this.toString(weakRef));
    }

    public WeakRef getWeakRef(Object object) {
        return (WeakRef)this._ref_table.get(object);
    }

    public String toString() {
        return this.toString(null);
    }

    protected String toString(WeakRef weakRef) {
        Enumeration enumeration = this._ref_table.elements();
        int n = 0;
        StringBuffer stringBuffer = new StringBuffer();
        while (enumeration.hasMoreElements()) {
            WeakRef weakRef2 = (WeakRef)enumeration.nextElement();
            if (weakRef2 == weakRef) {
                stringBuffer.append("*[" + n + "]" + weakRef2.toString() + "\n");
            } else {
                stringBuffer.append(" [" + n + "]" + weakRef2.toString() + "\n");
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    synchronized void unreference(WeakRef weakRef) {
        WeakRef weakRef2 = weakRef;
        synchronized (weakRef2) {
            --weakRef._ref_count;
            if (weakRef._ref_count == 0L && this._ref_table.contains(weakRef)) {
                this._ref_table.remove(weakRef.getRefID());
            }
        }
    }
}

