/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.maf;

import com.ibm.aglet.Ticket;
import com.ibm.aglet.system.AgletRuntime;
import com.ibm.awb.misc.FileUtils;
import com.ibm.awb.misc.Opt;
import com.ibm.awb.misc.Resource;
import com.ibm.maf.AgentIsRunning;
import com.ibm.maf.AgentIsSuspended;
import com.ibm.maf.AgentNotFound;
import com.ibm.maf.AgentProfile;
import com.ibm.maf.AgentStatus;
import com.ibm.maf.AgentSystemHandler;
import com.ibm.maf.AgentSystemInfo;
import com.ibm.maf.ArgumentInvalid;
import com.ibm.maf.AuthInfo;
import com.ibm.maf.ClassName;
import com.ibm.maf.ClassUnknown;
import com.ibm.maf.DeserializationFailed;
import com.ibm.maf.EntryNotFound;
import com.ibm.maf.FinderNotFound;
import com.ibm.maf.MAFExtendedException;
import com.ibm.maf.MAFFinder;
import com.ibm.maf.MessageEx;
import com.ibm.maf.Name;
import com.ibm.maf.NotHandled;
import com.ibm.maf.ResumeFailed;
import com.ibm.maf.SuspendFailed;
import com.ibm.maf.TerminateFailed;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.net.UnknownHostException;
import java.util.Hashtable;

public abstract class MAFAgentSystem {
    public static final Opt[] option_defs = new Opt[]{Opt.Entry("-defaultport", "atp.defaultport", null), Opt.Entry("-port", "atp.port", "    -port <port>         set the port used by deamon"), Opt.Entry("-resolve", "atp.resolve", "true", "    -resolve             resolve hostname by reverse lookup"), Opt.Entry("-domain", "atp.domain", "    -domain <domainname> set the domain name"), Opt.Entry("-offline", "atp.offline", "true", null), Opt.Entry("-noauthentication", "atp.authentication", "false", "    -noauthentication    do not authenticate"), Opt.Entry("-authentication", "atp.authentication", "true", "    -authentication      do authenticate"), Opt.Entry("-pseudoseed", "atp.secureseed", "false", "    -pseudoseed          use pseudo random seed"), Opt.Entry("-secureseed", "atp.secureseed", "true", "    -secureseed          use secure random seed")};
    static Hashtable handlers = new Hashtable();
    private static MAFAgentSystem local = null;
    static boolean enabled = false;

    public abstract Name create_agent(Name var1, AgentProfile var2, byte[] var3, String var4, Object[] var5, ClassName[] var6, String var7, MAFAgentSystem var8) throws ClassUnknown, ArgumentInvalid, DeserializationFailed, MAFExtendedException;

    private static synchronized void createResource(String string) {
        AgletRuntime agletRuntime = AgletRuntime.getAgletRuntime();
        if (agletRuntime == null) {
            return;
        }
        String string2 = agletRuntime.getOwnerName();
        if (string2 == null) {
            return;
        }
        Resource resource = Resource.getResourceFor(string);
        if (resource == null) {
            try {
                String string3 = FileUtils.getPropertyFilenameForUser(string2, string);
                resource = Resource.createResource(string, string3, null);
                System.out.println("reading " + string.toUpperCase() + " property from " + string3);
            }
            catch (SecurityException securityException) {
                resource = null;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (resource == null) {
            System.out.println("[No resource for " + string.toUpperCase() + " found: use defaults]");
            resource = Resource.createResource(string, null);
        }
        resource.importOptionProperties(string);
        resource.setDefaultResource(string + ".addressbook", "");
    }

    private static void enableMAFURLStreamHandlers() {
        if (enabled) {
            return;
        }
        enabled = true;
        try {
            URLStreamHandlerFactory uRLStreamHandlerFactory = new URLStreamHandlerFactory(){

                public URLStreamHandler createURLStreamHandler(String string) {
                    try {
                        return (URLStreamHandler)Class.forName("com.ibm.net.protocol." + string + ".Handler").newInstance();
                    }
                    catch (Exception exception) {
                        return null;
                    }
                }
            };
            URL.setURLStreamHandlerFactory(uRLStreamHandlerFactory);
        }
        catch (SecurityException securityException) {
            securityException.printStackTrace();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public abstract byte[][] fetch_class(ClassName[] var1, String var2, AgentProfile var3) throws ClassUnknown, MAFExtendedException;

    public abstract String find_nearby_agent_system_of_profile(AgentProfile var1) throws EntryNotFound;

    public abstract AgentStatus get_agent_status(Name var1) throws AgentNotFound;

    public abstract AgentSystemInfo get_agent_system_info();

    public abstract AuthInfo get_authinfo(Name var1) throws AgentNotFound;

    public abstract MAFFinder get_MAFFinder() throws FinderNotFound;

    public abstract String getAddress();

    private static synchronized AgentSystemHandler getHandler(String string) {
        AgentSystemHandler agentSystemHandler = (AgentSystemHandler)handlers.get(string);
        if (agentSystemHandler == null) {
            String string2 = "com.ibm.maf." + string.toLowerCase() + ".Handler";
            try {
                agentSystemHandler = (AgentSystemHandler)Class.forName(string2).newInstance();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return null;
            }
            handlers.put(string, agentSystemHandler);
        }
        return agentSystemHandler;
    }

    public static MAFAgentSystem getLocalMAFAgentSystem() {
        return local;
    }

    public static MAFAgentSystem getMAFAgentSystem(Ticket ticket) throws UnknownHostException {
        String string = ticket.getProtocol();
        return MAFAgentSystem.getHandler(string).getMAFAgentSystem(ticket);
    }

    public static MAFAgentSystem getMAFAgentSystem(String string) throws MalformedURLException, UnknownHostException {
        int n = string.indexOf(58);
        int n2 = string.indexOf(47);
        String string2 = "atp";
        if (n > 0 && n2 > n) {
            string2 = string.substring(0, n);
            string = string.substring(n + 1);
        }
        return MAFAgentSystem.getHandler(string2).getMAFAgentSystem(string);
    }

    public static synchronized void initMAFAgentSystem(MAFAgentSystem mAFAgentSystem, String string) throws MAFExtendedException {
        if (local != null && local != mAFAgentSystem) {
            throw new MAFExtendedException("Local Agent system cannot be set twice");
        }
        MAFAgentSystem.createResource(string);
        MAFAgentSystem.enableMAFURLStreamHandlers();
        MAFAgentSystem.initURLStreamHandlers(string);
        if (string == null) {
            string = "mafiiop";
        }
        AgentSystemHandler agentSystemHandler = MAFAgentSystem.getHandler(string);
        local = mAFAgentSystem;
        agentSystemHandler.initMAFAgentSystem(local);
    }

    private static void initURLStreamHandlers(String string) {
        try {
            new URL("HTTP://www.ibm.com");
            new URL("http://www.ibm.com");
            new URL("file://www.ibm.com");
            new URL("FILE://www.ibm.com");
            new URL(string.toLowerCase() + "://www.ibm.com");
            new URL(string.toUpperCase() + "://www.ibm.com");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public abstract Name[] list_all_agents();

    public abstract Name[] list_all_agents_of_authority(byte[] var1);

    public abstract String[] list_all_places();

    public abstract void receive_agent(Name var1, AgentProfile var2, byte[] var3, String var4, ClassName[] var5, String var6, MAFAgentSystem var7) throws ClassUnknown, DeserializationFailed, MAFExtendedException;

    public abstract long receive_future_message(Name var1, byte[] var2, MAFAgentSystem var3) throws AgentNotFound, ClassUnknown, DeserializationFailed, MAFExtendedException;

    public abstract void receive_future_reply(long var1, byte[] var3) throws EntryNotFound, ClassUnknown, DeserializationFailed, MAFExtendedException;

    public abstract byte[] receive_message(Name var1, byte[] var2) throws AgentNotFound, NotHandled, MessageEx, ClassUnknown, DeserializationFailed, MAFExtendedException;

    public abstract void receive_oneway_message(Name var1, byte[] var2) throws AgentNotFound, ClassUnknown, DeserializationFailed, MAFExtendedException;

    public abstract void resume_agent(Name var1) throws AgentNotFound, ResumeFailed, AgentIsRunning;

    public abstract byte[] retract_agent(Name var1) throws AgentNotFound, MAFExtendedException;

    public abstract void setAddress(String var1);

    public static synchronized void startMAFAgentSystem(MAFAgentSystem mAFAgentSystem, String string) throws MAFExtendedException {
        AgentSystemHandler agentSystemHandler = MAFAgentSystem.getHandler(string);
        agentSystemHandler.startMAFAgentSystem(mAFAgentSystem);
    }

    public abstract void suspend_agent(Name var1) throws AgentNotFound, SuspendFailed, AgentIsSuspended;

    public abstract void terminate_agent(Name var1) throws AgentNotFound, TerminateFailed;
}

