/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.maf;

import com.ibm.aglet.AgletID;
import com.ibm.maf.Name;
import java.security.cert.Certificate;

public final class MAFUtil {
    private static Name null_name = new Name(new byte[1], new byte[1], 0);
    static String[] agent_systems = new String[]{"NonAgentSystem", "Aglets", "MOA", "AgentTcl"};
    static String[] languages = new String[]{"LanguageNotSpecified", "Java", "Tcl", "Scheme", "Perl"};
    public static final short AGENT_SYSTEM_TYPE_AGLETS = 1;

    public static Name decodeName(byte[] byArray) {
        if (byArray.length < 4) {
            return null_name;
        }
        short s = byArray[0];
        short s2 = byArray[1];
        short s3 = (short)((s << 8) + (s2 << 0));
        short s4 = byArray[2];
        short s5 = byArray[3];
        short s6 = (short)((s4 << 8) + (s5 << 0));
        byte[] byArray2 = new byte[s6];
        byte[] byArray3 = new byte[byArray.length - s6 - 4];
        System.arraycopy(byArray, 4, byArray2, 0, s6);
        System.arraycopy(byArray, 4 + s6, byArray3, 0, byArray3.length);
        return new Name(byArray3, byArray2, s3);
    }

    public static String decodeString(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < byArray.length) {
            byte by = byArray[n];
            stringBuffer.append(Character.forDigit(by >>> 4 & 0xF, 16));
            stringBuffer.append(Character.forDigit(by & 0xF, 16));
            ++n;
        }
        return stringBuffer.toString();
    }

    public static byte[] encodeName(Name name) {
        int n = name.identity.length + name.authority.length + 2 + 2;
        byte[] byArray = new byte[n];
        byArray[0] = (byte)(name.agent_system_type >>> 8 & 0xFF);
        byArray[1] = (byte)(name.agent_system_type >>> 0 & 0xFF);
        short s = (short)name.identity.length;
        byArray[2] = (byte)(s >>> 8 & 0xFF);
        byArray[3] = (byte)(s >>> 0 & 0xFF);
        System.arraycopy(name.identity, 0, byArray, 4, s);
        System.arraycopy(name.authority, 0, byArray, 4 + s, name.authority.length);
        return byArray;
    }

    public static byte[] encodeString(String string) {
        int n = string.length();
        byte[] byArray = new byte[n / 2];
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            byArray[n2] = (byte)(Character.digit(string.charAt(n3++), 16) << 4);
            int n4 = n2++;
            byArray[n4] = (byte)(byArray[n4] + (byte)Character.digit(string.charAt(n3), 16));
            ++n3;
        }
        return byArray;
    }

    public static String toAgentSystem(short s) {
        if (s >= 0 && s < agent_systems.length) {
            return agent_systems[s];
        }
        return null;
    }

    public static short toAgentSystemType(String string) {
        short s = 0;
        while (s < agent_systems.length) {
            if (agent_systems[s].equalsIgnoreCase(string)) {
                return s;
            }
            s = (short)(s + 1);
        }
        return 0;
    }

    public static AgletID toAgletID(Name name) {
        return new AgletID(name.identity);
    }

    public static String toLanguage(short s) {
        if (s >= 0 && s < languages.length) {
            return languages[s];
        }
        return null;
    }

    public static short toLanguageID(String string) {
        short s = 0;
        while (s < languages.length) {
            if (languages[s].equalsIgnoreCase(string)) {
                return s;
            }
            s = (short)(s + 1);
        }
        return 0;
    }

    public static Name toName(AgletID agletID, Certificate certificate) {
        byte[] byArray;
        try {
            byArray = certificate != null ? certificate.getEncoded() : new byte[]{};
        }
        catch (Exception exception) {
            exception.printStackTrace();
            byArray = new byte[]{};
        }
        return new Name(byArray, agletID.toByteArray(), 1);
    }
}

