/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.maf.atp;

import com.ibm.atp.AtpConstants;
import com.ibm.atp.ContentBuffer;
import com.ibm.atp.ContentOutputStream;
import com.ibm.atp.auth.SharedSecret;
import com.ibm.atp.auth.SharedSecrets;
import com.ibm.awb.misc.Hexadecimal;
import com.ibm.awb.misc.TeeOutputStream;
import com.ibm.maf.AgentProfile;
import com.ibm.maf.MAFUtil;
import com.ibm.maf.Name;
import com.ibm.maf.atp.Connection;
import com.ibm.maf.atp.Daemon;
import com.ibm.maf.atp.HttpProxyConnection;
import com.ibm.maf.atp.SocketConnection;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.SocketPermission;
import java.net.URL;
import java.net.URLConnection;
import java.security.AccessController;
import java.util.Date;
import java.util.Hashtable;

public class AtpConnectionImpl
extends URLConnection
implements AtpConstants {
    public static final int ATP_DEFAULT_PORT = 4434;
    protected static final String CRLF = "\r\n";
    protected static final String ATP_VERSION = "ATP/0.1";
    static Hashtable default_request_properties = new Hashtable();
    static AgentProfile agent_profile = null;
    private int _request_type = 1000;
    private InputStream _inputStream = null;
    private ContentOutputStream _outputStream = null;
    private Connection _connection = null;
    private String from = null;
    private Name agent_name = null;
    private String securityDomainname = null;
    private byte[] mic = null;
    Hashtable request_properties;
    private Hashtable headers = new Hashtable();

    public AtpConnectionImpl(URL uRL) throws IOException {
        super(uRL);
        this.request_properties = (Hashtable)default_request_properties.clone();
    }

    public void close() throws IOException {
        if (this._connection != null) {
            this._connection.close();
        }
    }

    public synchronized void connect() throws IOException {
        if (this.connected) {
            return;
        }
        if (this._request_type == 1000) {
            this._request_type = AtpConnectionImpl.guessRequestTypeFromURL(this.url);
        }
        if (HttpProxyConnection.useHttpProxy(this.url)) {
            int n = this.url.getPort();
            String string = this.url.getHost() + ':' + (n == -1 ? 4434 : n);
            SocketPermission socketPermission = new SocketPermission(string, "connect");
            AccessController.checkPermission(socketPermission);
            this._connection = new HttpProxyConnection(this.url, 4434);
        } else {
            this._connection = new SocketConnection(this.url, 4434);
        }
        if (this._connection == null || !this._connection.isEstablished()) {
            String string = null;
            if (this._connection != null) {
                string = this._connection.getMessage();
            }
            if (string == null) {
                string = "connection not available";
            }
            this._connection = null;
            throw new IOException(string);
        }
        this.connected = true;
        this.securityDomainname = this._connection.getAuthenticatedSecurityDomain();
    }

    public String getHeaderField(String string) {
        try {
            this.getInputStream();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        String string2 = (String)this.headers.get(string.toLowerCase());
        return string2;
    }

    public synchronized InputStream getInputStream() throws IOException {
        if (this._inputStream != null) {
            return this._inputStream;
        }
        this.connect();
        if (!this.connected) {
            return null;
        }
        if (this._request_type == 1002 || this._request_type == 1003 || this._request_type == 1004) {
            OutputStream outputStream = this._connection.getOutputStream();
            PrintStream printStream = null;
            printStream = Daemon.isVerbose() ? new PrintStream(new TeeOutputStream(System.err, outputStream)) : new PrintStream(outputStream);
            this.sendRequestHeaders(printStream);
            printStream.print(CRLF);
            printStream.flush();
            if (outputStream instanceof ContentBuffer) {
                ((ContentBuffer)((Object)outputStream)).sendContent();
            }
        }
        this._inputStream = this._connection.getInputStream();
        this.parseHeaders();
        return this._inputStream;
    }

    public byte[] getMIC() {
        return this.mic;
    }

    public synchronized OutputStream getOutputStream() throws IOException {
        if (this._outputStream != null) {
            return this._outputStream;
        }
        if (this._request_type != 1001 && this._request_type != 1005) {
            throw new IllegalAccessError("Request Type " + this._request_type + " doesn't support output");
        }
        this.connect();
        if (!this.connected) {
            return null;
        }
        this._outputStream = this._request_type == 1005 ? new ContentOutputStream(this._connection.getOutputStream()) : new ContentOutputStream(this._connection.getOutputStream());
        PrintStream printStream = null;
        printStream = Daemon.isVerbose() ? new PrintStream(new TeeOutputStream(System.err, this._outputStream)) : new PrintStream(this._outputStream);
        this.sendRequestHeaders(printStream);
        printStream.print("Content-Type:" + this.getProperty("content-type") + CRLF + "Content-Encoding:" + this.getProperty("content-encoding") + CRLF + "Content-Language:" + this.getProperty("content-language") + CRLF);
        this._outputStream.startContent();
        return this._outputStream;
    }

    public String getProperty(String string) {
        return (String)this.request_properties.get(string);
    }

    public String getReasonPhase() {
        try {
            this.getInputStream();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this.getHeaderField("reason-phase");
    }

    SharedSecret getSharedSecret() {
        if (this.securityDomainname == null) {
            return null;
        }
        SharedSecrets sharedSecrets = SharedSecrets.getSharedSecrets();
        if (sharedSecrets == null) {
            return null;
        }
        return sharedSecrets.getSharedSecret(this.securityDomainname);
    }

    public int getStatusCode() {
        int n = -1;
        try {
            this.getInputStream();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        try {
            String string = this.getHeaderField("status-code");
            if (string == null) {
                string = "-1";
            }
            n = Integer.parseInt(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return n;
    }

    protected static int guessRequestTypeFromURL(URL uRL) throws IOException {
        String string = uRL.getFile();
        String string2 = uRL.getRef();
        if (string != null && string.startsWith("#")) {
            return 1002;
        }
        if (string == null || "".equals(string) || "/".equals(string) || "//".equals(string) || "///".equals(string)) {
            if (string2 == null) {
                return 1001;
            }
            return 1002;
        }
        if (string2 != null || "".equals(string2)) {
            throw new MalformedURLException("Unknown request : " + uRL);
        }
        return 1003;
    }

    public void parseHeaders() throws IOException {
        DataInputStream dataInputStream = new DataInputStream(this._inputStream);
        AtpConnectionImpl.parseHeaders(dataInputStream, this.headers);
    }

    public static void parseHeaders(DataInputStream dataInputStream, Hashtable hashtable) throws IOException {
        String string = dataInputStream.readLine();
        int n = -1;
        AtpConnectionImpl.verboseOut("[stausLine = " + string + ']');
        int n2 = string.indexOf(32);
        if (n2 < 1) {
            throw new IOException("Invalid Response :" + string);
        }
        int n3 = string.indexOf(32, n2 + 1);
        if (n3 < 1) {
            throw new IOException("Invalid Response :" + string);
        }
        int n4 = n3 + 1;
        String string2 = string.substring(0, n2);
        if (!string2.equalsIgnoreCase(ATP_VERSION)) {
            throw new IOException("ATP Version Mismatch");
        }
        hashtable.put("version", string2);
        string2 = string.substring(n2 + 1, n3);
        hashtable.put("status-code", string2);
        try {
            n = Integer.parseInt(string2);
        }
        catch (Exception exception) {
            n = -1;
        }
        if (n4 > 0) {
            string2 = string.substring(n4);
            hashtable.put("reason-phase", string2);
        }
        while (true) {
            String string3;
            if ((string3 = dataInputStream.readLine()) != null) {
                AtpConnectionImpl.verboseOut(">" + string3);
            }
            if (n != 100 && n != 200) {
                AtpConnectionImpl.verboseOut("|" + string3);
            }
            if (string3 == null || string3.length() == 0) break;
            String string4 = string3.substring(0, string3.indexOf(58)).trim();
            String string5 = string3.substring(string3.indexOf(58) + 1).trim();
            hashtable.put(string4.toLowerCase(), string5);
        }
    }

    public void sendRequest() throws IOException {
        switch (this._request_type) {
            case 1001: 
            case 1005: {
                if (this._outputStream == null) {
                    throw new IllegalAccessError("No content input");
                }
                this._outputStream.sendContent();
                break;
            }
            case 1002: 
            case 1003: 
            case 1004: {
                this.connect();
                if (!this.connected) break;
                this.getInputStream();
                break;
            }
            default: {
                throw new RuntimeException("Invalid Request Type : " + this._request_type);
            }
        }
    }

    protected void sendRequestHeaders(PrintStream printStream) throws IOException {
        Object var2_2 = null;
        switch (this._request_type) {
            case 1001: {
                printStream.print("DISPATCH " + this.url.toExternalForm().replace(' ', '+'));
                break;
            }
            case 1002: {
                printStream.print("RETRACT " + this.url.toExternalForm().replace(' ', '+'));
                break;
            }
            case 1003: {
                printStream.print("FETCH " + this.url.toExternalForm().replace(' ', '+'));
                break;
            }
            case 1005: {
                try {
                    this.url = new URL(this.url, '#' + MAFUtil.toAgletID(this.agent_name).toString());
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                printStream.print("MESSAGE " + this.url.toExternalForm().replace(' ', '+'));
            }
        }
        String string = MAFUtil.toAgentSystem(AtpConnectionImpl.agent_profile.agent_system_type);
        String string2 = MAFUtil.toLanguage(AtpConnectionImpl.agent_profile.language_id);
        printStream.print(" ATP/0.1\r\ndate:" + new Date().toString() + CRLF + "user-agent:" + this.getProperty("user-agent") + CRLF + "from:" + this.from + CRLF + "host:" + this.url.getHost() + CRLF + "agent-system:" + string + CRLF + "agent-language:" + string2 + CRLF + "agent-id:" + (this.agent_name == null ? null : MAFUtil.decodeString(MAFUtil.encodeName(this.agent_name))) + CRLF + (this.mic == null ? "" : "mic:" + Hexadecimal.valueOf(this.mic) + CRLF));
    }

    public void setAgentName(Name name) {
        this.agent_name = name;
    }

    public void setAgentProfile(AgentProfile agentProfile) {
        agent_profile = agentProfile;
    }

    public void setMIC(byte[] byArray) {
        this.mic = byArray;
    }

    public void setRequestProperty(String string, String string2) {
        if (this.connected) {
            throw new IllegalAccessError("Already connected");
        }
        string = string.toLowerCase();
        this.request_properties.put(string, string2);
        if (string.equals("agent-language")) {
            AtpConnectionImpl.agent_profile.language_id = MAFUtil.toLanguageID(string2);
        } else if (string.equals("agent-system")) {
            AtpConnectionImpl.agent_profile.agent_system_type = MAFUtil.toAgentSystemType(string2);
        } else if (string.equals("from")) {
            this.from = string2;
        } else if (string.equals("agent-id")) {
            this.agent_name = MAFUtil.decodeName(MAFUtil.encodeString(string2));
        } else if (string.equals("mic")) {
            try {
                this.mic = Hexadecimal.parseSeq(string2);
            }
            catch (NumberFormatException numberFormatException) {
                this.mic = null;
            }
        }
    }

    public void setRequestType(int n) {
        if (this.connected) {
            throw new IllegalAccessError("Already connected");
        }
        if (this._request_type != 1000) {
            throw new IllegalAccessError("Request type Already set");
        }
        if (1000 >= n || 1008 <= n) {
            throw new IllegalArgumentException("setRequestType (" + n + ")");
        }
        this._request_type = n;
    }

    public void setSender(String string) {
        this.from = string;
    }

    private static void verboseOut(String string) {
        Daemon.verboseOut(string);
    }

    static {
        short s = 1;
        agent_profile = new AgentProfile(s, s, "Aglets", s, s, s, null);
        default_request_properties.put("user-agent", "Aglets");
        default_request_properties.put("from", "");
        default_request_properties.put("content-type", "application/x-aglets");
        default_request_properties.put("content-language", "");
        default_request_properties.put("content-encoding", "");
    }
}

