/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.maf.atp;

import com.ibm.maf.AgentProfile;
import com.ibm.maf.MAFUtil;
import com.ibm.maf.Name;
import com.ibm.maf.atp.AtpRequest;
import com.ibm.maf.atp.Daemon;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Hashtable;
import java.util.StringTokenizer;

public final class AtpRequestImpl
implements AtpRequest {
    static final String ATP_VERSION = "ATP/0.1";
    private InputStream in;
    private int method = 0;
    private URL requestURI = null;
    private String requestLine = null;
    private Hashtable headers = new Hashtable();
    static AgentProfile agent_profile = null;

    public AtpRequestImpl(InputStream inputStream) throws IOException {
        this.in = inputStream;
    }

    public Name getAgentName() {
        return MAFUtil.decodeName(MAFUtil.encodeString(this.getRequestParameter("agent-id")));
    }

    public String getAgentNameAsString() {
        return this.getRequestParameter("agent-id");
    }

    public AgentProfile getAgentProfile() {
        return agent_profile;
    }

    public int getContentLength() {
        try {
            return Integer.parseInt(this.getRequestParameter("content-length"));
        }
        catch (Exception exception) {
            return -1;
        }
    }

    public String getFetchClassFile() {
        return this.requestURI.toString();
    }

    public InputStream getInputStream() {
        return this.in;
    }

    public int getMethod() {
        return this.method;
    }

    public String getPlaceName() {
        int n;
        String string = this.requestURI.getFile();
        if (string == null || string.length() == 0) {
            return "";
        }
        if (string.startsWith("/servlet")) {
            n = (string = string.substring(9)).indexOf(47, 1);
            if (n > 0) {
                string = string.substring(n);
            } else {
                return "";
            }
        }
        if (string.startsWith("/aglets")) {
            string = string.substring(7);
        }
        if ((string = (n = string.indexOf(47, 1)) > 0 ? string.substring(string.charAt(0) == '/' ? 1 : 0, n) : string.substring(string.charAt(0) == '/' ? 1 : 0)).equals("default") || string.equals("cxt")) {
            string = "";
        }
        return string;
    }

    public String getRequestLine() {
        return this.requestLine;
    }

    public String getRequestParameter(String string) {
        return this.getRequestParameter(string, null);
    }

    public String getRequestParameter(String string, String string2) {
        String string3 = (String)this.headers.get(string.toLowerCase());
        return string3 == null ? string2 : string3;
    }

    public String getSender() {
        return this.getRequestParameter("from");
    }

    public void parseHeaders() throws IOException {
        DataInputStream dataInputStream = new DataInputStream(this.in);
        this.requestLine = dataInputStream.readLine();
        this.headers.put("requestline", this.requestLine);
        AtpRequestImpl.verboseOut("[requestLine : " + this.requestLine + ']');
        StringTokenizer stringTokenizer = new StringTokenizer(this.requestLine, " ", false);
        if (stringTokenizer.countTokens() != 3) {
            throw new IOException("Invalid Request :" + this.requestLine);
        }
        String string = stringTokenizer.nextToken().trim();
        this.headers.put("method", string);
        if ("dispatch".equalsIgnoreCase(string)) {
            this.method = 1001;
        } else if ("retract".equalsIgnoreCase(string)) {
            this.method = 1002;
        } else if ("fetch".equalsIgnoreCase(string)) {
            this.method = 1003;
        } else if ("ping".equalsIgnoreCase(string)) {
            this.method = 1004;
        } else if ("message".equalsIgnoreCase(string)) {
            this.method = 1005;
        } else if ("reply".equalsIgnoreCase(string)) {
            this.method = 1006;
        } else {
            throw new IOException("Invalid Request :" + this.requestLine);
        }
        string = stringTokenizer.nextToken().trim().replace('+', ' ');
        this.headers.put("requesturi", string);
        try {
            this.requestURI = new URL(string);
        }
        catch (Exception exception) {
            this.requestURI = null;
        }
        String string2 = stringTokenizer.nextToken();
        this.headers.put("version", string2);
        if (!ATP_VERSION.equalsIgnoreCase(string2)) {
            throw new IOException("Invalid Protocol: " + this.requestLine);
        }
        while (true) {
            String string3 = dataInputStream.readLine().trim();
            if (this.method == 1007) {
                AtpRequestImpl.verboseOut("|" + string3);
            }
            if (string3.length() == 0) break;
            String string4 = string3.substring(0, string3.indexOf(58)).trim();
            String string5 = string3.substring(string3.indexOf(58) + 1).trim();
            this.headers.put(string4.toLowerCase(), string5);
        }
        AtpRequestImpl.agent_profile.agent_system_type = MAFUtil.toAgentSystemType(this.getRequestParameter("agent-system", "aglets"));
        AtpRequestImpl.agent_profile.language_id = MAFUtil.toLanguageID(this.getRequestParameter("agent-language", "java"));
    }

    private static void verboseOut(String string) {
        Daemon.verboseOut(string);
    }

    static {
        short s = 1;
        agent_profile = new AgentProfile(s, s, "Aglets", s, s, s, null);
    }
}

