/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.maf.atp;

import com.ibm.atp.ContentOutputStream;
import com.ibm.maf.atp.AtpResponse;
import java.io.IOException;
import java.io.OutputStream;

public final class AtpResponseImpl
implements AtpResponse {
    private static final String CRLF = "\r\n";
    private OutputStream out = null;
    private ContentOutputStream bout = null;
    private boolean request_sent = false;
    private int statusCode = -1;
    private String statusMsg;
    private String content_type = "";
    private String content_language = "";
    private String content_encoding = "";

    public AtpResponseImpl(OutputStream outputStream) throws IOException {
        this.out = outputStream;
    }

    public OutputStream getOutputStream() throws IOException {
        if (this.bout == null) {
            this.bout = new ContentOutputStream(this.out, true);
        }
        return this.bout;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public void sendError(int n) throws IOException {
        this.setStatusCode(n);
        this.writeStatusLine();
        int n2 = 0;
        while (n2 < CRLF.length()) {
            this.out.write(CRLF.charAt(n2));
            ++n2;
        }
        if (this.bout != null) {
            this.bout.sendContent();
        }
        this.out.flush();
        this.out.close();
    }

    public void sendResponse() throws IOException {
        this.writeStatusLine();
        this.writeHeaders();
        if (this.bout != null) {
            this.bout.sendContent();
        }
        this.out.flush();
    }

    public void setContentType(String string) {
        this.content_type = string;
    }

    public void setStatusCode(int n) {
        this.statusCode = n;
        switch (this.statusCode) {
            case 100: {
                this.statusMsg = "OKAY";
                break;
            }
            case 200: {
                this.statusMsg = "MOVED";
                break;
            }
            case 300: {
                this.statusMsg = "BAD REQUEST";
                break;
            }
            case 301: {
                this.statusMsg = "FORBIDDEN";
                break;
            }
            case 302: {
                this.statusMsg = "NOT FOUND";
                break;
            }
            case 400: {
                this.statusMsg = "INTERNAL ERROR";
                break;
            }
            case 401: {
                this.statusMsg = "NOT IMPLEMENTED";
                break;
            }
            case 402: {
                this.statusMsg = "BAD GATEWAY";
                break;
            }
            case 403: {
                this.statusMsg = "SERVICE UNAVAILABLE";
                break;
            }
            case 500: {
                this.statusMsg = "NOT AUTHENTICATED";
            }
        }
    }

    public void setStatusCode(int n, String string) {
        this.statusCode = n;
        this.statusMsg = string;
    }

    private void writeHeaders() throws IOException {
        String string = "";
        string = string + "Content-Type:" + this.content_type + CRLF + "Content-Language:" + this.content_language + CRLF + "Content-Encoding:" + this.content_encoding + CRLF;
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            this.out.write(string.charAt(n2));
            ++n2;
        }
    }

    private void writeStatusLine() throws IOException {
        String string = "ATP/0.1 " + this.statusCode + " " + this.statusMsg + CRLF;
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            this.out.write(string.charAt(n2));
            ++n2;
        }
    }
}

