/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.maf.atp;

import com.ibm.atp.AtpConstants;
import com.ibm.atp.auth.AuthPacket;
import com.ibm.atp.auth.Authentication;
import com.ibm.atp.auth.AuthenticationProtocolException;
import com.ibm.atp.auth.SharedSecret;
import com.ibm.atp.auth.SharedSecrets;
import com.ibm.awb.misc.Hexadecimal;
import com.ibm.awb.misc.Resource;
import com.ibm.maf.AgentNotFound;
import com.ibm.maf.ClassName;
import com.ibm.maf.ClassUnknown;
import com.ibm.maf.DeserializationFailed;
import com.ibm.maf.MAFAgentSystem;
import com.ibm.maf.MAFExtendedException;
import com.ibm.maf.MessageEx;
import com.ibm.maf.Name;
import com.ibm.maf.NotHandled;
import com.ibm.maf.atp.AtpRequest;
import com.ibm.maf.atp.AtpRequestImpl;
import com.ibm.maf.atp.AtpResponse;
import com.ibm.maf.atp.AtpResponseImpl;
import com.ibm.maf.atp.Daemon;
import com.ibm.maf.atp.HttpCGIRequestImpl;
import com.ibm.maf.atp.HttpCGIResponseImpl;
import com.ibm.maf.atp.HttpFilter;
import com.ibm.maf.atp.HttpResponseOutputStream;
import com.ibm.maf.atp.MAFAgentSystem_ATPClient;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.security.AccessController;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedExceptionAction;
import java.util.Hashtable;

final class ConnectionHandler
extends Thread
implements AtpConstants {
    private static final String MESSAGE_DIGEST_ALGORITHM = "SHA";
    private static MessageDigest _mdigest = null;
    private MAFAgentSystem _maf = null;
    private ServerSocket _serversocket = null;
    private Socket _connection = null;
    private Authentication _auth = null;
    private boolean _authenticated = false;
    private static ThreadGroup group = new ThreadGroup("ConnectionHandler");
    private static int BUFFSIZE = 2048;
    private static int number = 0;
    private static boolean authentication = false;
    private static int max_handlers = 32;
    private static int num_handlers = 0;
    private static int idle_handlers = 0;
    static boolean http_tunneling;
    static boolean http_messaging;
    private Hashtable headers = new Hashtable();
    byte[] future_reply = null;
    private static final String CRLF = "\r\n";

    public ConnectionHandler(MAFAgentSystem mAFAgentSystem, ServerSocket serverSocket) {
        super(group, "handler:" + number++);
        this._serversocket = serverSocket;
        this._maf = mAFAgentSystem;
        ++num_handlers;
        this.start();
    }

    static byte[] calculateMIC(SharedSecret sharedSecret, byte[] byArray) {
        if (sharedSecret == null) {
            return null;
        }
        if (byArray == null) {
            return null;
        }
        _mdigest.reset();
        _mdigest.update(byArray);
        _mdigest.update(sharedSecret.secret());
        return _mdigest.digest();
    }

    private static void dumpBytes(byte[] byArray) {
        if (byArray != null) {
            int n = 0;
            while (n < byArray.length) {
                System.out.print(Hexadecimal.valueOf(byArray[n]));
                if (n % 16 == 15) {
                    System.out.println();
                } else {
                    System.out.print(" ");
                }
                ++n;
            }
            if (byArray.length % 16 != 0) {
                System.out.println();
            }
        }
    }

    private static boolean equalsSeq(byte[] byArray, byte[] byArray2) {
        if (byArray == null && byArray2 == null) {
            return true;
        }
        if (byArray == null || byArray2 == null || byArray.length != byArray2.length) {
            return false;
        }
        int n = 0;
        while (n < byArray.length) {
            if (byArray[n] != byArray2[n]) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private static byte[] getMIC(AtpRequest atpRequest) {
        String string = atpRequest.getRequestParameter("mic");
        if (string == null) {
            return null;
        }
        byte[] byArray = null;
        try {
            byArray = Hexadecimal.parseSeq(string);
        }
        catch (NumberFormatException numberFormatException) {
            System.err.println("Illegal MIC in ATP request header : " + string);
        }
        return byArray;
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void handle() throws IOException {
        AtpRequest atpRequest = null;
        AtpResponse atpResponse = null;
        InetAddress inetAddress = null;
        long l = System.currentTimeMillis();
        inetAddress = this._connection.getInetAddress();
        ConnectionHandler.verboseOut("[Connected from " + inetAddress + ']');
        BufferedInputStream bufferedInputStream = new BufferedInputStream(this._connection.getInputStream(), BUFFSIZE);
        ((InputStream)bufferedInputStream).mark(128);
        DataInputStream dataInputStream = new DataInputStream(bufferedInputStream);
        String string = dataInputStream.readLine();
        ((InputStream)bufferedInputStream).reset();
        if (string == null) {
            try {
                this._connection.close();
                return;
            }
            catch (IOException iOException) {
                System.err.println(iOException.toString());
            }
            return;
        }
        this._auth = null;
        this._authenticated = false;
        if (AuthPacket.isTopLine(string)) {
            if (SharedSecrets.getSharedSecrets() == null) {
                throw new IOException("Authentication failed : no shared secrets.");
            }
            this._auth = new Authentication(2, dataInputStream, this._connection);
            try {
                this._authenticated = this._auth.authenticate();
            }
            catch (AuthenticationProtocolException authenticationProtocolException) {
                System.err.println(authenticationProtocolException.toString());
                try {
                    this._connection.close();
                    throw new IOException("Authentication failed : " + authenticationProtocolException.getMessage());
                }
                catch (IOException iOException) {
                    System.err.println(iOException.toString());
                }
                throw new IOException("Authentication failed : " + authenticationProtocolException.getMessage());
            }
            catch (IOException iOException) {
                System.err.println(iOException.toString());
                try {
                    this._connection.close();
                    throw new IOException("Authentication failed : " + iOException.getMessage());
                }
                catch (IOException iOException2) {
                    System.err.println(iOException2.toString());
                }
                throw new IOException("Authentication failed : " + iOException.getMessage());
            }
            if (!this._authenticated) {
                atpResponse = new AtpResponseImpl(new BufferedOutputStream(this._connection.getOutputStream(), BUFFSIZE));
                atpResponse.sendError(500);
                try {
                    this._connection.close();
                    return;
                }
                catch (IOException iOException) {
                    System.err.println(iOException.toString());
                }
                return;
            }
            ((InputStream)bufferedInputStream).mark(128);
            string = dataInputStream.readLine();
            ((InputStream)bufferedInputStream).reset();
            if (string == null) {
                try {
                    this._connection.close();
                    return;
                }
                catch (IOException iOException) {
                    System.err.println(iOException.toString());
                }
                return;
            }
        }
        String string2 = string.trim();
        if ((string2 = string2.substring(string2.lastIndexOf(32) + 1, string2.lastIndexOf(47))).equalsIgnoreCase("ATP")) {
            if (authentication && (this._auth == null || !this._authenticated)) {
                System.err.println("ATP connection from unauthenticated host is closed.");
                atpResponse = new AtpResponseImpl(new BufferedOutputStream(this._connection.getOutputStream(), BUFFSIZE));
                atpResponse.sendError(500);
                try {
                    this._connection.close();
                    return;
                }
                catch (IOException iOException) {
                    System.err.println(iOException.toString());
                }
                return;
            }
            atpRequest = new AtpRequestImpl(bufferedInputStream);
            atpResponse = new AtpResponseImpl(new BufferedOutputStream(this._connection.getOutputStream(), BUFFSIZE));
        } else {
            if (!string2.equalsIgnoreCase("HTTP")) throw new IOException("unknown protocol " + string2);
            ConnectionHandler.verboseOut("[Accepting HTTP..]");
            HttpFilter.readHttpHeaders(bufferedInputStream, this.headers);
            String string3 = (String)this.headers.get("method");
            String string4 = (String)this.headers.get("content-type");
            if ("GET".equalsIgnoreCase(string3) && http_messaging) {
                ConnectionHandler.verboseOut("[Http/GET request received.]");
                atpRequest = new HttpCGIRequestImpl(bufferedInputStream, this.headers);
                atpResponse = new HttpCGIResponseImpl(this._connection.getOutputStream());
            } else if ("POST".equalsIgnoreCase(string3) && "application/x-atp".equalsIgnoreCase(string4) && http_tunneling) {
                ConnectionHandler.verboseOut("[Http/POST request received.]");
                atpRequest = new AtpRequestImpl(bufferedInputStream);
                atpResponse = new AtpResponseImpl(new HttpResponseOutputStream(this._connection.getOutputStream()));
            } else {
                if (!"POST".equalsIgnoreCase(string3) || !"application/x-www-url-form".equalsIgnoreCase(string4)) throw new IOException("Unknown Content-Type:" + string4);
                ConnectionHandler.verboseOut("[POST request received.]");
                this.sendHttpResponse();
                ConnectionHandler.verboseOut("[Sending responser.]");
                return;
            }
        }
        try {
            atpRequest.parseHeaders();
        }
        catch (IOException iOException) {
            try {
                this._connection.close();
            }
            catch (IOException iOException3) {
                System.err.println(iOException3.toString());
            }
            Daemon.error(inetAddress, System.currentTimeMillis(), "", iOException.toString());
            Daemon.access(inetAddress, System.currentTimeMillis(), atpRequest.getRequestLine(), atpResponse.getStatusCode(), String.valueOf('-'));
            return;
        }
        this.handleRequest(atpRequest, atpResponse);
        Object var13_23 = null;
        try {
            this._connection.close();
        }
        catch (IOException iOException) {
            System.err.println(iOException.toString());
        }
        Daemon.access(inetAddress, System.currentTimeMillis(), atpRequest.getRequestLine(), atpResponse.getStatusCode(), String.valueOf('-'));
        {
            return;
            catch (IOException iOException) {
                if (Daemon.isVerbose()) {
                    iOException.printStackTrace();
                }
                Daemon.error(inetAddress, System.currentTimeMillis(), "", iOException.toString());
                iOException.printStackTrace();
                try {
                    atpResponse.sendError(400);
                }
                catch (IOException iOException4) {
                    System.err.println(iOException4.toString());
                }
                Object var13_24 = null;
                try {
                    this._connection.close();
                }
                catch (IOException iOException5) {
                    System.err.println(iOException5.toString());
                }
                Daemon.access(inetAddress, System.currentTimeMillis(), atpRequest.getRequestLine(), atpResponse.getStatusCode(), String.valueOf('-'));
                return;
            }
        }
        catch (Throwable throwable) {
            Object var13_25 = null;
            try {
                this._connection.close();
            }
            catch (IOException iOException) {
                System.err.println(iOException.toString());
            }
            Daemon.access(inetAddress, System.currentTimeMillis(), atpRequest.getRequestLine(), atpResponse.getStatusCode(), String.valueOf('-'));
            throw throwable;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void handleDispatchRequest(AtpRequest atpRequest, AtpResponse atpResponse) throws IOException {
        atpResponse.setContentType("application/x-aglets");
        boolean bl = false;
        try {
            try {
                byte[] byArray;
                Object object;
                MAFAgentSystem mAFAgentSystem = MAFAgentSystem.getMAFAgentSystem(atpRequest.getSender());
                DataInputStream dataInputStream = new DataInputStream(atpRequest.getInputStream());
                String string = dataInputStream.readUTF();
                int n = dataInputStream.readInt();
                ClassName[] classNameArray = new ClassName[n];
                int n2 = 0;
                while (n2 < n) {
                    object = dataInputStream.readUTF();
                    byArray = new byte[dataInputStream.readInt()];
                    dataInputStream.readFully(byArray, 0, byArray.length);
                    classNameArray[n2] = new ClassName((String)object, byArray);
                    ++n2;
                }
                object = new byte[dataInputStream.readInt()];
                dataInputStream.readFully((byte[])object, 0, ((Object)object).length);
                if (this._auth != null && this._authenticated) {
                    byArray = ConnectionHandler.getMIC(atpRequest);
                    SharedSecret sharedSecret = this._auth.getSelectedSecret();
                    if (byArray != null && sharedSecret != null && object != null) {
                        if (!ConnectionHandler.verifyMIC(byArray, sharedSecret, (byte[])object)) {
                            throw new IOException("Incorrect MIC of transfered aglet.");
                        }
                        ConnectionHandler.verboseOut("MIC is CORRECT.");
                    }
                }
                this._maf.receive_agent(atpRequest.getAgentName(), atpRequest.getAgentProfile(), (byte[])object, atpRequest.getPlaceName(), classNameArray, string, mAFAgentSystem);
                atpResponse.getOutputStream();
                atpResponse.setStatusCode(100);
                atpResponse.sendResponse();
                return;
            }
            catch (SecurityException securityException) {
                atpResponse.sendError(301);
                return;
            }
            catch (ClassUnknown classUnknown) {
                atpResponse.sendError(302);
                return;
            }
            catch (DeserializationFailed deserializationFailed) {
                atpResponse.sendError(302);
                return;
            }
            catch (MAFExtendedException mAFExtendedException) {
                atpResponse.sendError(400);
                return;
            }
        }
        catch (Throwable throwable) {
            Object var14_22 = null;
            if (bl) throw throwable;
            atpResponse.sendError(400);
            throw throwable;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void handleFetchRequest(AtpRequest atpRequest, AtpResponse atpResponse) throws IOException {
        Object var3_3 = null;
        atpResponse.setContentType("application/x-aglets");
        boolean bl = false;
        try {
            try {
                byte[][] byArray = this._maf.fetch_class(null, atpRequest.getFetchClassFile(), atpRequest.getAgentProfile());
                OutputStream outputStream = atpResponse.getOutputStream();
                ConnectionHandler.verboseOut("fetch_class(" + atpRequest.getFetchClassFile() + ") : " + byArray[0].length + "bytes");
                outputStream.write(byArray[0]);
                atpResponse.setStatusCode(100);
                atpResponse.sendResponse();
                return;
            }
            catch (ClassUnknown classUnknown) {
                atpResponse.sendError(302);
                return;
            }
            catch (MAFExtendedException mAFExtendedException) {
                atpResponse.sendError(400);
                return;
            }
        }
        catch (Throwable throwable) {
            Object var8_12 = null;
            if (bl) throw throwable;
            atpResponse.sendError(302);
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void handleMessageRequest(AtpRequest atpRequest, AtpResponse atpResponse) throws IOException {
        atpResponse.setContentType("application/x-aglets");
        boolean bl = false;
        Name name = atpRequest.getAgentName();
        InputStream inputStream = atpRequest.getInputStream();
        byte by = (byte)inputStream.read();
        int n = atpRequest.getContentLength();
        byte[] byArray = new byte[n - 1];
        new DataInputStream(inputStream).readFully(byArray);
        try {
            try {
                block6 : switch (by) {
                    case 0: {
                        try {
                            byte[] byArray2 = this._maf.receive_message(name, byArray);
                            OutputStream outputStream = atpResponse.getOutputStream();
                            outputStream.write(0);
                            outputStream.write(byArray2, 0, byArray2.length);
                            atpResponse.setStatusCode(100);
                            atpResponse.sendResponse();
                        }
                        catch (NotHandled notHandled) {
                            atpResponse.getOutputStream().write(1);
                            atpResponse.setStatusCode(100);
                            atpResponse.sendResponse();
                        }
                        catch (MessageEx messageEx) {
                            DataOutputStream dataOutputStream = new DataOutputStream(atpResponse.getOutputStream());
                            dataOutputStream.writeByte(2);
                            messageEx.write(dataOutputStream);
                            atpResponse.setStatusCode(100);
                            atpResponse.sendResponse();
                        }
                        break;
                    }
                    case 1: {
                        String string = atpRequest.getSender();
                        MAFAgentSystem mAFAgentSystem = MAFAgentSystem.getMAFAgentSystem(string);
                        long l = this._maf.receive_future_message(name, byArray, mAFAgentSystem);
                        if (mAFAgentSystem instanceof MAFAgentSystem_ATPClient) {
                            ((MAFAgentSystem_ATPClient)mAFAgentSystem).registerFutureReply(this, l);
                        }
                        OutputStream outputStream = atpResponse.getOutputStream();
                        atpResponse.setStatusCode(100);
                        atpResponse.sendResponse();
                        ConnectionHandler connectionHandler = this;
                        synchronized (connectionHandler) {
                            while (true) {
                                if (this.future_reply != null) {
                                    outputStream.write(this.future_reply);
                                    outputStream.flush();
                                    outputStream.close();
                                    this.future_reply = null;
                                    break block6;
                                }
                                try {
                                    this.wait();
                                }
                                catch (InterruptedException interruptedException) {
                                    // empty catch block
                                }
                            }
                        }
                    }
                    case 2: {
                        this._maf.receive_oneway_message(name, byArray);
                        atpResponse.getOutputStream();
                        atpResponse.setStatusCode(100);
                        atpResponse.sendResponse();
                        break;
                    }
                }
                bl = true;
            }
            catch (AgentNotFound agentNotFound) {
                atpResponse.sendError(302);
                return;
            }
            catch (ClassUnknown classUnknown) {
                atpResponse.sendError(302);
                return;
            }
            catch (DeserializationFailed deserializationFailed) {
                atpResponse.sendError(302);
                return;
            }
            catch (MAFExtendedException mAFExtendedException) {
                atpResponse.sendError(400);
                return;
            }
            Object var18_23 = null;
            if (bl) return;
        }
        catch (Throwable throwable) {
            Object var18_28 = null;
            if (bl) throw throwable;
            atpResponse.sendError(400);
            throw throwable;
        }
        atpResponse.sendError(400);
    }

    void handleRequest(AtpRequest atpRequest, AtpResponse atpResponse) throws IOException {
        switch (atpRequest.getMethod()) {
            case 1001: {
                this.handleDispatchRequest(atpRequest, atpResponse);
                break;
            }
            case 1002: {
                this.handleRetractRequest(atpRequest, atpResponse);
                break;
            }
            case 1003: {
                this.handleFetchRequest(atpRequest, atpResponse);
                break;
            }
            case 1005: {
                this.handleMessageRequest(atpRequest, atpResponse);
                break;
            }
            default: {
                atpResponse.sendError(300);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void handleRetractRequest(AtpRequest atpRequest, AtpResponse atpResponse) throws IOException {
        atpResponse.setContentType("application/x-aglets");
        boolean bl = false;
        try {
            try {
                byte[] byArray = this._maf.retract_agent(atpRequest.getAgentName());
                OutputStream outputStream = atpResponse.getOutputStream();
                outputStream.write(byArray);
                atpResponse.setStatusCode(100);
                atpResponse.sendResponse();
                return;
            }
            catch (SecurityException securityException) {
                atpResponse.sendError(301);
                return;
            }
            catch (AgentNotFound agentNotFound) {
                atpResponse.sendError(302);
                return;
            }
            catch (MAFExtendedException mAFExtendedException) {
                mAFExtendedException.printStackTrace();
                atpResponse.sendError(400);
                return;
            }
        }
        catch (Throwable throwable) {
            Object var8_12 = null;
            if (bl) throw throwable;
            atpResponse.sendError(400);
            throw throwable;
        }
    }

    public synchronized void run() {
        try {
            while (true) {
                try {
                    while (true) {
                        ++idle_handlers;
                        try {
                            final ServerSocket serverSocket = this._serversocket;
                            this._connection = (Socket)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                                public Object run() throws IOException {
                                    return serverSocket.accept();
                                }
                            });
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                        if (--idle_handlers == 0 && num_handlers < max_handlers) {
                            new ConnectionHandler(this._maf, this._serversocket);
                        }
                        this.handle();
                        this._connection = null;
                        this.headers.clear();
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    continue;
                }
                break;
            }
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            --num_handlers;
            throw throwable;
        }
    }

    synchronized void sendFutureReply(byte[] byArray) {
        this.future_reply = byArray;
        this.notify();
    }

    private void sendHttpResponse() throws IOException {
        PrintStream printStream = new PrintStream(this._connection.getOutputStream());
        printStream.print("HTTP/1.0 200 OKAY\r\n");
        printStream.print("Content-type: text/html\r\n");
        String string = "<HTTP><HEAD> ATP DAEMON/0.1 </HEAD><BODY><H1> IBM ATP DAEMON/0.1 </H1><BR></BODY></HTTP>";
        printStream.print("Content-length: " + string.length() + CRLF + CRLF);
        printStream.println(string);
        this._connection.getOutputStream().flush();
        this._connection.close();
    }

    public String toString() {
        return super.toString() + ", handling = " + (this._connection != null);
    }

    public static void update() {
        Resource resource = Resource.getResourceFor("atp");
        BUFFSIZE = resource.getInteger("atp.buffersize", 2048);
        authentication = resource.getBoolean("atp.authentication", false);
        http_tunneling = resource.getBoolean("atp.http.tunneling", false);
        http_messaging = resource.getBoolean("atp.http.messaging", false);
        max_handlers = resource.getInteger("atp.maxHandlerThread", 32);
    }

    private static void verboseOut(String string) {
        Daemon.verboseOut(string);
    }

    static boolean verifyMIC(byte[] byArray, SharedSecret sharedSecret, byte[] byArray2) {
        if (byArray == null) {
            System.err.println("No MIC");
            return false;
        }
        if (sharedSecret == null) {
            System.err.println("No authenticated security domain");
            return false;
        }
        if (byArray2 == null) {
            System.err.println("No Aglet");
            return false;
        }
        byte[] byArray3 = ConnectionHandler.calculateMIC(sharedSecret, byArray2);
        ConnectionHandler.verboseOut("MIC=" + Hexadecimal.valueOf(byArray));
        ConnectionHandler.verboseOut("digest=" + Hexadecimal.valueOf(byArray3));
        return ConnectionHandler.equalsSeq(byArray, byArray3);
    }

    static {
        try {
            _mdigest = MessageDigest.getInstance(MESSAGE_DIGEST_ALGORITHM);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            noSuchAlgorithmException.printStackTrace();
        }
        ConnectionHandler.update();
        http_tunneling = false;
        http_messaging = false;
    }
}

