/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.maf.atp;

import com.ibm.aglet.Ticket;
import com.ibm.aglets.security.Randoms;
import com.ibm.atp.auth.SharedSecrets;
import com.ibm.awb.misc.FileUtils;
import com.ibm.awb.misc.NullOutputStream;
import com.ibm.awb.misc.Resource;
import com.ibm.maf.MAFAgentSystem;
import com.ibm.maf.atp.ConnectionHandler;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.RandomAccessFile;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.ServerSocket;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import java.security.cert.Certificate;
import java.text.DateFormat;
import java.util.Date;
import java.util.Hashtable;

public final class Daemon {
    static Hashtable locals = new Hashtable();
    String _username = null;
    Certificate _certificate = null;
    private int _maxHandlerThreads = 32;
    private Hashtable _handlerCache = new Hashtable();
    private int _port = -1;
    private static boolean verbose = false;
    private URL hosting = null;
    private Resource resource = null;
    MAFAgentSystem _maf = null;
    private static PrintStream nullStream = null;
    private static PrintStream message;
    private static PrintStream error;
    private static PrintStream access;

    Daemon(MAFAgentSystem mAFAgentSystem) {
        this._maf = mAFAgentSystem;
        try {
            this.hosting = new URL(mAFAgentSystem.getAddress());
            this._port = this.hosting.getPort() == -1 ? 4434 : this.hosting.getPort();
            String string = this.hosting.getHost() + ":" + this._port;
            locals.put(string, mAFAgentSystem);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            try {
                this.hosting = new URL("atp://localhost:" + this._port);
            }
            catch (MalformedURLException malformedURLException) {
                throw new RuntimeException("couldn't make hosting URL");
            }
        }
        this.resource = Resource.getResourceFor("atp");
        this.resolveResources();
    }

    public static void access(InetAddress inetAddress, long l, String string, int n, String string2) {
        DateFormat dateFormat = DateFormat.getDateInstance();
        access.println(inetAddress.getHostName() + " - - [" + dateFormat.format(new Date(l)) + "] \"" + string + "\" " + n + " " + string2);
    }

    public static void error(InetAddress inetAddress, long l, String string, String string2) {
        DateFormat dateFormat = DateFormat.getDateInstance();
        error.println("[" + dateFormat.format(new Date(l)) + "] " + string + " from " + inetAddress.getHostName() + " reason: " + string2);
        error.flush();
    }

    public static MAFAgentSystem getLocalAgentSystem(Ticket ticket) {
        String string = ticket.getHost();
        int n = ticket.getPort();
        string = string + (n == -1 ? "" : ":" + n);
        return Daemon.getLocalAgentSystem(string);
    }

    public static MAFAgentSystem getLocalAgentSystem(String string) {
        return (MAFAgentSystem)locals.get(string);
    }

    static final boolean isVerbose() {
        return verbose;
    }

    public void message(long l, String string) {
        DateFormat dateFormat = DateFormat.getDateInstance();
        String string2 = "[" + dateFormat.format(new Date(l)) + "] " + string;
        message.println(string2);
        message.flush();
    }

    private static OutputStream openStream(String string) throws IOException {
        if (!FileUtils.ensureDirectory(string)) {
            throw new IOException("Cannot create diretory for " + string);
        }
        if (!FileUtils.ensureFile(string)) {
            throw new IOException("Cannot create file : " + string);
        }
        RandomAccessFile randomAccessFile = new RandomAccessFile(string, "rw");
        randomAccessFile.seek(new File(string).length());
        return new FileOutputStream(randomAccessFile.getFD());
    }

    private void resolveResources() {
        if (this._port == -1) {
            try {
                String string = (String)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        return System.getProperty("maf.port");
                    }
                });
                this._port = Integer.parseInt(string);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this._port = 4434;
            }
        }
        this._maxHandlerThreads = this.resource.getInteger("atp.maxHandlerThread", 32);
    }

    public static void setAccessLogFile(String string) throws IOException {
        Daemon.setAccessLogStream(Daemon.openStream(string));
    }

    public static void setAccessLogStream(OutputStream outputStream) {
        try {
            final OutputStream outputStream2 = outputStream;
            access = (PrintStream)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return new PrintStream(outputStream2);
                }
            });
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void setErrorLogFile(String string) throws IOException {
        Daemon.setErrorLogStream(Daemon.openStream(string));
    }

    public static void setErrorLogStream(OutputStream outputStream) {
        try {
            final OutputStream outputStream2 = outputStream;
            error = (PrintStream)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return new PrintStream(outputStream2);
                }
            });
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void setMessageLogFile(String string) throws IOException {
        Daemon.setMessageLogStream(Daemon.openStream(string));
    }

    public static void setMessageLogStream(OutputStream outputStream) {
        try {
            final OutputStream outputStream2 = outputStream;
            message = (PrintStream)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return new PrintStream(outputStream2);
                }
            });
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void setUser(String string, Certificate certificate) {
        this._username = string;
        this._certificate = certificate;
    }

    public void start() {
        boolean bl = this.resource.getBoolean("atp.authentication", false);
        boolean bl2 = this.resource.getBoolean("atp.secureseed", false);
        Randoms.setUseSecureRandomSeed(bl2);
        if (bl2) {
            System.out.println("USE SECURE RANDOM SEED.");
        } else {
            System.out.println("USE UNSECURE PSEUDO RANDOM SEED.");
        }
        if (bl) {
            System.out.print("[Generating random seed ... wait for a while ... ");
            Randoms.getRandomGenerator(32);
            System.out.println("done.]");
        }
        if (bl && SharedSecrets.getSharedSecrets() == null) {
            System.out.println("No shared secret file for authentication.");
            System.out.println("Authentication requires a shared secret file");
            System.out.println("which is duplicated from other host,");
            System.out.println("or newly created file.");
            this.resource.setResource("atp.authentication", "false");
            this.resource.setOptionResource("atp.authentication", "false");
            bl = false;
        }
        if (bl) {
            System.out.println("AUTHENTICATION MODE ON.");
        } else {
            System.out.println("AUTHENTICATION MODE OFF.");
        }
        ServerSocket serverSocket = null;
        try {
            final int n = this._port;
            serverSocket = (ServerSocket)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    return new ServerSocket(n);
                }
            });
            this.message(System.currentTimeMillis(), "IBM Agent Daemon started with atp:" + this._port + " " + this._maxHandlerThreads + " agentSystem: aglets");
            this.resource.setDefaultResource("atp.server", "true");
        }
        catch (Exception exception) {
            serverSocket = null;
            this.message(System.currentTimeMillis(), "IBM Agent Server failed to open the protocol atp:" + this._port);
            this.resource.setDefaultResource("atp.server", "false");
        }
        if (serverSocket == null) {
            return;
        }
        new ConnectionHandler(this._maf, serverSocket);
        new ConnectionHandler(this._maf, serverSocket);
        new ConnectionHandler(this._maf, serverSocket);
        new ConnectionHandler(this._maf, serverSocket);
    }

    public static void update() {
        Resource resource = Resource.getResourceFor("system");
        if (resource != null) {
            verbose = resource.getBoolean("verbose", false);
        }
        ConnectionHandler.update();
    }

    static final void verboseOut(String string) {
        if (verbose) {
            System.out.println(string);
        }
    }

    static {
        try {
            nullStream = (PrintStream)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return new PrintStream(new NullOutputStream());
                }
            });
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        message = nullStream;
        error = nullStream;
        access = nullStream;
    }
}

