/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.maf.atp;

import com.ibm.aglet.Ticket;
import com.ibm.aglet.system.AgletRuntime;
import com.ibm.awb.misc.Resource;
import com.ibm.maf.AgentSystemHandler;
import com.ibm.maf.AgentSystemInfo;
import com.ibm.maf.FinderNotFound;
import com.ibm.maf.MAFAgentSystem;
import com.ibm.maf.MAFExtendedException;
import com.ibm.maf.MAFFinder;
import com.ibm.maf.atp.Daemon;
import com.ibm.maf.atp.MAFAgentSystem_ATPClient;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Hashtable;
import java.util.Properties;

public class Handler
implements AgentSystemHandler {
    static final int DEFAULT_PORT = 4434;
    static boolean initialized = false;

    private static String getFullyQualifiedHostName() throws UnknownHostException {
        Object object;
        Resource resource = Resource.getResourceFor("atp");
        if (resource.getBoolean("atp.offline", false)) {
            return "localhost";
        }
        InetAddress inetAddress = InetAddress.getLocalHost();
        if (inetAddress == null) {
            throw new UnknownHostException("Illegal local host.");
        }
        String string = inetAddress.getHostAddress();
        if (string == null || string.equals("")) {
            throw new UnknownHostException("IP address of local host does not exist.");
        }
        String string2 = null;
        if (resource.getBoolean("atp.resolve", false)) {
            object = InetAddress.getByName(string);
            string2 = object != null ? ((InetAddress)object).getHostName() : inetAddress.getHostName();
            if (string2 == null || string2.equals("")) {
                throw new UnknownHostException("No host name.");
            }
        } else {
            string2 = InetAddress.getLocalHost().getHostName();
        }
        if ((object = resource.getString("atp.domain")) != null) {
            if (string2.indexOf(46) < 0) {
                string2 = string2 + "." + (String)object;
                InetAddress.getByName(string2);
            } else {
                System.out.println("You cannot set domain name");
            }
        } else if (string2.indexOf(46) < 0) {
            System.out.println("[Warning: The hostname seems not having domain name.");
            System.out.println(" Please try -resolve option to resolve the fully qualified hostname");
            System.out.println(" or use -domain option to manually specify the domain name.]");
        }
        return string2;
    }

    public MAFAgentSystem getMAFAgentSystem(Ticket ticket) throws UnknownHostException {
        MAFAgentSystem mAFAgentSystem = Daemon.getLocalAgentSystem(ticket);
        if (mAFAgentSystem != null) {
            return mAFAgentSystem;
        }
        return new MAFAgentSystem_ATPClient(ticket);
    }

    public MAFAgentSystem getMAFAgentSystem(String string) throws UnknownHostException {
        MAFAgentSystem mAFAgentSystem;
        int n = -1;
        if (string.startsWith("//")) {
            string = string.substring(2);
            n = string.indexOf(47);
        } else if (string.startsWith("/")) {
            string = string.substring(1);
            n = string.indexOf(47);
        } else {
            n = string.indexOf(47);
        }
        if (n >= 0) {
            string = string.substring(0, n);
        }
        if ((mAFAgentSystem = Daemon.getLocalAgentSystem(string)) != null) {
            return mAFAgentSystem;
        }
        return new MAFAgentSystem_ATPClient(string);
    }

    public synchronized void initMAFAgentSystem(MAFAgentSystem mAFAgentSystem) throws MAFExtendedException {
        try {
            int n;
            if (initialized) {
                return;
            }
            initialized = true;
            Properties properties = System.getProperties();
            String string = properties.getProperty("maf.port", String.valueOf(4434));
            try {
                n = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                n = 4434;
                System.err.println("maf.port must be a number, use 4434");
            }
            ((Hashtable)properties).put("maf.port", String.valueOf(n));
            Resource resource = Resource.getResourceFor("atp");
            resource.setDefaultResource("atp.protocols", "atp");
            resource.setDefaultResource("atp.maxHandlerThread", "32");
            String string2 = Handler.getFullyQualifiedHostName();
            mAFAgentSystem.setAddress("atp://" + string2 + ":" + n);
            Resource resource2 = Resource.getResourceFor("system");
            if (resource.getBoolean("atp.useHttpProxy", false)) {
                resource2.setResource("http.proxyHost", resource.getString("atp.http.proxyHost", ""));
                resource2.setResource("http.proxyPort", resource.getString("atp.http.proxyPort", ""));
                resource2.setResource("proxyHost", resource.getString("atp.http.proxyHost", ""));
                resource2.setResource("proxyPort", resource.getString("atp.http.proxyPort", ""));
            }
            resource2.setResource("http.nonProxyHosts", resource.getString("atp.noProxy", ""));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new MAFExtendedException(exception.toString());
        }
    }

    public void startMAFAgentSystem(MAFAgentSystem mAFAgentSystem) throws MAFExtendedException {
        block7: {
            try {
                Daemon daemon = new Daemon(mAFAgentSystem);
                AgletRuntime agletRuntime = AgletRuntime.getAgletRuntime();
                if (agletRuntime != null) {
                    daemon.setUser(agletRuntime.getOwnerName(), agletRuntime.getOwnerCertificate());
                }
                daemon.start();
                Daemon.update();
                try {
                    MAFFinder mAFFinder = mAFAgentSystem.get_MAFFinder();
                    if (mAFFinder == null) break block7;
                    try {
                        AgentSystemInfo agentSystemInfo = mAFAgentSystem.get_agent_system_info();
                        String string = mAFAgentSystem.getAddress();
                        mAFFinder.register_agent_system(agentSystemInfo.agent_system_name, string, agentSystemInfo);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                catch (FinderNotFound finderNotFound) {}
            }
            catch (Exception exception) {
                throw new MAFExtendedException(exception.toString());
            }
        }
    }
}

