/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.maf.atp;

import com.ibm.aglet.AgletContext;
import com.ibm.aglet.AgletID;
import com.ibm.aglet.system.AgletRuntime;
import com.ibm.atp.AtpConstants;
import com.ibm.awb.misc.CGIMessage;
import com.ibm.awb.misc.Encoding;
import com.ibm.awb.misc.Resource;
import com.ibm.awb.misc.URIEncoder;
import com.ibm.maf.AgentProfile;
import com.ibm.maf.MAFUtil;
import com.ibm.maf.Name;
import com.ibm.maf.atp.AtpRequest;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.util.Hashtable;
import java.util.StringTokenizer;

final class HttpCGIRequestImpl
implements AtpRequest,
AtpConstants {
    private InputStream in;
    private String requestLine = null;
    private String place = null;
    private Hashtable headers = null;
    private ByteArrayInputStream bin = null;
    private int length = 0;
    private static AgentProfile agent_profile = null;
    private Name name = null;
    private static String urlEncoding = null;
    static AgletRuntime runtime = null;
    static Resource res = null;

    public HttpCGIRequestImpl(InputStream inputStream, Hashtable hashtable) throws IOException {
        this.headers = hashtable;
        this.in = inputStream;
    }

    private StringTokenizer checkFormat(String string) throws IOException {
        if (string.charAt(0) != '/') {
            throw new IOException("Invalid Format :" + this.headers.get("requestline"));
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
        if (string.endsWith("/") ? stringTokenizer.countTokens() < 3 : stringTokenizer.countTokens() < 4) {
            throw new IOException("Invalid Format :" + this.headers.get("requestline"));
        }
        return stringTokenizer;
    }

    private static String decode(String string) {
        if (string == null) {
            return null;
        }
        String string2 = null;
        try {
            final String string3 = string;
            final String string4 = urlEncoding;
            string2 = (String)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() {
                    try {
                        return URIEncoder.decode(string3, string4);
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        return URIEncoder.decode(string3);
                    }
                }
            });
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return string2;
    }

    public Name getAgentName() {
        return this.name;
    }

    public String getAgentNameAsString() {
        return MAFUtil.decodeString(MAFUtil.encodeName(this.name));
    }

    public AgentProfile getAgentProfile() {
        return agent_profile;
    }

    public int getContentLength() {
        return this.length;
    }

    public String getFetchClassFile() {
        return null;
    }

    public InputStream getInputStream() {
        return this.bin;
    }

    public int getMethod() {
        return 1005;
    }

    public String getPlaceName() {
        return this.place;
    }

    public String getRequestLine() {
        return this.requestLine;
    }

    public String getRequestParameter(String string) {
        return this.getRequestParameter(string, null);
    }

    public String getRequestParameter(String string, String string2) {
        String string3 = (String)this.headers.get(string.toLowerCase());
        return string3 == null ? string2 : string3;
    }

    public String getSender() {
        return this.getRequestParameter("from");
    }

    public void parseHeaders() throws IOException {
        Object object;
        AgletContext agletContext;
        this.requestLine = this.headers.get("method") + " " + this.headers.get("requestURI") + " " + this.headers.get("protocol");
        String string = (String)this.headers.get("method");
        if (!"GET".equalsIgnoreCase(string) && !"POST".equalsIgnoreCase(string)) {
            throw new IOException("Invalid Request :" + this.headers.get("requestline"));
        }
        String string2 = (String)this.headers.get("protocol");
        if (string2 == null || !string2.startsWith("HTTP/1.")) {
            throw new IOException("Invalid Protocol :" + this.headers.get("requestline"));
        }
        String string3 = (String)this.headers.get("host");
        if (string3 == null) {
            string3 = "file:///";
        } else if (!string3.startsWith("http:")) {
            string3 = "http://" + string3;
        }
        URL uRL = null;
        try {
            uRL = new URL(new URL(string3), (String)this.headers.get("requesturi"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            uRL = null;
            return;
        }
        String string4 = null;
        String string5 = uRL.getFile();
        boolean bl = false;
        String string6 = null;
        StringTokenizer stringTokenizer = this.checkFormat(string5);
        String string7 = stringTokenizer.nextToken();
        if (!"aglets".equals(string7)) {
            throw new IOException("Invalid Agent System :" + string7);
        }
        String string8 = stringTokenizer.nextToken();
        String string9 = stringTokenizer.nextToken();
        if ("default".equals(string8)) {
            string8 = "";
        }
        if ((agletContext = runtime.getAgletContext(string8)) == null) {
            throw new IOException("Place Not Found :" + string8);
        }
        Object object2 = agletContext.getProperty("name." + string9);
        this.name = object2 instanceof AgletID ? MAFUtil.toName((AgletID)object2, null) : MAFUtil.toName(new AgletID(string9), null);
        string6 = stringTokenizer.hasMoreTokens() ? stringTokenizer.nextToken() : "";
        int n = string6.indexOf(63);
        if (n > 0) {
            string4 = HttpCGIRequestImpl.decode(string6.substring(0, n));
            string6 = string6.substring(n + 1);
        } else {
            string4 = string6;
            string6 = null;
        }
        CGIMessage cGIMessage = new CGIMessage(string4);
        if (string6 != null) {
            object = new StringTokenizer(string6, "&");
            cGIMessage.setArg("%querystring%", string6);
            while (((StringTokenizer)object).hasMoreTokens()) {
                String string10 = ((StringTokenizer)object).nextToken();
                int n2 = string10.indexOf(61);
                if (n2 <= 0) continue;
                String string11 = HttpCGIRequestImpl.decode(string10.substring(0, n2));
                String string12 = HttpCGIRequestImpl.decode(string10.substring(n2 + 1));
                cGIMessage.setArg(string11, string12);
            }
        }
        object = new ByteArrayOutputStream();
        ((ByteArrayOutputStream)object).write(0);
        new ObjectOutputStream((OutputStream)object).writeObject(cGIMessage);
        this.length = ((ByteArrayOutputStream)object).size();
        this.bin = new ByteArrayInputStream(((ByteArrayOutputStream)object).toByteArray());
    }

    static {
        res = Resource.getResourceFor("atp");
        urlEncoding = res.getString("atp.http.urlencoding", Encoding.getDefault().getJavaEncoding());
        runtime = AgletRuntime.getAgletRuntime();
        short s = 1;
        agent_profile = new AgentProfile(s, s, "Aglets", s, s, s, null);
    }
}

