/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.maf.atp;

import com.ibm.atp.AtpConstants;
import com.ibm.atp.ContentOutputStream;
import com.ibm.maf.atp.AtpResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;

final class HttpCGIResponseImpl
implements AtpResponse,
AtpConstants {
    private static final String CRLF = "\r\n";
    private OutputStream out = null;
    private ContentOutputStream bout = null;
    private boolean request_sent = false;
    private int statusCode = -1;
    private String statusMsg;
    private String content_type = "text/html";

    public HttpCGIResponseImpl(OutputStream outputStream) throws IOException {
        this.out = outputStream;
    }

    public OutputStream getOutputStream() throws IOException {
        if (this.bout == null) {
            this.bout = new ContentOutputStream(this.out, true);
        }
        return this.bout;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public void sendError(int n) throws IOException {
        this.setStatusCode(n);
        this.writeStatusLine();
        String string = "<HTML><BODY>ERROR statusCode = " + n + " : " + this.statusMsg + "</BODY></HTML>";
        int n2 = string.length();
        String string2 = "Content-Length: " + n2 + CRLF + CRLF;
        int n3 = 0;
        while (n3 < string2.length()) {
            this.out.write(string2.charAt(n3));
            ++n3;
        }
        int n4 = 0;
        while (n4 < n2) {
            this.out.write(string.charAt(n4));
            ++n4;
        }
        this.out.flush();
    }

    public void sendResponse() throws IOException {
        this.writeStatusLine();
        this.writeHeaders();
        if (this.bout != null) {
            if (this.bout.size() == 0) {
                PrintWriter printWriter = new PrintWriter(this.bout);
                printWriter.println("No Response is written by the aglet");
                printWriter.flush();
            }
            this.bout.sendContent();
        }
        this.out.flush();
    }

    public void setContentType(String string) {
    }

    public void setStatusCode(int n) {
        this.statusCode = n;
        switch (this.statusCode) {
            case 100: {
                this.statusMsg = "OKAY";
                break;
            }
            case 200: {
                this.statusMsg = "MOVED";
                break;
            }
            case 300: {
                this.statusMsg = "BAD REQUEST";
                break;
            }
            case 301: {
                this.statusMsg = "FORBIDDEN";
                break;
            }
            case 302: {
                this.statusMsg = "NOT FOUND";
                break;
            }
            case 400: {
                this.statusMsg = "INTERNAL ERROR";
                break;
            }
            case 401: {
                this.statusMsg = "NOT IMPLEMENTED";
                break;
            }
            case 402: {
                this.statusMsg = "BAD GATEWAY";
                break;
            }
            case 403: {
                this.statusMsg = "SERVICE UNAVAILABLE";
            }
        }
    }

    public void setStatusCode(int n, String string) {
        this.statusCode = n;
        this.statusMsg = string;
    }

    private void writeHeaders() throws IOException {
        String string = "";
        string = string + "Content-Type:" + this.content_type + CRLF;
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            this.out.write(string.charAt(n2));
            ++n2;
        }
    }

    private void writeStatusLine() throws IOException {
        String string = "HTTP/1.0 " + (this.statusCode + 100) + " " + this.statusMsg + CRLF;
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            this.out.write(string.charAt(n2));
            ++n2;
        }
    }
}

