/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.maf.atp;

import com.ibm.atp.ContentOutputStream;
import com.ibm.awb.misc.Resource;
import com.ibm.maf.atp.Connection;
import com.ibm.maf.atp.Daemon;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.Socket;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.util.Hashtable;

class HttpProxyConnection
implements Connection {
    private static final String CRLF = "\r\n";
    private static String[] noProxies;
    private static String proxyHost;
    private static int proxyPort;
    private static boolean enableProxy;
    OutputStream out;
    Socket _socket = new Socket(proxyHost, proxyPort);
    private boolean established = false;
    ContentOutputStream _outputStream;
    InputStream _inputStream;

    HttpProxyConnection(URL uRL, int n) throws IOException {
        Closeable closeable;
        try {
            closeable = this._socket;
            this.out = (OutputStream)AccessController.doPrivileged(new PrivilegedExceptionAction((Socket)closeable){
                private final /* synthetic */ Socket val$fSocket;
                {
                    this.val$fSocket = socket;
                }

                public Object run() throws IOException {
                    return this.val$fSocket.getOutputStream();
                }
            });
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        closeable = new PrintStream(this.out);
        int n2 = uRL.getPort();
        URL uRL2 = new URL("http", uRL.getHost(), n2 == -1 ? n : n2, uRL.getFile());
        ((PrintStream)closeable).print("POST " + uRL2 + " HTTP/1.0" + CRLF);
        ((PrintStream)closeable).print("Referer: " + uRL2 + CRLF);
        ((PrintStream)closeable).print("User-Agent: Java1.0.2(ATP)\r\n");
        ((PrintStream)closeable).print("Accept: application/x-atp\r\n");
        ((PrintStream)closeable).print("Content-Type: application/x-atp\r\n");
        this.established = true;
    }

    public void close() throws IOException {
        if (this._socket != null) {
            this._socket.close();
        }
        this.established = false;
    }

    public String getAuthenticatedSecurityDomain() {
        return null;
    }

    public synchronized InputStream getInputStream() throws IOException {
        if (this._inputStream == null) {
            this._inputStream = this._socket.getInputStream();
            this.readHeaders();
        }
        return this._inputStream;
    }

    public String getMessage() {
        return null;
    }

    public synchronized OutputStream getOutputStream() throws IOException {
        if (this._outputStream == null) {
            this._outputStream = new ContentOutputStream(this.out, true);
        }
        return this._outputStream;
    }

    public boolean isEstablished() {
        return this.established;
    }

    private void readHeaders() throws IOException {
        String string;
        DataInputStream dataInputStream = new DataInputStream(this._inputStream);
        String string2 = dataInputStream.readLine();
        HttpProxyConnection.verboseOut("statusline = " + string2);
        if (string2 == null) {
            throw new IOException("No response.");
        }
        int n = string2.indexOf(32);
        String string3 = string2.substring(0, n);
        int n2 = string2.indexOf(32, n + 1);
        String string4 = string2.substring(n + 1, n2);
        String string5 = string2.substring(n2 + 1);
        if (!string3.startsWith("HTTP/1.")) {
            throw new IOException("Invalid response.");
        }
        if (Integer.parseInt(string4) != 200) {
            throw new IOException(string5);
        }
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        while (true) {
            string = dataInputStream.readLine();
            HttpProxyConnection.verboseOut(string);
            try {
                if (string.length() == 0) break;
                n = string.indexOf(58);
                String string6 = string.substring(0, n);
                String string7 = string.substring(n + 1);
                string6 = string6.toLowerCase().trim();
                string7 = string7.toLowerCase().trim();
                hashtable.put(string6, string7);
            }
            catch (Exception exception) {
                throw new IOException(exception.getMessage());
            }
        }
        string = (String)hashtable.get("content-type");
        if (!"application/x-atp".equalsIgnoreCase(string)) {
            throw new IOException("Unknown Content-Type:" + string);
        }
    }

    public void sendRequest() throws IOException {
        this._outputStream.sendContent();
    }

    static boolean useHttpProxy(URL uRL) {
        boolean bl = false;
        if (enableProxy && proxyHost != null) {
            String string = uRL.getHost();
            bl = true;
            int n = 0;
            while (n < noProxies.length) {
                if (string.endsWith(noProxies[n]) || string.startsWith(noProxies[n])) {
                    bl = false;
                    break;
                }
                ++n;
            }
        }
        if (bl) {
            HttpProxyConnection.verboseOut("use Proxy for " + uRL);
        } else {
            HttpProxyConnection.verboseOut("no proxy for " + uRL);
        }
        return bl;
    }

    private static final void verboseOut(String string) {
        Daemon.verboseOut(string);
    }

    static {
        enableProxy = false;
        Resource resource = Resource.getResourceFor("atp");
        enableProxy = resource.getBoolean("atp.useHttpProxy", false);
        Resource resource2 = Resource.getResourceFor("system");
        try {
            proxyPort = resource2.getInteger("http.proxyPort", -1);
            proxyHost = resource2.getString("http.proxyHost", null);
            noProxies = resource2.getStringArray("http.nonProxyHosts", " \t,");
            HttpProxyConnection.verboseOut("proxy = " + proxyHost + ':' + proxyPort);
        }
        catch (Throwable throwable) {
            proxyHost = null;
        }
    }
}

