/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.maf.atp;

import com.ibm.atp.ContentBuffer;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;

final class HttpResponseOutputStream
extends ByteArrayOutputStream
implements ContentBuffer {
    public static final String CRLF = "\r\n";
    private OutputStream _out = null;
    private boolean content_sent = false;

    public HttpResponseOutputStream(OutputStream outputStream) {
        this._out = outputStream;
    }

    public void close() throws IOException {
        this.content_sent = true;
        this.flush();
    }

    public void flush() throws IOException {
        if (this.content_sent) {
            this._out.write(this.buf, 0, this.count);
            this._out.flush();
            this.reset();
        }
    }

    public void sendContent() throws IOException {
        HttpResponseOutputStream httpResponseOutputStream = this;
        synchronized (httpResponseOutputStream) {
            if (this.content_sent) {
                throw new IllegalAccessError("content already sent");
            }
            this.content_sent = true;
        }
        PrintStream printStream = new PrintStream(this._out);
        printStream.print("HTTP/1.0 200 OKAY\r\n");
        printStream.print("Content-type: application/x-atp\r\n");
        printStream.print("Content-Length:" + this.count + CRLF);
        printStream.print(CRLF);
        this._out.write(this.buf, 0, this.count);
        this._out.flush();
        this.reset();
        if (this._out instanceof ContentBuffer) {
            ((ContentBuffer)((Object)this._out)).sendContent();
        }
    }
}

