/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.maf.atp;

import com.ibm.atp.auth.Authentication;
import com.ibm.atp.auth.AuthenticationProtocolException;
import com.ibm.awb.misc.Resource;
import com.ibm.maf.atp.Connection;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.URL;

class SocketConnection
implements Connection {
    private static int BUFFSIZE = 2048;
    private Socket _socket;
    private boolean established = false;
    private boolean output_type = false;
    private Authentication auth = null;
    private String message = null;

    SocketConnection(URL uRL, int n) throws IOException {
        int n2 = uRL.getPort();
        if (n2 == -1) {
            n2 = n;
        }
        this._socket = new Socket(uRL.getHost(), n2);
        Resource resource = Resource.getResourceFor("atp");
        boolean bl = resource.getBoolean("atp.authentication", false);
        if (bl) {
            DataInputStream dataInputStream = new DataInputStream(this._socket.getInputStream());
            this.auth = new Authentication(1, dataInputStream, this._socket);
            boolean bl2 = true;
            try {
                bl2 = this.auth.authenticate();
            }
            catch (AuthenticationProtocolException authenticationProtocolException) {
                System.err.println(authenticationProtocolException);
            }
            catch (IOException iOException) {
                System.err.println(iOException);
            }
            if (bl2 && this.auth.isAuthenticatedMyself() && this.auth.isAuthenticatedOpponent()) {
                this.established = true;
            } else {
                this.close();
                this.message = "Authentication failed";
            }
        } else {
            this.established = true;
        }
    }

    public void close() throws IOException {
        this._socket.close();
        this.established = false;
        this.message = "Socket closed";
    }

    public String getAuthenticatedSecurityDomain() {
        if (!this.established || this.auth == null) {
            return null;
        }
        return this.auth.getSelectedDomainName();
    }

    public InputStream getInputStream() throws IOException {
        return new BufferedInputStream(this._socket.getInputStream(), BUFFSIZE);
    }

    public String getMessage() {
        return this.message;
    }

    public OutputStream getOutputStream() throws IOException {
        this.output_type = true;
        return this._socket.getOutputStream();
    }

    public boolean isEstablished() {
        return this.established;
    }

    public void sendRequest() throws IOException {
        if (this.output_type) {
            this._socket.getOutputStream().flush();
        }
    }

    static {
        Resource resource = Resource.getResourceFor("atp");
        BUFFSIZE = resource.getInteger("atp.buffersize", 2048);
    }
}

