/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.maf.rmi;

import com.ibm.aglet.Ticket;
import com.ibm.maf.AgentSystemHandler;
import com.ibm.maf.AgentSystemInfo;
import com.ibm.maf.FinderNotFound;
import com.ibm.maf.MAFAgentSystem;
import com.ibm.maf.MAFExtendedException;
import com.ibm.maf.MAFFinder;
import com.ibm.maf.rmi.MAFAgentSystem_RMI;
import com.ibm.maf.rmi.MAFAgentSystem_RMIClient;
import com.ibm.maf.rmi.MAFAgentSystem_RMIImpl;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.rmi.Naming;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;

public class Handler
implements AgentSystemHandler {
    private static final int DEFAULT_PORT = 4434;
    static Hashtable rmi_agentsystems = new Hashtable();
    static boolean initialized = false;
    private static int MAX_RETRY = 3;

    public MAFAgentSystem getMAFAgentSystem(Ticket ticket) throws UnknownHostException {
        URL uRL = ticket.getDestination();
        String string = uRL.getHost();
        string = string + (uRL.getPort() == -1 ? "" : ":" + uRL.getPort());
        return this.getMAFAgentSystem0(string);
    }

    public MAFAgentSystem getMAFAgentSystem(String string) throws UnknownHostException {
        int n = -1;
        if (string.startsWith("//")) {
            string = string.substring(2);
            n = string.indexOf(47);
        } else if (string.startsWith("/")) {
            string = string.substring(1);
            n = string.indexOf(47);
        } else {
            n = string.indexOf(47);
        }
        if (n >= 0) {
            string = string.substring(0, n);
        }
        return this.getMAFAgentSystem0(string);
    }

    private MAFAgentSystem getMAFAgentSystem0(String string) throws UnknownHostException {
        MAFAgentSystem mAFAgentSystem = MAFAgentSystem_RMIImpl.getLocalAgentSystem(string);
        if (mAFAgentSystem != null) {
            return mAFAgentSystem;
        }
        Hashtable hashtable = rmi_agentsystems;
        synchronized (hashtable) {
            Object object;
            MAFAgentSystem_RMI mAFAgentSystem_RMI = (MAFAgentSystem_RMI)rmi_agentsystems.get(string);
            if (mAFAgentSystem_RMI == null) {
                try {
                    object = string;
                    mAFAgentSystem_RMI = (MAFAgentSystem_RMI)AccessController.doPrivileged(new PrivilegedExceptionAction((String)object){
                        private final /* synthetic */ String val$fAddress;
                        {
                            this.val$fAddress = string;
                        }

                        public Object run() throws UnknownHostException, MalformedURLException, NotBoundException, RemoteException {
                            return Naming.lookup("//" + this.val$fAddress + "/aglets");
                        }
                    });
                    rmi_agentsystems.put(string, mAFAgentSystem_RMI);
                }
                catch (PrivilegedActionException privilegedActionException) {
                    Exception exception = privilegedActionException.getException();
                    if (exception instanceof UnknownHostException) {
                        throw (UnknownHostException)exception;
                    }
                    if (exception instanceof MalformedURLException) {
                        throw new UnknownHostException(exception.getMessage());
                    }
                    if (exception instanceof NotBoundException) {
                        exception.printStackTrace();
                        MAFAgentSystem mAFAgentSystem2 = null;
                        return mAFAgentSystem2;
                    }
                    if (exception instanceof RemoteException) {
                        exception.printStackTrace();
                        MAFAgentSystem mAFAgentSystem3 = null;
                        return mAFAgentSystem3;
                    }
                    privilegedActionException.printStackTrace();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            object = MAFAgentSystem_RMIClient.find_maf_agentsystem(mAFAgentSystem_RMI, string);
            return object;
        }
    }

    public synchronized void initMAFAgentSystem(MAFAgentSystem mAFAgentSystem) throws MAFExtendedException {
        try {
            int n;
            if (initialized) {
                return;
            }
            initialized = true;
            String string = InetAddress.getLocalHost().getHostName();
            Properties properties = System.getProperties();
            String string2 = properties.getProperty("maf.port", String.valueOf(4434));
            try {
                n = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                n = 4434;
                System.err.println("maf.port must be a number, use 4434");
            }
            ((Hashtable)properties).put("maf.port", String.valueOf(n));
            mAFAgentSystem.setAddress("rmi://" + string + ":" + n);
        }
        catch (Exception exception) {
            throw new MAFExtendedException(exception.toString());
        }
    }

    static MAFAgentSystem_RMI rebind(MAFAgentSystem_RMI mAFAgentSystem_RMI) {
        if (!rmi_agentsystems.contains(mAFAgentSystem_RMI)) {
            return null;
        }
        Enumeration enumeration = rmi_agentsystems.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Object v = rmi_agentsystems.get(string);
            if (v != mAFAgentSystem_RMI) continue;
            System.out.println("rebind found.. " + string);
            String string2 = "//" + string + "/aglets";
            int n = 1;
            while (n++ < MAX_RETRY) {
                try {
                    MAFAgentSystem_RMI mAFAgentSystem_RMI2 = (MAFAgentSystem_RMI)Naming.lookup(string2);
                    rmi_agentsystems.put(string, mAFAgentSystem_RMI2);
                    return mAFAgentSystem_RMI2;
                }
                catch (Exception exception) {
                    try {
                        Thread.currentThread();
                        Thread.sleep(1L);
                    }
                    catch (InterruptedException interruptedException) {
                        return null;
                    }
                }
            }
        }
        return null;
    }

    public void startMAFAgentSystem(MAFAgentSystem mAFAgentSystem) throws MAFExtendedException {
        block6: {
            try {
                MAFAgentSystem_RMIImpl mAFAgentSystem_RMIImpl = new MAFAgentSystem_RMIImpl(mAFAgentSystem);
                URL uRL = new URL(mAFAgentSystem.getAddress());
                Registry registry = LocateRegistry.createRegistry(uRL.getPort());
                registry.bind("aglets", mAFAgentSystem_RMIImpl);
                try {
                    MAFFinder mAFFinder = mAFAgentSystem.get_MAFFinder();
                    if (mAFFinder == null) break block6;
                    try {
                        AgentSystemInfo agentSystemInfo = mAFAgentSystem.get_agent_system_info();
                        String string = mAFAgentSystem.getAddress();
                        mAFFinder.register_agent_system(agentSystemInfo.agent_system_name, string, agentSystemInfo);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                catch (FinderNotFound finderNotFound) {}
            }
            catch (Exception exception) {
                throw new MAFExtendedException(exception.toString());
            }
        }
    }
}

