/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.maf.rmi;

import com.ibm.maf.MAFFinder;
import com.ibm.maf.Name;
import com.ibm.maf.rmi.LocationInfo;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.List;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.FileInputStream;
import java.io.IOException;
import java.rmi.Naming;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;

public class MAFFinderViewer
extends Frame
implements WindowListener,
ActionListener {
    private String _finder_url = "rmi://localhost:4435/MAFFinder";
    private MAFFinder _finder = null;
    private Button _update_button;
    private Button _connect_button;
    private TextField _finder_host;
    private TextField _finder_name;
    private TextField _finder_port;
    private List _list_agents;
    private List _list_places;
    private List _list_agent_systems;

    public MAFFinderViewer() {
        this.setTitle("MAFFinderViewer: NOT CONNECTED");
        this.addWindowListener(this);
        this.setLayout(new BorderLayout());
        Font font = Font.decode("Courier");
        this._list_agents = new List();
        this._list_places = new List();
        this._list_agent_systems = new List();
        this._list_agents.setFont(font);
        this._list_places.setFont(font);
        this._list_agent_systems.setFont(font);
        Panel panel = new Panel(new BorderLayout());
        panel.add((Component)new Label("Agents"), "North");
        panel.add(this._list_agents);
        Panel panel2 = new Panel(new BorderLayout());
        Panel panel3 = new Panel(new BorderLayout());
        panel2.add((Component)new Label("Places"), "North");
        panel2.add((Component)this._list_places, "Center");
        panel3.add((Component)new Label("Agent Systems"), "North");
        panel3.add((Component)this._list_agent_systems, "Center");
        Panel panel4 = new Panel(new GridLayout(1, 2));
        panel4.add(panel2);
        panel4.add(panel3);
        Panel panel5 = new Panel(new GridLayout(2, 1));
        panel5.add(panel);
        panel5.add(panel4);
        this._update_button = new Button("Update");
        this._update_button.addActionListener(this);
        this._connect_button = new Button("Reconnect");
        this._connect_button.addActionListener(this);
        Panel panel6 = new Panel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        panel6.setLayout(gridBagLayout);
        Label label = new Label("host name");
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        panel6.add(label);
        label = new Label("port");
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        panel6.add(label);
        label = new Label("name");
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        panel6.add(label);
        label = new Label("Finder Address");
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 0;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        panel6.add(label);
        this._finder_host = new TextField("localhost", 20);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagLayout.setConstraints(this._finder_host, gridBagConstraints);
        panel6.add(this._finder_host);
        this._finder_port = new TextField(Integer.toString(4435), 4);
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagLayout.setConstraints(this._finder_port, gridBagConstraints);
        panel6.add(this._finder_port);
        this._finder_name = new TextField("MAFFinder", 10);
        gridBagConstraints.gridx = 3;
        gridBagLayout.setConstraints(this._finder_name, gridBagConstraints);
        panel6.add(this._finder_name);
        gridBagConstraints.gridx = 4;
        gridBagLayout.setConstraints(this._connect_button, gridBagConstraints);
        panel6.add(this._connect_button);
        this.add((Component)panel6, "North");
        this.add((Component)panel5, "Center");
        Panel panel7 = new Panel();
        panel7.add(this._update_button);
        this.add((Component)panel7, "South");
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if ("Update".equals(actionEvent.getActionCommand())) {
            this.update_lists();
            this.repaint();
        } else if ("Reconnect".equals(actionEvent.getActionCommand())) {
            this.setFinderAddress(this._finder_host.getText().trim(), this._finder_port.getText().trim(), this._finder_name.getText().trim());
            try {
                this.connect();
                this.update_lists();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.repaint();
        }
    }

    private void connect() throws Exception {
        this._finder = (MAFFinder)Naming.lookup(this.getFinderAddress());
    }

    private String getFinderAddress() {
        return this._finder_url;
    }

    public static void main(String[] stringArray) throws Exception {
        MAFFinderViewer mAFFinderViewer = new MAFFinderViewer();
        if (stringArray.length > 0) {
            try {
                mAFFinderViewer.readProperties(stringArray[0]);
            }
            catch (IOException iOException) {
                System.err.println("Cannot read property file: " + stringArray[0]);
                System.exit(1);
            }
        }
        try {
            mAFFinderViewer.connect();
            mAFFinderViewer.update_lists();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        mAFFinderViewer.pack();
        mAFFinderViewer.show();
    }

    private void readProperties(String string) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(string);
        Properties properties = new Properties();
        properties.load(fileInputStream);
        String string2 = properties.getProperty("maf.finder.host", "localhost");
        String string3 = properties.getProperty("maf.finder.port", Integer.toString(4435));
        String string4 = properties.getProperty("maf.finder.name", "MAFFinder");
        this.setFinderAddress(string2, string3, string4);
    }

    private void setFinderAddress(String string) {
        this._finder_url = string;
    }

    private void setFinderAddress(String string, String string2, String string3) {
        this._finder_url = "rmi://" + string;
        if (string2 != null) {
            this._finder_url = this._finder_url + ":" + string2;
        }
        this._finder_url = this._finder_url + "/" + string3;
    }

    private void update_list_agent_systems() throws Exception {
        if (this._finder != null) {
            this._list_agent_systems.removeAll();
            Hashtable hashtable = this._finder.list_agent_system_entries();
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                Name name = (Name)enumeration.nextElement();
                LocationInfo locationInfo = (LocationInfo)hashtable.get(name);
                this._list_agent_systems.add(name.toString() + " = " + locationInfo.getLocation());
            }
        }
    }

    private void update_list_agents() throws Exception {
        if (this._finder != null) {
            this._list_agents.removeAll();
            Hashtable hashtable = this._finder.list_agent_entries();
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                Name name = (Name)enumeration.nextElement();
                LocationInfo locationInfo = (LocationInfo)hashtable.get(name);
                this._list_agents.add(name.toString() + " = " + locationInfo.getLocation());
            }
        }
    }

    private void update_list_places() throws Exception {
        if (this._finder != null) {
            this._list_places.removeAll();
            Hashtable hashtable = this._finder.list_place_entries();
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                this._list_places.add(string);
            }
        }
    }

    private void update_lists() {
        try {
            this.setTitle("MAFFinder: " + this.getFinderAddress());
            this.update_list_agents();
            this.update_list_places();
            this.update_list_agent_systems();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        System.exit(0);
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }
}

