/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.maf.rmi;

import com.ibm.maf.AgentProfile;
import com.ibm.maf.AgentSystemInfo;
import com.ibm.maf.EntryNotFound;
import com.ibm.maf.MAFFinder;
import com.ibm.maf.Name;
import com.ibm.maf.NameInvalid;
import com.ibm.maf.rmi.LocationInfo;
import com.ibm.maf.rmi.MAFFinder_InfoFrame;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class MAFFinder_RMIImpl
extends UnicastRemoteObject
implements MAFFinder {
    private static boolean _verbose = false;
    public static final String REGISTRY_NAME = "MAFFinder";
    public static final int REGISTRY_PORT = 4435;
    private Hashtable _agent_systems = new Hashtable();
    private Hashtable _places = new Hashtable();
    private Hashtable _agents = new Hashtable();

    public Hashtable list_agent_entries() throws RemoteException {
        return this._agents;
    }

    public Hashtable list_agent_system_entries() throws RemoteException {
        return this._agent_systems;
    }

    public Hashtable list_place_entries() throws RemoteException {
        return this._places;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String[] lookup_agent(Name name, AgentProfile agentProfile) throws EntryNotFound, RemoteException {
        Object[] objectArray;
        MAFFinder_RMIImpl.VerbosePrintln("lookup_agent: " + name.toString());
        if (name != null) {
            LocationInfo locationInfo = (LocationInfo)this._agents.get(name);
            if (locationInfo == null) throw new EntryNotFound();
            objectArray = new String[]{locationInfo.getLocation()};
            return objectArray;
        } else {
            Vector<String> vector = new Vector<String>();
            Enumeration enumeration = this._agents.elements();
            while (enumeration.hasMoreElements()) {
                LocationInfo locationInfo = (LocationInfo)enumeration.nextElement();
                if (!locationInfo.matchAgentProfile(agentProfile)) continue;
                vector.addElement(locationInfo.getLocation());
            }
            if (vector.size() == 0) {
                throw new EntryNotFound();
            }
            objectArray = new String[vector.size()];
            vector.copyInto(objectArray);
        }
        return objectArray;
    }

    public String[] lookup_agent_system(Name name, AgentSystemInfo agentSystemInfo) throws EntryNotFound, RemoteException {
        MAFFinder_RMIImpl.VerbosePrintln("lookup_agent_system: " + name.toString());
        if (name != null) {
            LocationInfo locationInfo = (LocationInfo)this._agent_systems.get(name);
            if (locationInfo != null) {
                String[] stringArray = new String[]{locationInfo.getLocation()};
                return stringArray;
            }
            throw new EntryNotFound();
        }
        Vector<String> vector = new Vector<String>();
        Enumeration enumeration = this._agent_systems.elements();
        while (enumeration.hasMoreElements()) {
            LocationInfo locationInfo = (LocationInfo)enumeration.nextElement();
            if (!locationInfo.matchAgentSystemInfo(agentSystemInfo)) continue;
            vector.addElement(locationInfo.getLocation());
        }
        if (vector.size() == 0) {
            throw new EntryNotFound();
        }
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public String[] lookup_place(String string) throws EntryNotFound, RemoteException {
        MAFFinder_RMIImpl.VerbosePrintln("lookup_place: " + string);
        String string2 = (String)this._places.get(string);
        if (string2 == null) {
            throw new EntryNotFound();
        }
        String[] stringArray = new String[]{string2};
        return stringArray;
    }

    public static void main(String[] stringArray) throws Exception {
        String string = REGISTRY_NAME;
        int n = 4435;
        if (stringArray.length > 0) {
            int n2 = 0;
            while (n2 < stringArray.length) {
                if (stringArray[n2].equalsIgnoreCase("-verbose")) {
                    _verbose = true;
                } else if (stringArray[n2].equalsIgnoreCase("-help")) {
                    MAFFinder_RMIImpl.usage();
                } else if (n2 + 1 < stringArray.length) {
                    if (stringArray[n2].equalsIgnoreCase("-port")) {
                        n = Integer.parseInt(stringArray[n2 + 1]);
                        ++n2;
                    } else if (stringArray[n2].equalsIgnoreCase("-name")) {
                        string = stringArray[n2 + 1];
                        ++n2;
                    } else {
                        MAFFinder_RMIImpl.usage();
                    }
                } else {
                    MAFFinder_RMIImpl.usage();
                }
                ++n2;
            }
        }
        MAFFinder_RMIImpl mAFFinder_RMIImpl = new MAFFinder_RMIImpl();
        mAFFinder_RMIImpl.startFinder(string, n);
        String string2 = System.getProperties().getProperty("install.root");
        if (string2 != null) {
            MAFFinder_InfoFrame mAFFinder_InfoFrame = new MAFFinder_InfoFrame(string, n);
            mAFFinder_InfoFrame.pack();
            mAFFinder_InfoFrame.show();
        }
    }

    public void register_agent(Name name, String string, AgentProfile agentProfile) throws NameInvalid, RemoteException {
        MAFFinder_RMIImpl.VerbosePrintln("register_agent:");
        MAFFinder_RMIImpl.VerbosePrintln(" name:\t" + name.toString());
        MAFFinder_RMIImpl.VerbosePrintln(" location:\t" + string);
        this._agents.put(name, new LocationInfo(string, agentProfile));
    }

    public void register_agent_system(Name name, String string, AgentSystemInfo agentSystemInfo) throws NameInvalid, RemoteException {
        MAFFinder_RMIImpl.VerbosePrintln("register_agent_system:");
        MAFFinder_RMIImpl.VerbosePrintln(" name:\t" + name.toString());
        MAFFinder_RMIImpl.VerbosePrintln(" location:\t" + string);
        LocationInfo locationInfo = (LocationInfo)this._agent_systems.get(name);
        if (locationInfo != null) {
            throw new NameInvalid();
        }
        this._agent_systems.put(name, new LocationInfo(string, agentSystemInfo));
    }

    public void register_place(String string, String string2) throws NameInvalid, RemoteException {
        MAFFinder_RMIImpl.VerbosePrintln("register_place:");
        MAFFinder_RMIImpl.VerbosePrintln(" name:\t" + string);
        MAFFinder_RMIImpl.VerbosePrintln(" location:\t" + string2);
        String string3 = (String)this._places.get(string);
        if (string3 != null) {
            throw new NameInvalid();
        }
        this._places.put(string, string2);
    }

    public void startFinder(String string, int n) throws RemoteException {
        Registry registry = LocateRegistry.createRegistry(n);
        registry.rebind(string, this);
        System.out.println("MAFFinder bound in local registry");
        System.out.println("\tname: " + new String(string));
        System.out.println("\tport: " + n);
    }

    public void unregister_agent(Name name) throws EntryNotFound, RemoteException {
        MAFFinder_RMIImpl.VerbosePrintln("unregister_agent:");
        MAFFinder_RMIImpl.VerbosePrintln(" name:\t" + name.toString());
        Object v = this._agents.remove(name);
        if (v == null) {
            throw new EntryNotFound();
        }
    }

    public void unregister_agent_system(Name name) throws EntryNotFound, RemoteException {
        MAFFinder_RMIImpl.VerbosePrintln("unregister_agent_system:");
        MAFFinder_RMIImpl.VerbosePrintln(" name:\t" + name.toString());
        Object v = this._agent_systems.remove(name);
        if (v == null) {
            throw new EntryNotFound();
        }
    }

    public void unregister_place(String string) throws EntryNotFound, RemoteException {
        MAFFinder_RMIImpl.VerbosePrintln("unregister_place:");
        MAFFinder_RMIImpl.VerbosePrintln(" name:\t" + string);
        Object v = this._places.remove(string);
        if (v == null) {
            throw new EntryNotFound();
        }
    }

    private static void usage() {
        System.err.println("\nMAFFinder(com.ibm.maf.rmi.MAFFinder_RMIImpl) usage:");
        System.err.print("  options: [-name <name>]  ");
        System.err.println("name to register(default MAFFinder)");
        System.err.print("           [-port <num>]   ");
        System.err.println("registry port(default 4435)");
        System.err.print("           [-verbose]      ");
        System.err.println("verbose output");
        System.err.print("           [-help]         ");
        System.err.println("print this message");
        System.exit(1);
    }

    private static void VerbosePrint(String string) {
        if (_verbose) {
            System.err.print(string);
        }
    }

    private static void VerbosePrintln(String string) {
        if (_verbose) {
            System.err.println(string);
        }
    }
}

