/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.net.protocol.rmi;

import com.ibm.awb.misc.Resource;
import com.ibm.maf.AgentProfile;
import com.ibm.maf.MAFAgentSystem;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Hashtable;
import java.util.Properties;

public class URLConnectionForRMI
extends URLConnection {
    protected static boolean verbose = false;
    static AgentProfile agent_profile = null;
    private InputStream _inputStream = null;
    MAFAgentSystem agentsystem;
    Properties request_properties = new Properties();
    private Properties headers = new Properties();

    public URLConnectionForRMI(URL uRL) throws IOException {
        super(uRL);
    }

    public synchronized void connect() throws IOException {
        if (this.connected) {
            return;
        }
        this.agentsystem = MAFAgentSystem.getMAFAgentSystem(this.url.toString());
        if (this.agentsystem == null) {
            throw new IOException("ConnectionFailed");
        }
        this.connected = true;
    }

    public String getHeaderField(String string) {
        return this.headers.getProperty(string.toLowerCase());
    }

    public String getHeaderField(String string, String string2) {
        String string3 = this.getHeaderField(string);
        return string3 == null ? string2 : string3;
    }

    public synchronized InputStream getInputStream() throws IOException {
        if (this._inputStream != null) {
            return this._inputStream;
        }
        this.connect();
        if (!this.connected) {
            return null;
        }
        try {
            byte[][] byArray = this.agentsystem.fetch_class(null, this.url.toString(), agent_profile);
            ((Hashtable)this.headers).put("content-length", String.valueOf(byArray[0].length));
            if (byArray != null && byArray.length == 1) {
                this._inputStream = new ByteArrayInputStream(byArray[0]);
            }
            return this._inputStream;
        }
        catch (Exception exception) {
            throw new IOException(exception.getClass().getName() + ":" + exception.getMessage());
        }
    }

    public String getRequestProperty(String string) {
        return this.request_properties.getProperty(string);
    }

    public void setRequestProperty(String string, String string2) {
        if (this.connected) {
            throw new IllegalAccessError("Already connected");
        }
        ((Hashtable)this.request_properties).put(string, string2);
    }

    static {
        Resource resource = Resource.getResourceFor("aglets");
        verbose = resource.getBoolean("aglets.verbose", false);
        short s = 1;
        agent_profile = new AgentProfile(s, s, "Aglets", s, s, s, null);
    }
}

